/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.statistics.testingstatus;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.requirement.RequirementStatisticsService;
import org.squashtest.tm.service.statistics.requirement.RequirementVersionBundleStat;
import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatistics;
import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatisticsDictionary;
import org.squashtest.tm.service.statistics.testingstatus.RemoteTestingStatusDao;
import org.squashtest.tm.service.statistics.testingstatus.RemoteTestingStatusService;
import org.squashtest.tm.service.statistics.testingstatus.RequirementsByRemoteKeyByServerId;

@Service
@Transactional(readOnly=true)
public class RemoteTestingStatusServiceImpl
implements RemoteTestingStatusService {
    private final RequirementStatisticsService requirementStatisticsService;
    private final RemoteSynchronisationDao remoteSynchronisationDao;
    private final RemoteTestingStatusDao remoteTestingStatusDao;

    @Autowired
    public RemoteTestingStatusServiceImpl(RequirementStatisticsService requirementStatisticsService, RemoteSynchronisationDao remoteSynchronisationDao, RemoteTestingStatusDao remoteTestingStatusDao) {
        this.remoteTestingStatusDao = remoteTestingStatusDao;
        this.requirementStatisticsService = requirementStatisticsService;
        this.remoteSynchronisationDao = remoteSynchronisationDao;
    }

    @Override
    public RemoteRequirementStatisticsDictionary getRemoteRequirementStatisticsDictionary(String remoteSynchronisationKind) {
        List<RemoteSynchronisation> synchronisations = this.remoteSynchronisationDao.findByKind(remoteSynchronisationKind);
        if (!synchronisations.isEmpty()) {
            RequirementsByRemoteKeyByServerId reqsByRemoteKeyByServerId = this.remoteTestingStatusDao.findRequirementsByRemoteKeyByServerId(remoteSynchronisationKind);
            RequirementVersionBundleStat bundleStat = this.requirementStatisticsService.findSimplifiedCoverageStats(remoteSynchronisationKind);
            Map<Long, RequirementVersionBundleStat.SimpleRequirementStats> reqStatsById = bundleStat.getRequirementStats();
            Map<Long, List<String>> issueRemoteKeyBySynchronisationId = this.findAllSynchronisedKeys(synchronisations);
            Map<RemoteRequirementStatisticsDictionary.RemoteKeyAndServerId, Map<Long, RemoteRequirementStatistics>> combined = this.getCombinedStats(reqsByRemoteKeyByServerId, reqStatsById, synchronisations, issueRemoteKeyBySynchronisationId);
            Map<RemoteRequirementStatisticsDictionary.RemoteKeyAndServerId, RemoteRequirementStatistics> merged = this.getMergedStats(combined);
            return new RemoteRequirementStatisticsDictionary(combined, merged);
        }
        return new RemoteRequirementStatisticsDictionary(new HashMap<RemoteRequirementStatisticsDictionary.RemoteKeyAndServerId, Map<Long, RemoteRequirementStatistics>>(), new HashMap<RemoteRequirementStatisticsDictionary.RemoteKeyAndServerId, RemoteRequirementStatistics>());
    }

    private Map<RemoteRequirementStatisticsDictionary.RemoteKeyAndServerId, Map<Long, RemoteRequirementStatistics>> getCombinedStats(RequirementsByRemoteKeyByServerId reqsByRemoteKeyByServerId, Map<Long, RequirementVersionBundleStat.SimpleRequirementStats> reqStatsById, List<RemoteSynchronisation> synchronisations, Map<Long, List<String>> issueRemoteKeyBySynchronisationId) {
        HashMap<RemoteRequirementStatisticsDictionary.RemoteKeyAndServerId, Map<Long, RemoteRequirementStatistics>> combinedStats = new HashMap<RemoteRequirementStatisticsDictionary.RemoteKeyAndServerId, Map<Long, RemoteRequirementStatistics>>();
        synchronisations.stream().filter(RemoteSynchronisation::isSynchronisationEnable).forEach(remoteSynchronisation -> {
            if (issueRemoteKeyBySynchronisationId.containsKey(remoteSynchronisation.getId())) {
                Long serverId = remoteSynchronisation.getServer().getId();
                Map<String, List<Long>> reqIdsByRemoteKey = reqsByRemoteKeyByServerId.getRequirementsByRemoteKeyForServerId(serverId);
                List issueRemoteKeys = (List)issueRemoteKeyBySynchronisationId.get(remoteSynchronisation.getId());
                issueRemoteKeys.forEach(issueRemoteKey -> {
                    List reqIds = reqIdsByRemoteKey.getOrDefault(issueRemoteKey, Collections.emptyList());
                    Map statsByReqId = reqIds.stream().filter(reqStatsById::containsKey).collect(Collectors.toMap(Function.identity(), key -> this.asRemoteStats((RequirementVersionBundleStat.SimpleRequirementStats)reqStatsById.get(key))));
                    RemoteRequirementStatisticsDictionary.RemoteKeyAndServerId compositeKey = new RemoteRequirementStatisticsDictionary.RemoteKeyAndServerId((String)issueRemoteKey, serverId);
                    combinedStats.computeIfAbsent(compositeKey, key -> new HashMap()).putAll(statsByReqId);
                });
            }
        });
        return combinedStats;
    }

    private Map<RemoteRequirementStatisticsDictionary.RemoteKeyAndServerId, RemoteRequirementStatistics> getMergedStats(Map<RemoteRequirementStatisticsDictionary.RemoteKeyAndServerId, Map<Long, RemoteRequirementStatistics>> combinedStats) {
        return combinedStats.entrySet().stream().map(entry -> Map.entry((RemoteRequirementStatisticsDictionary.RemoteKeyAndServerId)entry.getKey(), this.flattenStats((Map)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private RemoteRequirementStatistics flattenStats(Map<Long, RemoteRequirementStatistics> stats) {
        return RemoteRequirementStatistics.merging(stats.values());
    }

    private RemoteRequirementStatistics asRemoteStats(RequirementVersionBundleStat.SimpleRequirementStats simpleRequirementStats) {
        return RemoteRequirementStatistics.fromSimpleStats(simpleRequirementStats);
    }

    private Map<Long, List<String>> findAllSynchronisedKeys(List<RemoteSynchronisation> remoteSynchronisations) {
        return this.remoteTestingStatusDao.findSynchronisedKeysBySynchronisationId(remoteSynchronisations.stream().map(RemoteSynchronisation::getId).toList());
    }
}

