/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.security;

import java.util.ArrayList;
import java.util.Collection;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.aspectj.runtime.internal.Conversions;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;

public final class UserBuilder {
    private String login;
    private String password;
    private boolean enabled;
    private Boolean accountNonExpired;
    private Boolean credentialsNonExpired;
    private Boolean accountNonLocked;
    private Collection<? extends GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(0);

    private UserBuilder() {
    }

    public static UserBuilder forUser(@NotBlank String login) {
        UserBuilder builder = new UserBuilder();
        builder.login = login;
        return builder;
    }

    public static UserBuilder duplicate(@NotNull UserDetails user) {
        UserDetails userDetails = user;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)userDetails);
        UserBuilder builder = new UserBuilder();
        builder.login = user.getUsername();
        builder.password = user.getPassword();
        builder.authorities = user.getAuthorities();
        builder.enabled = user.isEnabled();
        builder.accountNonExpired = user.isAccountNonExpired();
        builder.accountNonLocked = user.isAccountNonLocked();
        builder.credentialsNonExpired = user.isCredentialsNonExpired();
        return builder;
    }

    public UserBuilder password(@NotBlank String password) {
        this.password = password;
        return this;
    }

    public UserDetails build() {
        return new User(this.login, this.password, this.enabled, this.valueOrDefault(this.accountNonExpired), this.valueOrDefault(this.credentialsNonExpired), this.valueOrDefault(this.accountNonLocked), this.authorities);
    }

    private boolean valueOrDefault(Boolean potentialValue) {
        return potentialValue == null ? this.enabled : potentialValue;
    }

    public UserBuilder active(@NotNull boolean active) {
        boolean bl = active;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(Conversions.booleanObject((boolean)bl));
        this.enabled = active;
        return this;
    }
}

