/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.provisioning.JdbcUserDetailsManager;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManager;

public class SquashUserDetailsManagerImpl
extends JdbcUserDetailsManager
implements SquashUserDetailsManager {
    private static final String CHANGE_USER_LOGIN = "update AUTH_USER set LOGIN = ? where LOGIN = ?";

    @Override
    public void changeUserLogin(String newLogin, String oldLogin) {
        this.getJdbcTemplate().update(CHANGE_USER_LOGIN, new Object[]{newLogin, oldLogin});
    }

    @Override
    public List<GrantedAuthority> loadAuthoritiesByUsername(@NotNull String username) {
        String string = username;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)string);
        HashSet dbAuthsSet = new HashSet();
        if (this.getEnableAuthorities()) {
            dbAuthsSet.addAll(this.loadUserAuthorities(username));
        }
        if (this.getEnableGroups()) {
            dbAuthsSet.addAll(this.loadGroupAuthorities(username));
        }
        ArrayList<GrantedAuthority> dbAuths = new ArrayList<GrantedAuthority>(dbAuthsSet);
        this.addCustomAuthorities(username, dbAuths);
        return dbAuths;
    }
}

