/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.security.authentication.AuthenticationProviderFeatures;
import org.squashtest.tm.api.security.authentication.FeaturesAwareAuthentication;
import org.squashtest.tm.core.foundation.lang.Assert;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.internal.security.DefaultAuthenticationProviderFeatures;
import org.squashtest.tm.service.internal.security.SpringSecurityUserContextService;

@Component
public class AuthenticationProviderContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationProviderContext.class);
    @Value(value="${authentication.provider:internal}")
    private String[] currentProviderNames;
    @Inject
    private List<AuthenticationProviderFeatures> providersFeatures = new ArrayList<AuthenticationProviderFeatures>();
    private AuthenticationProviderFeatures defaultProviderFeature = DefaultAuthenticationProviderFeatures.INSTANCE;
    private boolean internalProviderEnabled = false;
    @Inject
    @Named(value="squashtest.core.user.UserContextService")
    private SpringSecurityUserContextService secService;

    public AuthenticationProviderFeatures getCurrentProviderFeatures() {
        Optional<AuthenticationProviderFeatures> optFeatures = this.secService.getUserContextAuthProviderFeatures();
        if (optFeatures.isPresent()) {
            return optFeatures.get();
        }
        return this.defaultProviderFeature;
    }

    public AuthenticationProviderFeatures getProviderFeatures(Authentication authentication) {
        AuthenticationProviderFeatures features = null;
        if (FeaturesAwareAuthentication.class.isAssignableFrom(authentication.getClass())) {
            features = ((FeaturesAwareAuthentication)authentication).getFeatures();
        }
        return features != null ? features : this.defaultProviderFeature;
    }

    public AuthenticationProviderFeatures getPrimaryProviderFeatures() {
        return this.defaultProviderFeature;
    }

    public boolean isInternalProviderEnabled() {
        return this.internalProviderEnabled;
    }

    @PostConstruct
    public void initializeContext() {
        this.checkConfiguration();
    }

    private void checkConfiguration() {
        if (this.currentProviderNames.length == 0) {
            LOGGER.error("The number of defined authentication.provider is {}", new Object[]{this.currentProviderNames.length});
            throw new IllegalStateException("currentPropertyName should not be empty");
        }
        Arrays.asList(this.currentProviderNames).forEach(name -> Assert.propertyNotBlank((String)name, (String)"currentPropertyName should not be blank"));
        List<String> knownProviders = this.providersFeatures.stream().map(AuthenticationProviderFeatures::getProviderName).toList();
        String[] stringArray = this.currentProviderNames;
        int n = this.currentProviderNames.length;
        int n2 = 0;
        while (n2 < n) {
            String providerName = stringArray[n2];
            if (!knownProviders.contains(providerName)) {
                String knownAsString = knownProviders.stream().collect(Collectors.joining(", "));
                LOGGER.error("Provider features named {} could not be found in list {}", new Object[]{providerName, this.providersFeatures});
                throw new IllegalStateException("\nAuthentication Provider named '" + providerName + "' was not found. Please review the application property 'authentication.provider'. \n" + "The default value 'internal' enables the  native authentication manager of Squash-TM. " + "To enable extra authentication providers (eg from a plugin) please refer to the documentation. \n" + "Providers currently loaded are : " + knownAsString);
            }
            LOGGER.trace("located the authentication provider features named '{}'", new Object[]{providerName});
            ++n2;
        }
        this.internalProviderEnabled = Arrays.asList(this.currentProviderNames).contains("internal");
        this.getCurrentProviderFeatures();
    }
}

