/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.acls.AclPermissionEvaluator;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.core.Authentication;
import org.springframework.util.CollectionUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.security.acls.ExtraPermissionEvaluator;

public class AffirmativeBasedCompositePermissionEvaluator
extends AclPermissionEvaluator
implements PermissionEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AffirmativeBasedCompositePermissionEvaluator.class);
    private Collection<ExtraPermissionEvaluator> evaluators = Collections.emptyList();

    public AffirmativeBasedCompositePermissionEvaluator(AclService aclService, Collection<ExtraPermissionEvaluator> delegates) {
        super(aclService);
        if (!CollectionUtils.isEmpty(delegates)) {
            this.evaluators = delegates;
            for (ExtraPermissionEvaluator evaluator : delegates) {
                LOGGER.info("Registering permission evaluator of class {}", new Object[]{evaluator.getClass()});
            }
        }
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        boolean granted = false;
        if (!this.evaluators.isEmpty()) {
            Iterator<ExtraPermissionEvaluator> evalIter = this.evaluators.iterator();
            while (evalIter.hasNext() && !granted) {
                ExtraPermissionEvaluator evaluator = evalIter.next();
                granted = evaluator.hasPermission(authentication, targetDomainObject, permission);
            }
        }
        return granted || super.hasPermission(authentication, targetDomainObject, permission);
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        boolean granted = false;
        if (!this.evaluators.isEmpty()) {
            Iterator<ExtraPermissionEvaluator> evalIter = this.evaluators.iterator();
            while (evalIter.hasNext() && !granted) {
                ExtraPermissionEvaluator evaluator = evalIter.next();
                granted = evaluator.hasPermission(authentication, targetId, targetType, permission);
            }
        }
        return granted || super.hasPermission(authentication, targetId, targetType, permission);
    }
}

