/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.scmserver;

import gherkin.ast.GherkinDocument;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bdd.BddImplementationTechnology;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.script.GherkinParser;
import org.squashtest.tm.domain.testautomation.AutomatedTestTechnology;
import org.squashtest.tm.domain.testcase.ExploratoryTestCase;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.exception.testcase.ScriptParsingException;
import org.squashtest.tm.service.internal.library.PathService;
import org.squashtest.tm.service.internal.testcase.event.TestCaseGherkinLocationChangeEvent;
import org.squashtest.tm.service.scmserver.ScmRepositoryFilesystemService;
import org.squashtest.tm.service.scmserver.ScmRepositoryManifest;
import org.squashtest.tm.service.testautomation.AutomatedTestTechnologyFinderService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.service.testcase.bdd.KeywordTestCaseService;

@Service(value="ScmRepositoryFilesystemService")
@Transactional(readOnly=true)
public class UnsecuredScmRepositoryFilesystemService
implements ScmRepositoryFilesystemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsecuredScmRepositoryFilesystemService.class);
    private static final String TEST_CASE_PATH_ILLEGAL_PATTERN = "[^a-zA-Z0-9\\_\\-\\/]";
    private static final String CANNOT_TRANSMIT_A_STANDARD_TEST_CASE = "Cannot transmit a Standard TestCase.";
    @Inject
    private ApplicationEventPublisher eventPublisher;
    @Inject
    private PathService pathService;
    @Inject
    private KeywordTestCaseService keywordTestCaseService;
    @Inject
    private TestCaseModificationService testCaseModificationService;
    @Inject
    private AutomatedTestTechnologyFinderService automatedTestTechnologyFinderService;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public void createWorkingFolderIfAbsent(ScmRepository scm) {
        File workingFolder = scm.getWorkingFolder();
        if (workingFolder.exists()) {
            LOGGER.trace("The working folder of repository '{}' already exists.", new Object[]{scm.getName()});
            return;
        }
        try {
            scm.doWithLock(() -> {
                this.tryCreateFolders(workingFolder);
                return null;
            });
        }
        catch (IOException iOEx) {
            throw new RuntimeException("Error while creating the working folder in the repository", iOEx);
        }
    }

    @Override
    public void deleteLocalRepositories(List<ScmRepository> repositories) {
        repositories.forEach(this::deleteLocalRepository);
    }

    private void deleteLocalRepository(ScmRepository scm) {
        try {
            scm.doWithLock(() -> {
                FileUtils.deleteDirectory((File)scm.getBaseRepositoryFolder());
                return null;
            });
        }
        catch (IOException iOEx) {
            throw new RuntimeException("Error while deleting the repository", iOEx);
        }
    }

    @Override
    public void createOrUpdateScriptFile(ScmRepository scm, Collection<TestCase> testCases) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("committing {} files to repository '{}'", new Object[]{testCases.size(), scm.getName()});
        }
        try {
            scm.doWithLock(() -> {
                LOGGER.trace("committing tests to scm : '{}'", new Object[]{scm.getName()});
                try {
                    ScmRepositoryManifest manifest = new ScmRepositoryManifest(scm);
                    for (TestCase testCase : testCases) {
                        File testFile = this.locateOrMoveOrCreateTestFile(manifest, testCase);
                        this.printToFile(testFile, testCase);
                        this.updateTestCaseAutomatedScriptInformation(testCase, testFile, manifest);
                    }
                    return null;
                }
                catch (IOException ex) {
                    throw new RuntimeException("Error while creating/updating files in the repository", ex);
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while creating/updating files in the repository", ex);
        }
    }

    public File locateOrMoveOrCreateTestFile(ScmRepositoryManifest manifest, TestCase testCase) throws IOException {
        File testfile;
        block5: {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("attempting to locate physical script file for test '{}' in the scm", new Object[]{testCase.getId()});
            }
            testfile = null;
            String pattern = this.createTestCasePatternForResearch(testCase);
            Optional<File> maybeTestFile = manifest.locateTest(pattern, testCase.getId());
            if (maybeTestFile.isPresent()) {
                testfile = maybeTestFile.get();
                LOGGER.trace("found file : '{}'", new Object[]{testfile.getAbsolutePath()});
                testfile = this.moveAndRenameFileIfNeeded(testCase, testfile, manifest.getScm());
            } else {
                LOGGER.trace("file not found, attempting to create a new one", new Object[0]);
                try {
                    testfile = this.createTestNominal(manifest.getScm(), testCase);
                }
                catch (IOException ex) {
                    if (!SystemUtils.IS_OS_WINDOWS) break block5;
                    LOGGER.trace("failed to create file due to IOException, attempting with the backup filename", (Throwable)ex);
                    testfile = this.createTestBackup(manifest.getScm(), testCase);
                }
            }
        }
        return testfile;
    }

    @Override
    public String createTestCasePatternForResearch(TestCase testCase) {
        final Wrapped pattern = new Wrapped();
        TestCaseVisitor visitor = new TestCaseVisitor(){

            public void visit(TestCase testCase) {
                throw new IllegalArgumentException(UnsecuredScmRepositoryFilesystemService.CANNOT_TRANSMIT_A_STANDARD_TEST_CASE);
            }

            public void visit(KeywordTestCase keywordTestCase) {
                pattern.setValue((Object)UnsecuredScmRepositoryFilesystemService.this.keywordTestCaseService.buildFilenameMatchPattern(keywordTestCase));
            }

            public void visit(ScriptedTestCase scriptedTestCase) {
                pattern.setValue((Object)scriptedTestCase.buildFilenameMatchPattern());
            }

            public void visit(ExploratoryTestCase exploratoryTestCase) {
                throw new IllegalArgumentException(UnsecuredScmRepositoryFilesystemService.CANNOT_TRANSMIT_A_STANDARD_TEST_CASE);
            }
        };
        testCase.accept(visitor);
        return (String)pattern.getValue();
    }

    @Override
    public boolean checkLocalRepositoryExists(String repositoryPath) {
        return FileUtils.getFile((String[])new String[]{repositoryPath}).exists();
    }

    private File moveAndRenameFileIfNeeded(TestCase testCase, File originalFile, ScmRepository scmRepository) {
        File workingDirectory = scmRepository.getWorkingFolder();
        String foldersPath = this.getFoldersPath(testCase);
        String correctStandardRelativePath = this.buildTestCaseStandardRelativePath(foldersPath, testCase);
        String correctBackupRelativePath = this.buildTestCaseBackUpRelativePath(foldersPath, testCase);
        String currentPath = workingDirectory.toURI().relativize(originalFile.toURI()).toString();
        if (!correctStandardRelativePath.equals(currentPath) && !correctBackupRelativePath.equals(currentPath)) {
            File targetStandardFile = new File(workingDirectory, correctStandardRelativePath);
            try {
                this.tryMoveFile(originalFile, targetStandardFile);
                this.eventPublisher.publishEvent((ApplicationEvent)new TestCaseGherkinLocationChangeEvent(testCase.getId(), String.valueOf(scmRepository.getScmServer().getUrl()) + "/" + scmRepository.getName() + "/" + correctStandardRelativePath));
                return targetStandardFile;
            }
            catch (IOException ex) {
                LOGGER.warn("Error while trying to move file, will try with the backup name", (Throwable)ex);
                File targetBackUpFile = new File(workingDirectory, correctBackupRelativePath);
                try {
                    this.tryMoveFile(originalFile, targetBackUpFile);
                    this.eventPublisher.publishEvent((ApplicationEvent)new TestCaseGherkinLocationChangeEvent(testCase.getId(), String.valueOf(scmRepository.getScmServer().getUrl()) + "/" + scmRepository.getName() + "/" + correctBackupRelativePath));
                    return targetBackUpFile;
                }
                catch (IOException ioEx) {
                    throw new RuntimeException("Could not move file due to IOException", ioEx);
                }
            }
        }
        return originalFile;
    }

    private String buildTestCaseStandardRelativePath(String foldersPath, TestCase testCase) {
        final Wrapped standardName = new Wrapped();
        TestCaseVisitor visitor = new TestCaseVisitor(){

            public void visit(TestCase testCase) {
                throw new IllegalArgumentException(UnsecuredScmRepositoryFilesystemService.CANNOT_TRANSMIT_A_STANDARD_TEST_CASE);
            }

            public void visit(KeywordTestCase keywordTestCase) {
                standardName.setValue((Object)UnsecuredScmRepositoryFilesystemService.this.keywordTestCaseService.createFileName(keywordTestCase));
            }

            public void visit(ScriptedTestCase scriptedTestCase) {
                standardName.setValue((Object)scriptedTestCase.createFilename());
            }

            public void visit(ExploratoryTestCase exploratoryTestCase) {
                throw new IllegalArgumentException(UnsecuredScmRepositoryFilesystemService.CANNOT_TRANSMIT_A_STANDARD_TEST_CASE);
            }
        };
        testCase.accept(visitor);
        return String.valueOf(foldersPath) + (String)standardName.getValue();
    }

    private String buildTestCaseBackUpRelativePath(String foldersPath, TestCase testCase) {
        final Wrapped backupName = new Wrapped();
        TestCaseVisitor visitor = new TestCaseVisitor(){

            public void visit(TestCase testCase) {
                throw new IllegalArgumentException(UnsecuredScmRepositoryFilesystemService.CANNOT_TRANSMIT_A_STANDARD_TEST_CASE);
            }

            public void visit(KeywordTestCase keywordTestCase) {
                backupName.setValue((Object)UnsecuredScmRepositoryFilesystemService.this.keywordTestCaseService.createBackupFileName(keywordTestCase));
            }

            public void visit(ScriptedTestCase scriptedTestCase) {
                backupName.setValue((Object)scriptedTestCase.createBackupFileName());
            }

            public void visit(ExploratoryTestCase exploratoryTestCase) {
                throw new IllegalArgumentException(UnsecuredScmRepositoryFilesystemService.CANNOT_TRANSMIT_A_STANDARD_TEST_CASE);
            }
        };
        testCase.accept(visitor);
        return String.valueOf(foldersPath) + (String)backupName.getValue();
    }

    private String getFoldersPath(TestCase testCase) {
        Project project = (Project)this.entityManager.find(Project.class, (Object)testCase.getProject().getId());
        if (!project.isUseTreeStructureInScmRepo()) {
            return "";
        }
        String testCaseFoldersPath = this.pathService.buildTestCaseFoldersPath(testCase.getId());
        if (testCaseFoldersPath != null) {
            return String.valueOf(this.normalizeFilePath(testCaseFoldersPath)) + "/";
        }
        return "";
    }

    private String normalizeFilePath(String path) {
        return StringUtils.stripAccents((String)path).replaceAll(TEST_CASE_PATH_ILLEGAL_PATTERN, "_");
    }

    private File createTestNominal(ScmRepository scm, TestCase testCase) throws IOException {
        String foldersPath = this.getFoldersPath(testCase);
        String fileRelativePath = this.buildTestCaseStandardRelativePath(foldersPath, testCase);
        return this.doCreateTestFile(scm, fileRelativePath);
    }

    public File createTestBackup(ScmRepository scm, TestCase testCase) throws IOException {
        String foldersPath = this.getFoldersPath(testCase);
        String fileRelativePath = this.buildTestCaseBackUpRelativePath(foldersPath, testCase);
        return this.doCreateTestFile(scm, fileRelativePath);
    }

    private File doCreateTestFile(ScmRepository scm, String filename) throws IOException {
        File workfolder = scm.getWorkingFolder();
        File newFile = new File(workfolder, filename);
        if (newFile.exists()) {
            LOGGER.warn("retrieved physical file '{}' while in the file creation routine... it should have been detected earlier. This is an abnormal situation. Anyway, this file ", new Object[]{newFile.getAbsolutePath()});
        } else {
            this.tryCreateFolders(newFile.getParentFile());
            newFile.createNewFile();
            LOGGER.trace("new file created : '{}'", new Object[]{newFile.getAbsolutePath()});
        }
        return newFile;
    }

    private void printToFile(File dest, TestCase testCase) throws IOException {
        final Wrapped content = new Wrapped();
        TestCaseVisitor visitor = new TestCaseVisitor(){

            public void visit(TestCase testCase) {
                throw new IllegalArgumentException("Cannot print STANDARD test case to file");
            }

            public void visit(KeywordTestCase keywordTestCase) {
                content.setValue((Object)UnsecuredScmRepositoryFilesystemService.this.keywordTestCaseService.writeScriptFromTestCase(keywordTestCase.getId(), false));
            }

            public void visit(ScriptedTestCase scriptedTestCase) {
                content.setValue((Object)scriptedTestCase.getScript());
            }

            public void visit(ExploratoryTestCase exploratoryTestCase) {
                throw new IllegalArgumentException("Cannot print EXPLORATORY test case to file");
            }
        };
        testCase.accept(visitor);
        try {
            FileUtils.write((File)dest, (CharSequence)((CharSequence)content.getValue()), (Charset)Charset.forName("UTF-8"));
        }
        catch (UnsupportedCharsetException ex) {
            LOGGER.debug("Could not print to file", (Throwable)ex);
            FileUtils.write((File)dest, (CharSequence)((CharSequence)content.getValue()), (Charset)Charset.defaultCharset());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryCreateFolders(File folder) throws IOException {
        if (!folder.mkdirs()) {
            if (!folder.isDirectory()) throw new IOException("directory could not be created at path " + folder.toString());
            LOGGER.trace("directory at path {} already exists.", new Object[]{folder.toString()});
            return;
        } else {
            LOGGER.trace("directory at path {} has been created.", new Object[]{folder.toString()});
        }
    }

    private File tryMoveFile(File sourceFile, File targetFile) throws IOException {
        File targetFileParent = targetFile.getParentFile();
        this.tryCreateFolders(targetFileParent);
        if (sourceFile.renameTo(targetFile)) {
            LOGGER.trace("file with path {} has been renamed to {}", new Object[]{sourceFile, targetFile});
            return targetFile;
        }
        throw new IOException("file with path " + sourceFile + " could not be move/renamed to file with path " + targetFile);
    }

    private void updateTestCaseAutomatedScriptInformation(TestCase testCase, File testCaseFile, ScmRepositoryManifest manifest) {
        this.testCaseModificationService.changeSourceCodeRepository(testCase.getId(), manifest.getScm().getId());
        Project project = (Project)this.entityManager.find(Project.class, (Object)testCase.getProject().getId());
        String featureOrTestCaseName = testCase.getName();
        AutomatedTestTechnology technology = null;
        if (testCase instanceof KeywordTestCase) {
            bddImplementationTechnology = project.getBddImplementationTechnology();
            technology = switch (bddImplementationTechnology) {
                case BddImplementationTechnology.ROBOT -> this.automatedTestTechnologyFinderService.findByName("Robot Framework");
                case BddImplementationTechnology.CUCUMBER_4 -> this.automatedTestTechnologyFinderService.findByName("Cucumber 4");
                case BddImplementationTechnology.CUCUMBER_5_PLUS -> this.automatedTestTechnologyFinderService.findByName("Cucumber 5+");
                default -> throw new IncompatibleClassChangeError();
            };
        } else if (testCase instanceof ScriptedTestCase) {
            featureOrTestCaseName = this.extractFeatureName((ScriptedTestCase)testCase);
            bddImplementationTechnology = project.getBddImplementationTechnology();
            technology = switch (bddImplementationTechnology) {
                case BddImplementationTechnology.CUCUMBER_4 -> this.automatedTestTechnologyFinderService.findByName("Cucumber 4");
                case BddImplementationTechnology.CUCUMBER_5_PLUS, BddImplementationTechnology.ROBOT -> this.automatedTestTechnologyFinderService.findByName("Cucumber 5+");
                default -> throw new IncompatibleClassChangeError();
            };
        }
        if (technology != null) {
            this.testCaseModificationService.changeAutomatedTestTechnology(testCase.getId(), technology.getId());
        }
        String automatedTestReference = String.format("%s/%s/%s#%s", manifest.getScm().getName(), manifest.getScm().getWorkingFolderPath(), manifest.getRelativePath(testCaseFile), featureOrTestCaseName);
        this.testCaseModificationService.changeAutomatedTestReference(testCase.getId(), PathUtils.cleanMultipleSlashes((String)automatedTestReference));
    }

    private String extractFeatureName(ScriptedTestCase testCase) {
        try {
            GherkinDocument gherkinDocument = GherkinParser.parseDocument((String)testCase.getScript());
            return gherkinDocument.getFeature().getName();
        }
        catch (ScriptParsingException spe) {
            LOGGER.warn("Could not extract feature name because of parsing error.", (Throwable)spe);
            return testCase.getName();
        }
    }
}

