/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.jooq.CommonTableExpression;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record1;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.security.acls.domain.BasePermission;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.api.security.acls.Permissions;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.project.LibraryPluginBinding;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.records.ProjectRecord;
import org.squashtest.tm.service.internal.display.dto.automatedexecutionenvironments.ExecutionEnvironmentCountProjectInfoDto;
import org.squashtest.tm.service.internal.repository.CustomProjectDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetIdParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

public class ProjectDaoImpl
extends HibernateEntityDao<Project>
implements CustomProjectDao {
    private static final String PROJECT_ID = "projectId";
    private static final String PROJECT_NAME = "projectName";
    @Inject
    private DSLContext dsl;
    @PersistenceContext
    private EntityManager em;

    @Override
    public long countNonFoldersInProject(long projectId) {
        SelectConditionStep requirementCount = DSL.selectCount().from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId));
        SelectConditionStep testCaseCount = DSL.selectCount().from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId));
        SelectConditionStep campaignCount = DSL.selectCount().from((TableLike)Tables.CAMPAIGN).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId));
        SelectConditionStep sprintCount = DSL.selectCount().from((TableLike)Tables.SPRINT).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId));
        SelectConditionStep sprintGroupCount = DSL.selectCount().from((TableLike)Tables.SPRINT_GROUP).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.SPRINT_GROUP.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Object)projectId));
        SelectConditionStep customReportCount = DSL.selectCount().from((TableLike)Tables.CUSTOM_REPORT_LIBRARY_NODE).innerJoin((TableLike)Tables.PROJECT).on(Tables.CUSTOM_REPORT_LIBRARY_NODE.CRL_ID.eq((Field)Tables.PROJECT.CRL_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId).and(Tables.CUSTOM_REPORT_LIBRARY_NODE.ENTITY_TYPE.notIn((Object[])new String[]{"LIBRARY", "FOLDER"})));
        return ((Integer)this.dsl.select((SelectField)DSL.sum((Field)DSL.field((Select)requirementCount)).add(DSL.field((Select)testCaseCount)).add(DSL.field((Select)campaignCount)).add(DSL.field((Select)sprintCount)).add(DSL.field((Select)sprintGroupCount)).add(DSL.field((Select)customReportCount))).fetchOneInto(Integer.class)).intValue();
    }

    @Override
    public long countNonFolderInActionWord(long projectId) {
        return (Long)this.executeEntityNamedQuery("project.countNonFolderInActionWord", this.idParameter(projectId));
    }

    private SetQueryParametersCallback idParameter(long id) {
        return new SetIdParameter(PROJECT_ID, id);
    }

    @Override
    public List<String> findUsersWhoCreatedTestCases(List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return Collections.emptyList();
        }
        Table distinctTclnCreatedBy = this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.CREATED_BY).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).asTable("DISTINCT_TCLN_CREATED_BY");
        Field createdBy = distinctTclnCreatedBy.field("CREATED_BY", String.class);
        return this.dsl.selectDistinct((SelectField)createdBy).from((TableLike)distinctTclnCreatedBy).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.CREATED_BY.eq(createdBy)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds)).orderBy((OrderField)createdBy).fetch(createdBy, String.class);
    }

    @Override
    public List<String> findUsersWhoModifiedTestCases(List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return Collections.emptyList();
        }
        Table distinctTclnLastModifiedBy = this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).where(Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY.isNotNull()).asTable("DISTINCT_TCLN_MODIFIED_BY");
        Field lastModifiedBy = distinctTclnLastModifiedBy.field("LAST_MODIFIED_BY", String.class);
        return this.dsl.selectDistinct((SelectField)lastModifiedBy).from((TableLike)distinctTclnLastModifiedBy).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE_LIBRARY_NODE.LAST_MODIFIED_BY.eq(lastModifiedBy)).innerJoin((TableLike)Tables.TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.TEST_CASE.TCLN_ID)).where(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.in(projectIds)).orderBy((OrderField)lastModifiedBy).fetch(lastModifiedBy, String.class);
    }

    @Override
    public List<String> findUsersWhoCreatedRequirementVersions(List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return Collections.emptyList();
        }
        Table distinctRlnCreatedBy = this.dsl.selectDistinct((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.CREATED_BY).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).asTable("DISTINCT_RLN_CREATED_BY");
        Field createdBy = distinctRlnCreatedBy.field("CREATED_BY", String.class);
        return this.dsl.selectDistinct((SelectField)createdBy).from((TableLike)distinctRlnCreatedBy).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT_LIBRARY_NODE.CREATED_BY.eq(createdBy)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.in(projectIds)).orderBy((OrderField)createdBy).fetch(createdBy, String.class);
    }

    @Override
    public List<String> findUsersWhoModifiedRequirementVersions(List<Long> projectIds) {
        if (projectIds.isEmpty()) {
            return Collections.emptyList();
        }
        Table distinctResourceLastModifiedBy = this.dsl.selectDistinct((SelectField)Tables.RESOURCE.LAST_MODIFIED_BY).from((TableLike)Tables.RESOURCE).where(Tables.RESOURCE.LAST_MODIFIED_BY.isNotNull()).asTable("DISTINCT_RESOURCE_MODIFIED_BY");
        Field lastModifiedBy = distinctResourceLastModifiedBy.field("LAST_MODIFIED_BY", String.class);
        return this.dsl.selectDistinct((SelectField)lastModifiedBy).from((TableLike)distinctResourceLastModifiedBy).innerJoin((TableLike)Tables.RESOURCE).on(Tables.RESOURCE.LAST_MODIFIED_BY.eq(lastModifiedBy)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION).on(Tables.RESOURCE.RES_ID.eq((Field)Tables.REQUIREMENT_VERSION.RES_ID)).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.PROJECT_ID.in(projectIds)).orderBy((OrderField)lastModifiedBy).fetch(lastModifiedBy, String.class);
    }

    @Override
    public List<String> findUsersWhoExecutedItpi(List<Long> projectIds) {
        return this.dsl.selectDistinct((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.LAST_EXECUTED_BY).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.in(projectIds)).and(Tables.ITERATION_TEST_PLAN_ITEM.LAST_EXECUTED_BY.isNotNull()).orderBy((OrderField)Tables.ITERATION_TEST_PLAN_ITEM.LAST_EXECUTED_BY).fetch((Field)Tables.ITERATION_TEST_PLAN_ITEM.LAST_EXECUTED_BY, String.class);
    }

    @Override
    public List<String> findUsersAssignedToItpi(List<Long> projectIds) {
        return this.dsl.selectDistinct((SelectField)Tables.CORE_USER.LOGIN).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).innerJoin((TableLike)Tables.CORE_USER).on(Tables.ITERATION_TEST_PLAN_ITEM.USER_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).innerJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.ITERATION).on(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).innerJoin((TableLike)Tables.CAMPAIGN).on(Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID.eq((Field)Tables.CAMPAIGN.CLN_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN.CLN_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).where(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.in(projectIds)).orderBy((OrderField)Tables.CORE_USER.LOGIN).fetch((Field)Tables.CORE_USER.LOGIN, String.class);
    }

    @Override
    public List<String> findProjectNamesByIds(List<Long> projectIds) {
        return this.dsl.select((SelectField)Tables.PROJECT.NAME).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.in(projectIds)).orderBy((OrderField)Tables.PROJECT.NAME).fetch((Field)Tables.PROJECT.NAME);
    }

    @Override
    @UsedInPlugin(value="Xsquash4Jira")
    public @UsedInPlugin(value="Xsquash4Jira") Long findIdByName(String name) {
        return (Long)this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.NAME.eq((Object)name)).fetchOne((Field)Tables.PROJECT.PROJECT_ID, Long.class);
    }

    @Override
    public List<Long> findAllProjectIds() {
        return this.findAllProjectIdsQuery().fetch((Field)Tables.PROJECT.PROJECT_ID, Long.class);
    }

    @Override
    public CommonTableExpression<Record1<Long>> findAllProjectIdsCte() {
        return this.getProjectCTE(this.findAllProjectIdsQuery());
    }

    @Override
    public boolean checkHasAtLeastOneReadableId(CommonTableExpression<Record1<Long>> projectIdsCte) {
        return this.dsl.fetchExists((Select)this.dsl.with(new CommonTableExpression[]{projectIdsCte}).selectFrom(projectIdsCte));
    }

    private <T> CommonTableExpression<Record1<T>> getProjectCTE(ResultQuery<Record1<T>> query) {
        return DSL.name((String)"PROJECT_CTE").fields("PROJECT_ID_CTE").as(query);
    }

    private ResultQuery<Record1<Long>> findAllProjectIdsQuery() {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_TYPE.eq((Object)"P"));
    }

    @Override
    public List<Long> findAllProjectIdsInListOrderedByName(List<Long> projectIds) {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_TYPE.eq((Object)"P")).and(Tables.PROJECT.PROJECT_ID.in(projectIds)).orderBy((OrderField)Tables.PROJECT.NAME).fetch((Field)Tables.PROJECT.PROJECT_ID, Long.class);
    }

    @Override
    public List<Long> findAllProjectIdsByPermission(List<Long> partyIds, int permission) {
        return this.findAllProjectIdsByPermissionMaskAndClassName(partyIds, permission, Project.class.getName(), (TableField<ProjectRecord, Long>)Tables.PROJECT.PROJECT_ID);
    }

    @Override
    public CommonTableExpression<Record1<Long>> findAllProjectIdsByPermissionCte(List<Long> partyIds, int permission) {
        return this.getProjectCTE(this.findAllProjectIdsByPermissionMaskAndClassNameQuery(partyIds, permission, Project.class.getName(), (TableField<ProjectRecord, Long>)Tables.PROJECT.PROJECT_ID));
    }

    @Override
    public List<Long> findAllProjectIdsByEligibleTCPermission(List<Long> partyIds, int permission) {
        List<Long> tclIdsByPermission = this.findAllProjectIdsByPermissionMaskAndClassName(partyIds, permission, "org.squashtest.tm.domain.testcase.TestCaseLibrary", (TableField<ProjectRecord, Long>)Tables.PROJECT.TCL_ID);
        return this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.EXPLORATORY_TEST_CASE.TCLN_ID)).where(Tables.MILESTONE.STATUS.notEqual((Object)MilestoneStatus.LOCKED.toString()).or(Tables.MILESTONE.STATUS.isNull()).and(Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNull()).and(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.isNull()).and(Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID.in(tclIdsByPermission))).fetch((Field)Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID, Long.class);
    }

    @Override
    public List<Long> findAllProjectAndTemplateIds() {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.PROJECT).fetch((Field)Tables.PROJECT.PROJECT_ID, Long.class);
    }

    @Override
    public List<Long> findAllProjectIdsOrderedByName(List<Long> partyIds) {
        String className = Project.class.getName();
        SelectConditionStep<Record1<Long>> selectGroupsWithGivenPermissionOnProjects = this.buildSelectGroupsWithGivenPermissionOnProjectsQuery(BasePermission.READ.getMask(), className);
        Table selectProjectIdAndNameAccordingToPartyPermissions = this.dsl.selectDistinct((SelectField)Tables.ACL_OBJECT_IDENTITY.IDENTITY.as(PROJECT_ID), (SelectField)Tables.PROJECT.NAME.as(PROJECT_NAME)).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).innerJoin((TableLike)Tables.ACL_OBJECT_IDENTITY).on(Tables.ACL_OBJECT_IDENTITY.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID)).innerJoin((TableLike)Tables.ACL_CLASS).on(Tables.ACL_CLASS.ID.eq((Field)Tables.ACL_OBJECT_IDENTITY.CLASS_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.PROJECT.PROJECT_ID.eq((Field)Tables.ACL_OBJECT_IDENTITY.IDENTITY)).where(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.in(partyIds)).and(Tables.ACL_CLASS.CLASSNAME.eq((Object)className)).and(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.in(selectGroupsWithGivenPermissionOnProjects)).asTable();
        return this.dsl.select((SelectField)selectProjectIdAndNameAccordingToPartyPermissions.field(PROJECT_ID)).from((TableLike)selectProjectIdAndNameAccordingToPartyPermissions).orderBy((OrderField)selectProjectIdAndNameAccordingToPartyPermissions.field(PROJECT_NAME)).fetch(selectProjectIdAndNameAccordingToPartyPermissions.field(PROJECT_ID), Long.class);
    }

    @Override
    public List<Long> findAllProjectIdsByPermissionMaskAndClassName(List<Long> partyIds, int permissionMask, String className, TableField<ProjectRecord, Long> libraryColumnField) {
        return this.findAllProjectIdsByPermissionMaskAndClassNameQuery(partyIds, permissionMask, className, libraryColumnField).fetchInto(Long.class);
    }

    private ResultQuery<Record1<Long>> findAllProjectIdsByPermissionMaskAndClassNameQuery(List<Long> partyIds, int permissionMask, String className, TableField<ProjectRecord, Long> libraryColumnField) {
        SelectConditionStep<Record1<Long>> selectGroupsWithGivenPermissionOnProjects = this.buildSelectGroupsWithGivenPermissionOnProjectsQuery(permissionMask, className);
        return this.dsl.selectDistinct((SelectField)Tables.PROJECT.PROJECT_ID).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).innerJoin((TableLike)Tables.ACL_OBJECT_IDENTITY).on(Tables.ACL_OBJECT_IDENTITY.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID)).innerJoin((TableLike)Tables.ACL_CLASS).on(Tables.ACL_CLASS.ID.eq((Field)Tables.ACL_OBJECT_IDENTITY.CLASS_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.ACL_OBJECT_IDENTITY.IDENTITY.eq(libraryColumnField)).where(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.in(partyIds)).and(Tables.ACL_CLASS.CLASSNAME.eq((Object)className)).and(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.in(selectGroupsWithGivenPermissionOnProjects));
    }

    @Override
    public List<Long> findAllProjectIdsForAutomationWriter(List<Long> partyIds) {
        return this.dsl.selectDistinct((SelectField)Tables.ACL_OBJECT_IDENTITY.IDENTITY).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).join((TableLike)Tables.ACL_OBJECT_IDENTITY).on(Tables.ACL_OBJECT_IDENTITY.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID)).join((TableLike)Tables.ACL_CLASS).on(Tables.ACL_CLASS.ID.eq((Field)Tables.ACL_OBJECT_IDENTITY.CLASS_ID)).join((TableLike)Tables.ACL_GROUP_PERMISSION).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID)).where(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.in(partyIds).and(Tables.ACL_CLASS.CLASSNAME.eq((Object)Project.class.getName())).and(Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK.eq((Object)Permissions.WRITE_AS_AUTOMATION.getMask()))).fetch((Field)Tables.ACL_OBJECT_IDENTITY.IDENTITY, Long.class);
    }

    @Override
    public Integer countProjectsAllowAutomationWorkflow() {
        return (Integer)((Record1)this.dsl.selectCount().from((TableLike)Tables.PROJECT).where(Tables.PROJECT.ALLOW_AUTOMATION_WORKFLOW.eq((Object)true)).fetchOne()).value1();
    }

    @Override
    public LibraryPluginBinding findPluginForProject(Long projectId, PluginType pluginType) {
        LibraryPluginBinding lpb;
        Query query = this.entityManager.createNamedQuery("Project.findPluginForProject");
        query.setParameter(PROJECT_ID, (Object)projectId);
        query.setParameter("pluginType", (Object)pluginType);
        try {
            lpb = (LibraryPluginBinding)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            return null;
        }
        return lpb;
    }

    @Override
    public void removeLibraryPluginBindingProperty(Long libraryPluginBindingId) {
        Query query = this.entityManager.createNativeQuery("delete from LIBRARY_PLUGIN_BINDING_PROPERTY where PLUGIN_BINDING_ID = :libraryPluginBindingId");
        query.setParameter("libraryPluginBindingId", (Object)libraryPluginBindingId);
        query.executeUpdate();
    }

    @Override
    public BigInteger countActivePluginInProject(long projectId) {
        Query query = this.em.createNativeQuery("Select count(*) from LIBRARY_PLUGIN_BINDING lpb INNER JOIN LIBRARY_PLUGIN_BINDING_PROPERTY as lpbp ON lpb.plugin_binding_id = lpbp.plugin_binding_id  where library_id = :projectId and active = true");
        query.setParameter(PROJECT_ID, (Object)projectId);
        return (BigInteger)query.getSingleResult();
    }

    @Override
    public List<Long> findAllManagedProjectIds(List<Long> partyIds) {
        return this.dsl.selectDistinct((SelectField)Tables.ACL_OBJECT_IDENTITY.IDENTITY).from((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).join((TableLike)Tables.ACL_OBJECT_IDENTITY).on(Tables.ACL_OBJECT_IDENTITY.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID)).join((TableLike)Tables.ACL_CLASS).on(Tables.ACL_CLASS.ID.eq((Field)Tables.ACL_OBJECT_IDENTITY.CLASS_ID)).join((TableLike)Tables.ACL_GROUP_PERMISSION).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID)).where(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.in(partyIds).and(Tables.ACL_CLASS.CLASSNAME.eq((Object)Project.class.getName())).and(Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK.eq((Object)Permissions.MANAGE_PROJECT.getMask())).and(Tables.ACL_GROUP_PERMISSION.CLASS_ID.eq((Field)Tables.ACL_CLASS.ID))).fetch((Field)Tables.ACL_OBJECT_IDENTITY.IDENTITY, Long.class);
    }

    @Override
    public Project fetchForAutomatedExecutionCreation(long projectId) {
        Query query = this.em.createNamedQuery("Project.fetchForAutomatedExecutionCreation");
        query.setParameter(PROJECT_ID, (Object)projectId);
        return (Project)query.getSingleResult();
    }

    @Override
    public String findAutomationWorkflowTypeByProjectId(Long projectId) {
        return (String)this.dsl.select((SelectField)Tables.PROJECT.AUTOMATION_WORKFLOW_TYPE).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchOneInto(String.class);
    }

    @Override
    public List<ExecutionEnvironmentCountProjectInfoDto> findProjectsAndServersByProjectIds(Set<Long> projectIds) {
        return this.dsl.select((SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.THIRD_PARTY_SERVER.SERVER_ID, (SelectField)Tables.THIRD_PARTY_SERVER.NAME).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.THIRD_PARTY_SERVER).on(Tables.THIRD_PARTY_SERVER.SERVER_ID.eq((Field)Tables.PROJECT.TA_SERVER_ID)).where(Tables.PROJECT.PROJECT_ID.in(projectIds)).fetchInto(ExecutionEnvironmentCountProjectInfoDto.class);
    }

    @Override
    public Project fetchByIterationIdForAutomatedExecutionCreation(long iterationId) {
        return (Project)this.em.createQuery("select project from Iteration it join it.campaign.project project where it.id = :id", Project.class).setParameter("id", (Object)iterationId).getSingleResult();
    }

    @Override
    public Project fetchByTestSuiteForAutomatedExecutionCreation(long testSuiteId) {
        return (Project)this.em.createQuery("select project from TestSuite suite join suite.iteration.campaign.project project where suite.id = :id", Project.class).setParameter("id", (Object)testSuiteId).getSingleResult();
    }

    @Override
    public List<Long> findTestCaseLibraryNodesIds(Long projectId) {
        return this.dsl.select((SelectField)Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).on(Tables.PROJECT.TCL_ID.eq((Field)Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchInto(Long.class);
    }

    @Override
    public List<Long> findRequirementLibraryNodesIds(Long projectId) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.REQUIREMENT_LIBRARY_CONTENT).on(Tables.PROJECT.RL_ID.eq((Field)Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchInto(Long.class);
    }

    @Override
    public List<Long> findCampaignLibraryNodesIds(Long projectId) {
        return this.dsl.select((SelectField)Tables.CAMPAIGN_LIBRARY_CONTENT.CONTENT_ID).from((TableLike)Tables.PROJECT).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_CONTENT).on(Tables.PROJECT.CL_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_CONTENT.LIBRARY_ID)).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchInto(Long.class);
    }

    private SelectConditionStep<Record1<Long>> buildSelectGroupsWithGivenPermissionOnProjectsQuery(int permissionMask, String classname) {
        return this.dsl.select((SelectField)Tables.ACL_GROUP.ID).from((TableLike)Tables.ACL_GROUP).innerJoin((TableLike)Tables.ACL_GROUP_PERMISSION).on(Tables.ACL_GROUP_PERMISSION.ACL_GROUP_ID.eq((Field)Tables.ACL_GROUP.ID)).innerJoin((TableLike)Tables.ACL_CLASS).on(Tables.ACL_CLASS.ID.eq((Field)Tables.ACL_GROUP_PERMISSION.CLASS_ID)).where(Tables.ACL_GROUP_PERMISSION.PERMISSION_MASK.eq((Object)permissionMask)).and(Tables.ACL_CLASS.CLASSNAME.eq((Object)classname));
    }
}

