/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.campaign.testplan.TestPlan;
import org.squashtest.tm.jooq.domain.tables.Sprint;
import org.squashtest.tm.service.internal.repository.SprintDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;

@Repository
public class HibernateSprintDao
extends HibernateEntityDao<org.squashtest.tm.domain.campaign.Sprint>
implements SprintDao {
    private final DSLContext dslContext;

    public HibernateSprintDao(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    @Override
    public List<org.squashtest.tm.domain.campaign.Sprint> findByRemoteSynchronisationIdAndRemoteSprintIds(Long remoteSynchronisationId, List<Long> remoteSprintIds) {
        return this.entityManager.createNamedQuery("Sprint.findByRemoteSynchronisationIdAndRemoteSprintIds", org.squashtest.tm.domain.campaign.Sprint.class).setParameter("remoteSynchronisationId", (Object)remoteSynchronisationId).setParameter("remoteSprintIds", remoteSprintIds).getResultList();
    }

    @Override
    public List<Long> findSquashSprintIdsHavingDeletedRemoteSprint(Long remoteSynchronisationId, List<Long> existingRemoteSprintIds) {
        return this.dslContext.select((SelectField)Sprint.SPRINT.CLN_ID.as("ID")).from((TableLike)Sprint.SPRINT).where(Sprint.SPRINT.REMOTE_SYNCHRONISATION_ID.eq((Object)remoteSynchronisationId)).and(Sprint.SPRINT.REMOTE_SPRINT_ID.notIn(existingRemoteSprintIds)).fetchInto(Long.class);
    }

    @Override
    public void deleteRemoteSynchronisationFromSprint(List<Long> remoteSyncIds) {
        this.entityManager.createNamedQuery("Sprint.deleteRemoteSynchronisationFromSprint").setParameter("remoteSyncIds", remoteSyncIds).executeUpdate();
    }

    @Override
    public void deleteRemoteSynchronisationFromSprintId(long sprintId) {
        this.entityManager.createNamedQuery("Sprint.deleteRemoteSynchronisationFromSprintId").setParameter("sprintId", (Object)sprintId).executeUpdate();
    }

    @Override
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public void updateRemoteStateOfSynchronisedSprintsByIds(List<Long> sprintIds, String status) {
        this.entityManager.createNamedQuery("Sprint.updateRemoteStateOfSynchronisedSprintsByIds").setParameter("status", (Object)status).setParameter("sprintIds", sprintIds).executeUpdate();
    }

    @Override
    public List<org.squashtest.tm.domain.campaign.Sprint> loadNodeForPaste(Collection<Long> ids) {
        List sprints = this.entityManager.createQuery(" SELECT distinct s FROM Sprint s left join fetch s.project p left join fetch s.attachmentList al left join fetch al.attachments a left join fetch a.content c WHERE s.id IN (:ids)", org.squashtest.tm.domain.campaign.Sprint.class).setParameter("ids", ids).setHint("hibernate.query.passDistinctThrough", (Object)false).getResultList();
        new EntityGraphQueryBuilder<org.squashtest.tm.domain.campaign.Sprint>(this.entityManager, org.squashtest.tm.domain.campaign.Sprint.class, "SELECT distinct s FROM Sprint s join fetch s.sprintReqVersions srv where s in :sprints").executeDistinctList(Map.of("sprints", sprints));
        this.entityManager.createQuery("select distinct tp from Sprint s join s.sprintReqVersions srv join srv.testPlan tp left join fetch tp.testPlanItems tpi left join fetch tpi.exploratorySessionOverview eso left join fetch eso.attachmentList al left join fetch al.attachments a left join fetch a.content c where s in :sprints", TestPlan.class).setParameter("sprints", (Object)sprints).setHint("hibernate.query.passDistinctThrough", (Object)false).getResultList();
        return sprints;
    }
}

