/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import com.querydsl.core.group.GroupBy;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.hibernate.HibernateQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.requirement.ExportRequirementData;
import org.squashtest.tm.domain.requirement.ManagementMode;
import org.squashtest.tm.domain.requirement.QRequirement;
import org.squashtest.tm.domain.requirement.QRequirementSyncExtender;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.library.HibernatePathService;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetIdParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetLibraryIdsCallback;
import org.squashtest.tm.service.internal.repository.hibernate.SetNodeContentParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetParamIdsParametersCallback;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;

@Repository
public class HibernateRequirementDao
extends HibernateEntityDao<Requirement>
implements RequirementDao {
    private static final String UNCHECKED = "unchecked";
    private static final String REQUIREMENT_IDS = "requirementIds";
    private static final String NODE_IDS = "nodeIds";
    @Inject
    DSLContext dsl;

    @Override
    public List<Long> fetchHighLevelRequirementVersionIds(List<Long> requirementVersionIds) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT_VERSION.RES_ID).from((TableLike)Tables.REQUIREMENT_VERSION).join((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.in(requirementVersionIds)).fetchInto(Long.class);
    }

    @Override
    public List<Requirement> findChildrenRequirements(long requirementId) {
        SetIdParameter setId = new SetIdParameter("requirementId", requirementId);
        return this.executeListNamedQuery("requirement.findChildrenRequirements", setId);
    }

    @Override
    public List<Long> findByRequirementVersion(Collection<Long> versionIds) {
        if (!versionIds.isEmpty()) {
            Query q = this.currentSession().getNamedQuery("requirement.findByRequirementVersion");
            q.setParameterList("versionIds", versionIds, (Type)LongType.INSTANCE);
            return q.list();
        }
        return new ArrayList<Long>();
    }

    @Override
    public List<ExportRequirementData> findRequirementToExportFromNodes(List<Long> params) {
        if (!params.isEmpty()) {
            return this.doFindRequirementToExportFromNodes(params);
        }
        return Collections.emptyList();
    }

    private List<ExportRequirementData> doFindRequirementToExportFromNodes(List<Long> params) {
        List<Requirement> rootReqs = this.findRootContentRequirement(params);
        List rootReqsIds = IdentifiedUtil.extractIds(rootReqs);
        HashSet<Long> nonRootReqNodesIds = new HashSet<Long>();
        List<Long> listReqNodeId = this.findDescendantRequirementIds(params);
        nonRootReqNodesIds.addAll(listReqNodeId);
        List<Long> listParentRequirementIds = this.findRequirementParents(params);
        nonRootReqNodesIds.addAll(listParentRequirementIds);
        nonRootReqNodesIds.addAll(params);
        nonRootReqNodesIds.removeAll(rootReqsIds);
        if (nonRootReqNodesIds.isEmpty()) {
            return this.formatExportResult(rootReqs, new ArrayList<Object[]>(0));
        }
        List<Requirement> nonRootReqs = this.findAllByIds(nonRootReqNodesIds);
        Collection<Object[]> listObject = this.addPathInfos(nonRootReqs);
        return this.formatExportResult(rootReqs, listObject);
    }

    private List<Long> findRequirementParents(List<Long> params) {
        Query query = this.currentSession().getNamedQuery("requirement.findRequirementParentIds");
        query.setParameterList(NODE_IDS, params);
        return query.list();
    }

    @Override
    public List<Long> findDescendantRequirementIds(Collection<Long> params) {
        Query query = this.currentSession().getNamedQuery("requirement.findRequirementDescendantIds");
        query.setParameterList(NODE_IDS, params);
        return query.list();
    }

    private Collection<Object[]> addPathInfos(List<Requirement> requirements) {
        if (!requirements.isEmpty()) {
            HashMap<Long, Object[]> exportInfosById = new HashMap<Long, Object[]>(requirements.size());
            for (Requirement requirement : requirements) {
                Object[] exportInfo = new Object[]{requirement, "", ""};
                exportInfosById.put(requirement.getId(), exportInfo);
            }
            SetRequirementsIdsParameterCallback newCallBack1 = new SetRequirementsIdsParameterCallback(exportInfosById.keySet());
            Session session = this.currentSession();
            Query q = session.getNamedQuery("requirement.findReqPaths");
            newCallBack1.setQueryParameters(q);
            List idAndReqPaths = q.list();
            this.addPathInfosToExportInfos(exportInfosById, idAndReqPaths, 2);
            q = session.getNamedQuery("requirement.findFolderPaths");
            newCallBack1.setQueryParameters(q);
            List folderPaths = q.list();
            this.addPathInfosToExportInfos(exportInfosById, folderPaths, 1);
            return exportInfosById.values();
        }
        return Collections.emptyList();
    }

    public void addPathInfosToExportInfos(Map<Long, Object[]> reqAndFolderPathAndReqPathById, List<Object[]> idAndPaths, int pathInfoIndex) {
        for (Object[] idAndPath : idAndPaths) {
            Long reqId = (Long)idAndPath[0];
            String reqPath = (String)idAndPath[1];
            String escapedPath = HibernatePathService.escapePath(reqPath);
            Object[] reqAndFolderPathAndReqPath = reqAndFolderPathAndReqPathById.get(reqId);
            reqAndFolderPathAndReqPath[pathInfoIndex] = escapedPath;
        }
    }

    private List<ExportRequirementData> formatExportResult(Collection<Requirement> rootReq, Collection<Object[]> nonRootReq) {
        ArrayList<ExportRequirementData> exportList = new ArrayList<ExportRequirementData>();
        for (Requirement requirement : rootReq) {
            ExportRequirementData erd = new ExportRequirementData(requirement, "", "");
            exportList.add(erd);
        }
        for (Object[] exportReqInfos : nonRootReq) {
            Requirement requirement = (Requirement)exportReqInfos[0];
            String folderPath = (String)exportReqInfos[1];
            String requirementPath = (String)exportReqInfos[2];
            ExportRequirementData erd = new ExportRequirementData(requirement, folderPath, requirementPath);
            exportList.add(erd);
        }
        Collections.sort(exportList, new ExportRequirementDataComparator());
        return exportList;
    }

    private List<Requirement> findRootContentRequirement(List<Long> params) {
        if (!params.isEmpty()) {
            SetParamIdsParametersCallback newCallBack1 = new SetParamIdsParametersCallback(params);
            return this.executeListNamedQuery("requirement.findRootContentRequirement", newCallBack1);
        }
        return Collections.emptyList();
    }

    @Override
    public List<ExportRequirementData> findRequirementToExportFromLibrary(List<Long> libraryIds) {
        if (!libraryIds.isEmpty()) {
            SetLibraryIdsCallback newCallBack1 = new SetLibraryIdsCallback(libraryIds);
            List<Long> result = this.executeListNamedQuery("requirement.findAllRootContent", newCallBack1);
            return this.findRequirementToExportFromNodes(result);
        }
        return Collections.emptyList();
    }

    @Override
    public List<RequirementCriticality> findDistinctRequirementsCriticalitiesVerifiedByTestCases(Set<Long> testCasesIds) {
        if (!testCasesIds.isEmpty()) {
            Query query = this.currentSession().getNamedQuery("requirementVersion.findDistinctRequirementsCriticalitiesVerifiedByTestCases");
            query.setParameterList("testCasesIds", testCasesIds);
            return query.list();
        }
        return Collections.emptyList();
    }

    @Override
    public List<RequirementCriticality> findDistinctRequirementsCriticalities(List<Long> requirementVersionsIds) {
        if (!requirementVersionsIds.isEmpty()) {
            Query query = this.currentSession().getNamedQuery("requirementVersion.findDistinctRequirementsCriticalities");
            query.setParameterList("requirementsIds", requirementVersionsIds);
            return query.list();
        }
        return Collections.emptyList();
    }

    @Override
    public List<RequirementVersion> findVersions(Long requirementId) {
        Query query = this.currentSession().getNamedQuery("requirement.findVersions");
        query.setParameter("requirementId", (Object)requirementId);
        return query.list();
    }

    @Override
    public List<RequirementVersion> findVersionsForAll(List<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            Query query = this.currentSession().getNamedQuery("requirement.findVersionsForAll");
            query.setParameterList(REQUIREMENT_IDS, requirementIds, (Type)LongType.INSTANCE);
            return query.list();
        }
        return Collections.emptyList();
    }

    @Override
    public Requirement findByContent(Requirement child) {
        SetNodeContentParameter callback = new SetNodeContentParameter((LibraryNode)child);
        return (Requirement)this.executeEntityNamedQuery("requirement.findByContent", callback);
    }

    @Override
    public List<Object[]> findAllParentsOf(List<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            ArrayList<Object[]> allpairs = new ArrayList<Object[]>(requirementIds.size());
            List libraryReqs = this.executeListNamedQuery("requirement.findAllLibraryParents", new SetRequirementsIdsParameterCallback(requirementIds));
            List folderReqs = this.executeListNamedQuery("requirement.findAllFolderParents", new SetRequirementsIdsParameterCallback(requirementIds));
            List reqReqs = this.executeListNamedQuery("requirement.findAllRequirementParents", new SetRequirementsIdsParameterCallback(requirementIds));
            allpairs.addAll(libraryReqs);
            allpairs.addAll(folderReqs);
            allpairs.addAll(reqReqs);
            return allpairs;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Long> findNonBoundRequirement(Collection<Long> nodeIds, Long milestoneId) {
        if (!nodeIds.isEmpty()) {
            Query q = this.currentSession().getNamedQuery("requirement.findNonBoundRequirement");
            q.setParameterList(NODE_IDS, nodeIds, (Type)LongType.INSTANCE);
            q.setParameter("milestoneId", (Object)milestoneId);
            return q.list();
        }
        return new ArrayList<Long>();
    }

    @Override
    public List<Long> filterRequirementHavingManyVersions(Collection<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            Query q = this.currentSession().getNamedQuery("requirement.findRequirementHavingManyVersions");
            q.setParameterList(REQUIREMENT_IDS, requirementIds, (Type)LongType.INSTANCE);
            return q.list();
        }
        return new ArrayList<Long>();
    }

    @Override
    public List<Long> findAllRequirementsIdsByNodes(Collection<Long> nodeIds) {
        if (!nodeIds.isEmpty()) {
            Query q = this.currentSession().getNamedQuery("requirement.findAllRequirementIdsByNodesId");
            q.setParameterList(NODE_IDS, nodeIds, (Type)LongType.INSTANCE);
            return q.list();
        }
        return new ArrayList<Long>();
    }

    @Override
    public List<Long> findIdsVersionsForAll(List<Long> requirementIds) {
        if (!requirementIds.isEmpty()) {
            Query q = this.currentSession().getNamedQuery("requirement.findVersionsIdsForAll");
            q.setParameterList(REQUIREMENT_IDS, requirementIds, (Type)LongType.INSTANCE);
            return q.list();
        }
        return new ArrayList<Long>();
    }

    @Override
    public Long findNodeIdByRemoteKey(String remoteKey, String projectName) {
        Query q = this.currentSession().getNamedQuery("requirement.findNodeIdByRemoteKey").setParameter("key", (Object)remoteKey).setParameter("projectName", (Object)projectName);
        return (Long)q.uniqueResult();
    }

    @Override
    public Long findNodeIdByRemoteKeyAndRemoteSyncId(String remoteKey, Long remoteSyncId) {
        Query q = this.currentSession().getNamedQuery("requirement.findNodeIdByRemoteKeyAndSynchronisationId").setParameter("key", (Object)remoteKey).setParameter("remoteSynchronisationId", (Object)remoteSyncId);
        return (Long)q.uniqueResult();
    }

    @Override
    public List<Long> findNodeIdsByRemoteKeys(Collection<String> remoteKeys, String projectName) {
        if (remoteKeys.isEmpty()) {
            return new ArrayList<Long>();
        }
        QRequirement req = QRequirement.requirement;
        QRequirementSyncExtender sync = QRequirementSyncExtender.requirementSyncExtender;
        HibernateQuery query = new HibernateQuery(this.currentSession());
        Map idsByKeys = (Map)((HibernateQuery)((HibernateQuery)((HibernateQuery)((HibernateQuery)query.select((Expression)req.id).from((EntityPath)req)).innerJoin((EntityPath)req.syncExtender, (Path)sync)).where((Predicate)sync.remoteReqId.in(remoteKeys))).where((Predicate)req.project.name.eq((Object)projectName))).transform(GroupBy.groupBy((Expression)sync.remoteReqId).as((Expression)req.id));
        ArrayList<Long> res = new ArrayList<Long>(remoteKeys.size());
        for (String key : remoteKeys) {
            Long id = (Long)idsByKeys.get(key);
            res.add(id);
        }
        return res;
    }

    @Override
    public List<Long> findAllRequirementIdsFromMilestones(Collection<Long> milestoneIds) {
        if (!milestoneIds.isEmpty()) {
            Query q = this.currentSession().getNamedQuery("requirement.findAllRequirementIdsFromMilestones");
            q.setParameterList("milestoneIds", milestoneIds, (Type)LongType.INSTANCE);
            return q.list();
        }
        return new ArrayList<Long>();
    }

    @Override
    public List<Long> findAllRequirementIdsFromMilestonesAndSelectedReqIds(Collection<Long> milestoneIds, Collection<Long> requirementIds) {
        if (!milestoneIds.isEmpty()) {
            Query q = this.currentSession().getNamedQuery("requirement.findAllRequirementVersionIdsFromMilestonesAndSelectedReqIds");
            q.setParameterList("milestoneIds", milestoneIds, (Type)LongType.INSTANCE);
            q.setParameterList(REQUIREMENT_IDS, requirementIds, (Type)LongType.INSTANCE);
            return q.list();
        }
        return new ArrayList<Long>();
    }

    @Override
    public void setNativeManagementModeForSynchronizedRequirements(List<Long> remoteSynchronisationIds) {
        Set<Long> reqIds = this.findSynchronizedRequirementIds(remoteSynchronisationIds);
        if (!reqIds.isEmpty()) {
            this.dsl.update((Table)Tables.REQUIREMENT).set((Field)Tables.REQUIREMENT.MODE, (Object)ManagementMode.NATIVE.name()).where(Tables.REQUIREMENT.RLN_ID.in(reqIds)).execute();
        }
    }

    private Set<Long> findSynchronizedRequirementIds(List<Long> remoteSynchronisationIds) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.in(remoteSynchronisationIds)).fetchSet((Field)Tables.REQUIREMENT.RLN_ID);
    }

    @Override
    public boolean isHighLevelRequirementVersion(Long requirementVersionId) {
        Long result = (Long)this.dsl.select((SelectField)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID).from((TableLike)Tables.REQUIREMENT_VERSION).leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT_VERSION.REQUIREMENT_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID)).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)requirementVersionId)).fetchOneInto(Long.class);
        return result != null;
    }

    @Override
    public Long findRequirementIdFromVersionId(Long requirementVersionId) {
        return (Long)this.dsl.selectDistinct((SelectField)Tables.REQUIREMENT_VERSION.REQUIREMENT_ID).from((TableLike)Tables.REQUIREMENT_VERSION).where(Tables.REQUIREMENT_VERSION.RES_ID.eq((Object)requirementVersionId)).fetchOneInto(Long.class);
    }

    @Override
    public Long findRequirementCurrentVersionIdFromRequirementId(Long highLevelRequirementId) {
        return (Long)this.dsl.select((SelectField)Tables.REQUIREMENT.CURRENT_VERSION_ID).from((TableLike)Tables.REQUIREMENT).where(Tables.REQUIREMENT.RLN_ID.eq((Object)highLevelRequirementId)).fetchOneInto(Long.class);
    }

    @Override
    public Set<Long> findRequirementCurrentVersionIdsFromRequirementIds(Collection<Long> requirementIds) {
        return this.dsl.select((SelectField)Tables.REQUIREMENT.CURRENT_VERSION_ID).from((TableLike)Tables.REQUIREMENT).where(Tables.REQUIREMENT.RLN_ID.in(requirementIds)).fetchSet((Field)Tables.REQUIREMENT.CURRENT_VERSION_ID);
    }

    @Override
    public boolean checkIfRequirementIsChild(Long requirementId) {
        return this.dsl.fetchExists((Select)this.dsl.select((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.REQUIREMENT.RLN_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.eq((Object)1)).and(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Object)requirementId)));
    }

    @Override
    public Long findRequirementAncestorId(Long requirementId) {
        return (Long)this.dsl.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).where(Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Object)requirementId)).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.eq((Object)1)).fetchOneInto(Long.class);
    }

    @Override
    public List<Long> findAllChildrenIdsFromRequirementId(Long requirementId) {
        return this.dsl.select((SelectField)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID).from((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Object)requirementId)).and(Tables.RLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)0)).fetchInto(Long.class);
    }

    @Override
    public Requirement findByIdWithChildren(Long id) {
        return new EntityGraphQueryBuilder<Requirement>(this.entityManager, Requirement.class, "SELECT r FROM Requirement r WHERE r.id = :id").addAttributeNodes("children").addSubGraph("children", "syncExtender").execute(Collections.singletonMap("id", id));
    }

    @Override
    public List<Requirement> findRequirementsNodeRootAndInFolderByNodeIds(List<Long> libraryNodeIds) {
        CommonTableExpression cte = DSL.name((String)"CTE").fields("RLN_ID", "IS_FOLDER").as((ResultQuery)DSL.select((SelectField)Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID, (SelectField)DSL.when((Condition)Tables.REQUIREMENT_FOLDER.RLN_ID.isNotNull(), (Object)Boolean.TRUE).otherwise((Object)Boolean.FALSE)).from((TableLike)Tables.REQUIREMENT_LIBRARY_NODE).leftJoin((TableLike)Tables.REQUIREMENT_FOLDER).on(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.eq((Field)Tables.REQUIREMENT_FOLDER.RLN_ID)).where(Tables.REQUIREMENT_LIBRARY_NODE.RLN_ID.in(libraryNodeIds)));
        List requirementIds = this.dsl.with(new CommonTableExpression[]{cte}).select((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.REQUIREMENT).innerJoin((TableLike)Tables.RLN_RELATIONSHIP_CLOSURE).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID)).where(Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.in((Select)DSL.select((SelectField)DSL.field((String)"RLN_ID", Long.class)).from(DSL.name((String)"CTE")).where(DSL.field((String)"IS_FOLDER", Boolean.class).isTrue()))).union((Select)DSL.select((SelectField)DSL.field((String)"RLN_ID", Long.class)).from(DSL.name((String)"CTE")).where(DSL.field((String)"IS_FOLDER", Boolean.class).isFalse())).fetchInto(Long.class);
        if (requirementIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.findAllByIds(requirementIds);
    }

    @Override
    public Map<Long, RequirementCriticality> findRequirementsCriticalityVerifiedByTestCases(Collection<Long> testCaseIds) {
        if (testCaseIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (Stream<Object[]> resultStream = this.getRequirementCriticalityByTCIdsStream(testCaseIds);){
            return resultStream.collect(Collectors.toMap(r -> (Long)r[0], r -> (RequirementCriticality)r[1]));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Stream<Object[]> getRequirementCriticalityByTCIdsStream(Collection<Long> testCaseIds) {
        return this.entityManager.createQuery("select tc.id, r.criticality\nfrom TestCase tc\njoin tc.requirementVersionCoverages rvc\njoin rvc.verifiedRequirementVersion r\nwhere tc.id in (:ids)", Object[].class).setParameter("ids", testCaseIds).getResultStream();
    }

    private static final class ExportRequirementDataComparator
    implements Comparator<ExportRequirementData> {
        private ExportRequirementDataComparator() {
        }

        @Override
        public int compare(ExportRequirementData o1, ExportRequirementData o2) {
            int folderCompare = o1.getFolderName().compareTo(o2.getFolderName());
            if (folderCompare != 0) {
                return folderCompare;
            }
            return o1.getRequirementParentPath().compareTo(o2.getRequirementParentPath());
        }
    }

    private static final class SetRequirementsIdsParameterCallback
    implements SetQueryParametersCallback {
        private Collection<Long> requirementIds;

        private SetRequirementsIdsParameterCallback(Collection<Long> requirementIds) {
            this.requirementIds = requirementIds;
        }

        @Override
        public void setQueryParameters(Query query) {
            query.setParameterList(HibernateRequirementDao.REQUIREMENT_IDS, this.requirementIds);
        }
    }
}

