/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.testcase.TestCaseExecutionStatus;
import org.squashtest.tm.service.internal.repository.IterationDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetIdParameter;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;
import org.squashtest.tm.service.statistics.CountOnEnum;

@Repository
public class HibernateIterationDao
extends HibernateEntityDao<Iteration>
implements IterationDao {
    private static final String UNCHECKED = "unchecked";
    @PersistenceContext
    private EntityManager em;

    @Override
    public List<Iteration> findAllIterationContainingTestCase(long testCaseId) {
        return this.executeListNamedQuery("iterationDao.findAllIterationContainingTestCase", new SetIdParameter("testCaseId", testCaseId));
    }

    @Override
    public List<NamedReference> findAllTestSuitesAsNamedReferences(long iterationId) {
        return this.entityManager.createNamedQuery("iteration.findAllTestSuitesAsNamedReferences").setParameter("iterationId", (Object)iterationId).getResultList();
    }

    @Override
    @Deprecated
    public void persistIterationAndTestPlan(Iteration iteration) {
        this.persist(iteration);
    }

    @UsedInPlugin(value="rest-api")
    public @UsedInPlugin(value="rest-api") TestPlanStatistics getIterationStatisticsByItpiIds(List<Long> itpiIds) {
        List result = this.entityManager.createNamedQuery("iteration.countStatusesByItpiIds").setParameter("itpiIds", itpiIds).getResultList();
        LinkedHashMap<ExecutionStatus, Integer> canonicalStatusMap = CountOnEnum.fromTuples(result, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
        return new TestPlanStatistics(canonicalStatusMap);
    }

    @Override
    public List<TestCaseExecutionStatus> findExecStatusForIterationsAndTestCases(List<Long> testCasesIds, List<Long> iterationsIds) {
        if (testCasesIds.isEmpty()) {
            return Collections.emptyList();
        }
        List results = this.entityManager.createNamedQuery("iteration.findITPIByTestCaseGroupByStatus").setParameter("testCasesIds", testCasesIds).setParameter("iterationsIds", iterationsIds).getResultList();
        ArrayList<TestCaseExecutionStatus> formatedResult = new ArrayList<TestCaseExecutionStatus>(results.size());
        for (Object[] result : results) {
            formatedResult.add(new TestCaseExecutionStatus((ExecutionStatus)result[0], (Long)result[1]));
        }
        return formatedResult;
    }

    @Override
    public List<Long> findVerifiedTcIdsInIterations(List<Long> testCasesIds, List<Long> iterationIds) {
        return this.findAllByTestCasesAndIterations("iteration.findVerifiedTcIdsInIterations", testCasesIds, iterationIds);
    }

    private <R> List<R> findAllByTestCasesAndIterations(String queryName, List<Long> testCaseIds, List<Long> iterationIds) {
        if (testCaseIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.entityManager.createNamedQuery(queryName).setParameter("testCasesIds", testCaseIds).setParameter("iterationsIds", iterationIds).getResultList();
    }

    @Override
    public List<Long> findVerifiedTcIdsInIterationsWithExecution(List<Long> tcIds, List<Long> iterationsIds) {
        return this.findAllByTestCasesAndIterations("iteration.findVerifiedAndExecutedTcIdsInIterations", tcIds, iterationsIds);
    }

    @Override
    public MultiMap findVerifiedITPI(List<Long> tcIds, List<Long> iterationsIds) {
        List itpis = this.findAllByTestCasesAndIterations("iteration.findITPIByTestCaseGroupByStatus", tcIds, iterationsIds);
        MultiValueMap result = new MultiValueMap();
        for (Object[] itpi : itpis) {
            TestCaseExecutionStatus tcStatus = new TestCaseExecutionStatus((ExecutionStatus)itpi[0], (Long)itpi[1]);
            result.put((Object)tcStatus.getTestCaseId(), (Object)tcStatus);
        }
        return result;
    }

    @Override
    public Iteration findByUUID(String targetUUID) {
        return (Iteration)this.em.createQuery("SELECT i FROM Iteration i WHERE i.uuid = :uuid", Iteration.class).setParameter("uuid", (Object)targetUUID).getSingleResult();
    }

    @Override
    public Long getProjectId(long iterationId) {
        return (Long)this.em.createQuery("select it.campaign.project.id from Iteration it where it.id = :id", Long.class).setParameter("id", (Object)iterationId).getSingleResult();
    }

    @Override
    public List<Long> findTestPlanIds(long iterationId) {
        return this.em.createQuery("select tp.id from Iteration it join it.testPlans tp where it.id = :id", Long.class).setParameter("id", (Object)iterationId).getResultList();
    }

    @Override
    public Iteration loadContainerForPaste(long id) {
        Iteration iteration = new EntityGraphQueryBuilder<Iteration>(this.entityManager, Iteration.class, "select i from Iteration i where i.id = :id").addAttributeNodes("testSuites").execute(Map.of("id", id));
        new EntityGraphQueryBuilder<Iteration>(this.entityManager, Iteration.class, "select i from Iteration i where i.id = :id").addAttributeNodes("testPlans").addSubGraph("testPlans", "exploratorySessionOverview").execute(Map.of("id", id));
        return iteration;
    }

    @Override
    public List<Iteration> loadNodeForPaste(Collection<Long> ids) {
        String testPlanSession = EntityGraphQueryBuilder.buildParentAttribute("testPlans", "exploratorySessionOverview");
        String testPlanSessionAttachment = EntityGraphQueryBuilder.buildParentAttribute("testPlans", "exploratorySessionOverview", "attachmentList");
        List<Iteration> iterations = new EntityGraphQueryBuilder<Iteration>(this.em, Iteration.class, "SELECT DISTINCT it FROM Iteration it WHERE it.id IN :ids").addAttributeNodes("campaign", "attachmentList", "testPlans").addSubGraph("attachmentList", "attachments").addSubgraphToSubgraph("attachmentList", "attachments", "content").addSubGraph("testPlans", "exploratorySessionOverview").addSubgraphToSubgraph("testPlans", "exploratorySessionOverview", "attachmentList").addSubgraphToSubgraph(testPlanSession, "attachmentList", "attachments").addSubgraphToSubgraph(testPlanSessionAttachment, "attachments", "content").executeDistinctList(Map.of("ids", ids));
        String testSuiteAttachment = EntityGraphQueryBuilder.buildParentAttribute("testSuites", "attachmentList");
        String testSuiteTestPlan = EntityGraphQueryBuilder.buildParentAttribute("testSuites", "testPlan");
        String testSuiteTestPlanSession = EntityGraphQueryBuilder.buildParentAttribute("testSuites", "testPlan", "exploratorySessionOverview");
        String testSuitetestPlanSessionAttachmentList = EntityGraphQueryBuilder.buildParentAttribute("testSuites", "testPlan", "exploratorySessionOverview", "attachmentList");
        new EntityGraphQueryBuilder<Iteration>(this.em, Iteration.class, "SELECT DISTINCT it FROM Iteration it WHERE it.id IN :ids").addAttributeNodes("testSuites").addSubGraph("testSuites", "testPlan", "attachmentList").addSubgraphToSubgraph("testSuites", "attachmentList", "attachments").addSubgraphToSubgraph(testSuiteAttachment, "attachments", "content").addSubgraphToSubgraph("testSuites", "testPlan", "exploratorySessionOverview").addSubgraphToSubgraph(testSuiteTestPlan, "exploratorySessionOverview", "attachmentList").addSubgraphToSubgraph(testSuiteTestPlanSession, "attachmentList", "attachments").addSubgraphToSubgraph(testSuitetestPlanSessionAttachmentList, "attachments", "content").executeDistinctList(Map.of("ids", ids));
        return iterations;
    }
}

