/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Provider;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.copier.ChildEntityDtoResult;
import org.squashtest.tm.service.internal.repository.CampaignFolderDao;
import org.squashtest.tm.service.internal.repository.hibernate.ContainerIdNameStartParameterCallback;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateCampaignDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateSprintDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateSprintGroupDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetNodeContentParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;

@Repository
public class HibernateCampaignFolderDao
extends HibernateEntityDao<CampaignFolder>
implements CampaignFolderDao {
    private final Provider<HibernateSprintGroupDao> sprintGroupDaoProvider;
    private final Provider<HibernateSprintDao> sprintDaoProvider;
    private final Provider<HibernateCampaignDao> campaignDaoProvider;

    @Autowired
    public HibernateCampaignFolderDao(Provider<HibernateSprintGroupDao> sprintGroupDaoProvider, Provider<HibernateSprintDao> sprintDaoProvider, Provider<HibernateCampaignDao> campaignDaoProvider) {
        this.sprintGroupDaoProvider = sprintGroupDaoProvider;
        this.sprintDaoProvider = sprintDaoProvider;
        this.campaignDaoProvider = campaignDaoProvider;
    }

    @Override
    public CampaignFolder findByContent(CampaignLibraryNode node) {
        SetNodeContentParameter callback = new SetNodeContentParameter((LibraryNode)node);
        return (CampaignFolder)this.executeEntityNamedQuery("campaignFolder.findByContent", callback);
    }

    @Override
    public List<String> findNamesInLibraryStartingWith(long libraryId, String nameStart) {
        ContainerIdNameStartParameterCallback newCallBack1 = new ContainerIdNameStartParameterCallback(libraryId, nameStart);
        return this.executeListNamedQuery("campaignFolder.findNamesInLibraryStartingWith", newCallBack1);
    }

    @Override
    public List<Long[]> findPairedContentForList(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        NativeQuery query = this.currentSession().createNativeQuery("select * from CLN_RELATIONSHIP where ancestor_id in (:folderIds)");
        query.setParameterList("folderIds", ids, (Type)LongType.INSTANCE);
        query.addScalar("ancestor_id", (Type)LongType.INSTANCE);
        query.addScalar("descendant_id", (Type)LongType.INSTANCE);
        List result = query.list();
        return this.toArrayOfLong(result);
    }

    @Override
    public List<Long> findContentForList(List<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        NativeQuery query = this.currentSession().createNativeQuery("select * from CLN_RELATIONSHIP where ancestor_id in (:folderIds)");
        query.setParameterList("folderIds", ids, (Type)LongType.INSTANCE);
        query.addScalar("descendant_id", (Type)LongType.INSTANCE);
        return query.list();
    }

    private List<Long[]> toArrayOfLong(List<Object[]> input) {
        ArrayList<Long[]> result = new ArrayList<Long[]>();
        for (Object[] pair : input) {
            Long[] newPair = new Long[]{(Long)pair[0], (Long)pair[1]};
            result.add(newPair);
        }
        return result;
    }

    @Override
    public CampaignFolder findParentOf(final Long id) {
        SetQueryParametersCallback newCallBack = new SetQueryParametersCallback(){

            @Override
            public void setQueryParameters(Query query) {
                query.setParameter("contentId", (Object)id, (Type)LongType.INSTANCE);
            }
        };
        return (CampaignFolder)this.executeEntityNamedQuery("campaignFolder.findParentOf", newCallBack);
    }

    @Override
    public CampaignFolder loadContainerForPaste(long id) {
        return (CampaignFolder)this.entityManager.createQuery("select cf from CampaignFolder cf left join fetch cf.content where cf.id = :id", CampaignFolder.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<CampaignFolder> loadContainersForPaste(Collection<Long> ids) {
        return this.entityManager.createQuery("select distinct cf from CampaignFolder cf left join fetch cf.content where cf.id in :id", CampaignFolder.class).setParameter("id", ids).setHint("hibernate.query.passDistinctThrough", (Object)false).getResultList();
    }

    @Override
    public List<CampaignFolder> loadNodeForPaste(Collection<Long> ids) {
        return this.entityManager.createQuery("select distinct cf from CampaignFolder cf left join fetch cf.attachmentList al left join fetch al.attachments a left join fetch a.content c where cf.id in :ids", CampaignFolder.class).setParameter("ids", ids).setHint("hibernate.query.passDistinctThrough", (Object)false).getResultList();
    }

    @Override
    public ChildEntityDtoResult loadChildForPaste(Collection<Long> ids, int maxResult, int offset, ClipboardPayload clipboardPayload) {
        return this.getChildEntityDtoForPaste("select c, cf.id from CampaignFolder cf join cf.content c where cf.id in :ids", ids, maxResult, offset, clipboardPayload, (k, v) -> {
            switch (k) {
                case CAMPAIGN_FOLDER: {
                    this.loadNodeForPaste((Collection<Long>)v);
                    break;
                }
                case CAMPAIGN: {
                    ((HibernateCampaignDao)this.campaignDaoProvider.get()).loadNodeForPaste((Collection<Long>)v);
                    break;
                }
                case SPRINT_GROUP: {
                    ((HibernateSprintGroupDao)this.sprintGroupDaoProvider.get()).loadNodeForPaste((Collection<Long>)v);
                    break;
                }
                case SPRINT: {
                    ((HibernateSprintDao)this.sprintDaoProvider.get()).loadNodeForPaste((Collection<Long>)v);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported entity type: " + k);
                }
            }
        });
    }
}

