/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Provider;
import org.hibernate.query.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.copier.ChildEntityDtoResult;
import org.squashtest.tm.service.internal.repository.CampaignDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateEntityDao;
import org.squashtest.tm.service.internal.repository.hibernate.HibernateIterationDao;
import org.squashtest.tm.service.internal.repository.hibernate.SetIdParameter;
import org.squashtest.tm.service.internal.repository.hibernate.SetQueryParametersCallback;
import org.squashtest.tm.service.internal.repository.hibernate.loaders.EntityGraphQueryBuilder;
import org.squashtest.tm.service.statistics.CountOnEnum;

@Repository
public class HibernateCampaignDao
extends HibernateEntityDao<Campaign>
implements CampaignDao {
    private static final String NODE_IDS = "nodeIds";
    private static final String MILESTONE_ID = "milestoneId";
    private static final String CAMPAIGN_IDS = "campaignIds";
    private final Provider<HibernateIterationDao> iterationDaoProvider;

    @Autowired
    public HibernateCampaignDao(Provider<HibernateIterationDao> iterationDaoProvider) {
        this.iterationDaoProvider = iterationDaoProvider;
    }

    private List<Long> findAllCampaignIdsByLibraries(Collection<Long> libraryIds) {
        if (!libraryIds.isEmpty()) {
            Query query = this.currentSession().getNamedQuery("campaign.findAllCampaignIdsByLibraries");
            query.setParameterList("libraryIds", libraryIds, (Type)LongType.INSTANCE);
            return query.list();
        }
        return Collections.emptyList();
    }

    public List<Long> findAllCampaignIdsByNodeIds(Collection<Long> nodeIds) {
        if (!nodeIds.isEmpty()) {
            Query query = this.currentSession().getNamedQuery("campaign.findAllCampaignIdsByNodeIds");
            query.setParameterList(NODE_IDS, nodeIds, (Type)LongType.INSTANCE);
            return query.list();
        }
        return Collections.emptyList();
    }

    @Override
    public Map<Long, String> findAllCampaignIdsAndComputePathAsNameByLibraries(Collection<Long> libraryIds) {
        List<Long> campaignIds;
        HashMap<Long, String> campaignNameMap = new HashMap<Long, String>();
        if (!libraryIds.isEmpty() && !(campaignIds = this.findAllCampaignIdsByLibraries(libraryIds)).isEmpty()) {
            List<Object[]> resultTuples = this.findAllCampaignPathAsNameByCampaignIds("CampaignPathEdge.findPathsByCampaignIdsAndLibrary", campaignIds);
            this.processTuplesIntoMap(resultTuples, campaignNameMap);
        }
        return campaignNameMap;
    }

    private List<Object[]> findAllCampaignPathAsNameByCampaignIds(String queryName, List<Long> campaignIds) {
        Query campaignNameQuery = this.currentSession().getNamedQuery(queryName);
        campaignNameQuery.setParameterList(CAMPAIGN_IDS, campaignIds, (Type)LongType.INSTANCE);
        return campaignNameQuery.list();
    }

    private void processTuplesIntoMap(List<Object[]> tuples, Map<Long, String> map) {
        for (Object[] tuple : tuples) {
            HibernateCampaignDao.validateTuple(tuple);
            Long key = (Long)tuple[0];
            String value = tuple[1].toString();
            map.put(key, value);
        }
    }

    private static void validateTuple(Object[] tuple) {
        if (Objects.isNull(tuple) || tuple.length < 2) {
            throw new IllegalArgumentException("Illegal Tuple. Null or tuples with less than two columns are rejected");
        }
    }

    @Override
    public Map<Long, String> findAllCampaignIdsAndComputePathAsNameByNodeIds(Collection<Long> nodeIds) {
        List<Long> campaignIds;
        HashMap<Long, String> campaignNameMap = new HashMap<Long, String>();
        if (!nodeIds.isEmpty() && !(campaignIds = this.findAllCampaignIdsByNodeIds(nodeIds)).isEmpty()) {
            List<Object[]> results = this.findAllCampaignPathAsNameByCampaignIds("CampaignPathEdge.findPathsByCampaignIdsAndNode", campaignIds);
            this.processTuplesIntoMap(results, campaignNameMap);
        }
        return campaignNameMap;
    }

    @Override
    public Map<Long, String> findAllCampaignIdsAndNameByLibraryIds(List<Long> libraryIds) {
        HashMap<Long, String> campaignNameMap = new HashMap<Long, String>();
        if (!libraryIds.isEmpty()) {
            Query query = this.currentSession().getNamedQuery("campaign.findAllCampaignNamedReferenceByLibraries");
            query.setParameterList("libraryIds", libraryIds, (Type)LongType.INSTANCE);
            List results = query.list();
            this.processTuplesIntoMap(results, campaignNameMap);
        }
        return campaignNameMap;
    }

    @Override
    public Map<Long, String> findAllCampaignIdsAndNameByNodeIds(List<Long> nodeIds) {
        HashMap<Long, String> campaignNameMap = new HashMap<Long, String>();
        if (!nodeIds.isEmpty()) {
            Query query = this.currentSession().getNamedQuery("campaign.findAllCampaignNamedReferenceByNodeIds");
            query.setParameterList(NODE_IDS, nodeIds, (Type)LongType.INSTANCE);
            List results = query.list();
            this.processTuplesIntoMap(results, campaignNameMap);
        }
        return campaignNameMap;
    }

    @Override
    public List<Long> filterByMilestone(Collection<Long> campaignIds, Long milestoneId) {
        List<Long> res;
        if (milestoneId == null) {
            res = new ArrayList<Long>(campaignIds);
        } else if (!campaignIds.isEmpty()) {
            Query query = this.currentSession().getNamedQuery("campaign.filterByMilestone");
            query.setParameterList(CAMPAIGN_IDS, campaignIds, (Type)LongType.INSTANCE);
            query.setParameter(MILESTONE_ID, (Object)milestoneId, (Type)LongType.INSTANCE);
            res = query.list();
        } else {
            res = Collections.emptyList();
        }
        return res;
    }

    @Override
    public List<Long> findAllIdsByMilestone(Long milestoneId) {
        if (milestoneId != null) {
            Query query = this.currentSession().getNamedQuery("campaign.findAllIdsByMilestoneId");
            query.setParameter(MILESTONE_ID, (Object)milestoneId, (Type)LongType.INSTANCE);
            return query.list();
        }
        throw new IllegalArgumentException("milestoneId should not be null");
    }

    @Override
    public int countIterations(long campaignId) {
        Long count = (Long)this.executeEntityNamedQuery("campaign.countIterations", this.idParameter(campaignId));
        return count.intValue();
    }

    private SetQueryParametersCallback idParameter(long campaignId) {
        return new SetIdParameter("campaignId", campaignId);
    }

    public TestPlanStatistics findCampaignStatisticsForTCLastExecutionScope(long campaignId, List<Long> itpiIds) {
        Query q = this.currentSession().getNamedQuery("campaign.countStatusesForLastExecutedTC");
        q.setParameter("campaignId", (Object)campaignId);
        q.setParameterList("itpiIds", itpiIds);
        List result = q.list();
        LinkedHashMap<ExecutionStatus, Integer> canonicalStatusMap = CountOnEnum.fromTuples(result, ExecutionStatus.class).getStatistics(ExecutionStatus::getCanonicalStatus, ExecutionStatus.getCanonicalStatusSet());
        return new TestPlanStatistics(canonicalStatusMap);
    }

    @Override
    public List<Long> findNonBoundCampaign(Collection<Long> nodeIds, Long milestoneId) {
        Query q = this.currentSession().getNamedQuery("campaign.findNonBoundCampaign");
        q.setParameterList(NODE_IDS, nodeIds, (Type)LongType.INSTANCE);
        q.setParameter(MILESTONE_ID, (Object)milestoneId);
        return q.list();
    }

    @Override
    public List<Long> findCampaignIdsHavingMultipleMilestones(List<Long> nodeIds) {
        Query q = this.currentSession().getNamedQuery("campaign.findCampaignIdsHavingMultipleMilestones");
        q.setParameterList(NODE_IDS, nodeIds, (Type)LongType.INSTANCE);
        return q.list();
    }

    @Override
    public Campaign loadContainerForPaste(long id) {
        return (Campaign)this.entityManager.createQuery("select c from Campaign c left join fetch c.iterations where c.id = :id", Campaign.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<Campaign> loadContainersForPaste(Collection<Long> ids) {
        return this.entityManager.createQuery("select distinct c from Campaign c left join fetch c.iterations where c.id in :ids", Campaign.class).setParameter("ids", ids).setHint("hibernate.query.passDistinctThrough", (Object)false).getResultList();
    }

    @Override
    public List<Campaign> loadNodeForPaste(Collection<Long> ids) {
        return new EntityGraphQueryBuilder<Campaign>(this.entityManager, Campaign.class, "select c from Campaign c where c.id in :ids").addAttributeNodes("testPlan", "attachmentList", "milestones").addSubGraph("attachmentList", "attachments").addSubgraphToSubgraph("attachmentList", "attachments", "content").executeDistinctList(Map.of("ids", ids));
    }

    @Override
    public ChildEntityDtoResult loadChildForPaste(Collection<Long> ids, int maxResult, int offset, ClipboardPayload clipboardPayload) {
        return this.getChildEntityDtoForPaste("select i, c.id from Campaign c join c.iterations i where c.id in :ids", ids, maxResult, offset, clipboardPayload, (k, v) -> {
            if (k.equals((Object)EntityType.ITERATION)) {
                ((HibernateIterationDao)this.iterationDaoProvider.get()).loadNodeForPaste((Collection<Long>)v);
            }
        });
    }
}

