/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.hibernate;

import java.util.List;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.domain.testautomation.FailureDetail;
import org.squashtest.tm.service.internal.repository.CustomIssueDao;

@Repository
public class CustomIssueDaoImpl
implements CustomIssueDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomIssueDaoImpl.class);
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public IssueDetector findIssueDetectorByIssue(long id) {
        List<Supplier<IssueDetector>> operations = List.of(() -> this.findExecutionByIssue(id), () -> this.findExecutionStepByIssue(id), () -> this.findSessionNoteByIssue(id), () -> this.findFailureDetailByIssue(id));
        for (Supplier<IssueDetector> operation : operations) {
            try {
                return operation.get();
            }
            catch (NoResultException noResultException) {}
        }
        throw new NoResultException("No IssueDetector found for issue id: " + id);
    }

    private SessionNote findSessionNoteByIssue(long issueId) throws NoResultException {
        return (SessionNote)this.entityManager.createNamedQuery("Issue.findSessionNote").setParameter("id", (Object)issueId).getSingleResult();
    }

    private FailureDetail findFailureDetailByIssue(long issueId) throws NoResultException {
        return (FailureDetail)this.entityManager.createNamedQuery("Issue.findFailureDetail").setParameter("id", (Object)issueId).getSingleResult();
    }

    private Execution findExecutionByIssue(long issueId) throws NoResultException {
        return (Execution)this.entityManager.createNamedQuery("Issue.findExecution").setParameter("id", (Object)issueId).getSingleResult();
    }

    private ExecutionStep findExecutionStepByIssue(long issueId) throws NoResultException {
        return (ExecutionStep)this.entityManager.createNamedQuery("Issue.findExecutionStep").setParameter("id", (Object)issueId).getSingleResult();
    }

    @Override
    public Execution findExecutionRelatedToIssue(long id) {
        Execution exec = null;
        try {
            exec = this.findExecutionByIssue(id);
        }
        catch (NoResultException noResultException) {
            try {
                ExecutionStep step = this.findExecutionStepByIssue(id);
                if (step.getExecution() != null) {
                    exec = step.getExecution();
                }
            }
            catch (NoResultException ex) {
                LOGGER.warn("Could not find execution step for issue id {}", new Object[]{id, ex});
            }
        }
        return exec;
    }
}

