/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.dto.requirement.VerifyingTestCaseDto;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.display.VerifyingTestCaseDisplayDao;

@Repository
public class VerifyingTestCaseDisplayDaoImpl
implements VerifyingTestCaseDisplayDao {
    private final RequirementDao requirementDao;
    private final DSLContext dsl;

    public VerifyingTestCaseDisplayDaoImpl(DSLContext dsl, RequirementDao requirementDao) {
        this.dsl = dsl;
        this.requirementDao = requirementDao;
    }

    @Override
    public List<VerifyingTestCaseDto> findByRequirementVersionIds(Set<Long> requirementVersionIds) {
        SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> milestoneDates = this.getMilestoneDates();
        List verifyingTestCaseDtos = this.dsl.select((SelectField)Tables.TEST_CASE.TCLN_ID.as("ID"), (SelectField)Tables.TEST_CASE.REFERENCE, (SelectField)Tables.TEST_CASE.TC_STATUS.as("STATUS"), (SelectField)Tables.TEST_CASE.IMPORTANCE, (SelectField)Tables.TEST_CASE.EXECUTION_MODE, (SelectField)Tables.TEST_CASE_LIBRARY_NODE.NAME, (SelectField)Tables.PROJECT.NAME.as("PROJECT_NAME"), (SelectField)DSL.field((String)"MILESTONE_LABELS"), (SelectField)DSL.field((String)"MILESTONE_MIN_DATE"), (SelectField)DSL.field((String)"MILESTONE_MAX_DATE")).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.TEST_CASE_LIBRARY_NODE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.TEST_CASE_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)Tables.REQUIREMENT_VERSION_COVERAGE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.REQUIREMENT_VERSION_COVERAGE.VERIFYING_TEST_CASE_ID)).leftJoin(milestoneDates).on(milestoneDates.field("ID", Long.class).eq((Field)Tables.TEST_CASE.TCLN_ID)).where(Tables.REQUIREMENT_VERSION_COVERAGE.VERIFIED_REQ_VERSION_ID.in(requirementVersionIds)).fetchInto(VerifyingTestCaseDto.class);
        if (!verifyingTestCaseDtos.isEmpty()) {
            this.appendLastExecutionStatus(verifyingTestCaseDtos);
        }
        return verifyingTestCaseDtos;
    }

    @Override
    public List<VerifyingTestCaseDto> findByHighLevelRequirementVersionId(Long highLevelRequirementVersionId) {
        List<VerifyingTestCaseDto> directlyLinkedVerifyingTestCases = this.findByRequirementVersionIds(new HashSet<Long>(Collections.singletonList(highLevelRequirementVersionId)));
        Long highLevelRequirementId = this.requirementDao.findRequirementIdFromVersionId(highLevelRequirementVersionId);
        Set<Long> linkedRequirementIds = this.findLinkedLowLevelRequirementIds(highLevelRequirementId);
        if (linkedRequirementIds.isEmpty()) {
            return directlyLinkedVerifyingTestCases;
        }
        List<Long> descendantIds = this.requirementDao.findDescendantRequirementIds(new ArrayList<Long>(linkedRequirementIds));
        linkedRequirementIds.addAll(descendantIds);
        Set<Long> linkedRequirementCurrentVersionIds = this.requirementDao.findRequirementCurrentVersionIdsFromRequirementIds(linkedRequirementIds);
        List<VerifyingTestCaseDto> lowLevelReqVerifyingTestCases = this.findByRequirementVersionIds(linkedRequirementCurrentVersionIds);
        lowLevelReqVerifyingTestCases.forEach(testCase -> testCase.setDirectlyLinked(false));
        return Stream.concat(directlyLinkedVerifyingTestCases.stream(), lowLevelReqVerifyingTestCases.stream()).toList();
    }

    private Set<Long> findLinkedLowLevelRequirementIds(Long requirementId) {
        return this.dsl.selectDistinct((SelectField)Tables.REQUIREMENT.RLN_ID).from((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).innerJoin((TableLike)Tables.REQUIREMENT).on(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Field)Tables.REQUIREMENT.HIGH_LEVEL_REQUIREMENT_ID)).where(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.eq((Object)requirementId)).fetchSet((Field)Tables.REQUIREMENT.RLN_ID);
    }

    private SelectHavingStep<Record4<Long, Timestamp, Timestamp, String>> getMilestoneDates() {
        return DSL.select((SelectField)Tables.TEST_CASE.TCLN_ID.as("ID"), (SelectField)DSL.min((Field)Tables.MILESTONE.END_DATE).as("MILESTONE_MIN_DATE"), (SelectField)DSL.max((Field)Tables.MILESTONE.END_DATE).as("MILESTONE_MAX_DATE"), (SelectField)DSL.listAgg((Field)Tables.MILESTONE.LABEL, (String)", ").withinGroupOrderBy(new OrderField[]{Tables.MILESTONE.END_DATE.asc()}).as("MILESTONE_LABELS")).from((TableLike)Tables.TEST_CASE).innerJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.TEST_CASE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).innerJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE.MILESTONE_ID.eq((Field)Tables.MILESTONE_TEST_CASE.MILESTONE_ID)).groupBy(new GroupField[]{Tables.TEST_CASE.TCLN_ID, Tables.MILESTONE_TEST_CASE.TEST_CASE_ID});
    }

    private void appendLastExecutionStatus(List<VerifyingTestCaseDto> verifyingTestCaseDtos) {
        Map<Long, String> lastExecutionStatusByTclnId = this.getLastExecutionStatusByTclnId(verifyingTestCaseDtos);
        verifyingTestCaseDtos.forEach(verifyingTestCaseDto -> {
            String lastExecutionStatus = (String)lastExecutionStatusByTclnId.get(verifyingTestCaseDto.getId());
            if (lastExecutionStatus != null) {
                verifyingTestCaseDto.setLastExecutionStatus(lastExecutionStatus);
            }
        });
    }

    private SelectHavingStep<Record2<Long, Timestamp>> getLastExecutedOnDate(List<Long> verifyingTestCaseDtoIds) {
        return this.dsl.select((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID, (SelectField)DSL.max((Field)Tables.ITERATION_TEST_PLAN_ITEM.LAST_EXECUTED_ON).as("MAX_LAST_EXECUTED_ON")).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.in(verifyingTestCaseDtoIds)).groupBy(new GroupField[]{Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID});
    }

    private Map<Long, String> getLastExecutionStatusByTclnId(List<VerifyingTestCaseDto> verifyingTestCaseDtos) {
        List<Long> verifyingTestCaseDtoIds = verifyingTestCaseDtos.stream().map(VerifyingTestCaseDto::getId).toList();
        SelectHavingStep<Record2<Long, Timestamp>> lastExecutedOnDate = this.getLastExecutedOnDate(verifyingTestCaseDtoIds);
        return this.dsl.selectDistinct((SelectField)Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID, (SelectField)Tables.ITERATION_TEST_PLAN_ITEM.EXECUTION_STATUS).from((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).join(lastExecutedOnDate).on(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq(lastExecutedOnDate.field("TCLN_ID", Long.class))).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.in(verifyingTestCaseDtoIds)).and(Tables.ITERATION_TEST_PLAN_ITEM.LAST_EXECUTED_ON.eq(lastExecutedOnDate.field("MAX_LAST_EXECUTED_ON", Timestamp.class))).fetchMap((Field)Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID, (Field)Tables.ITERATION_TEST_PLAN_ITEM.EXECUTION_STATUS);
    }
}

