/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.domain.NodeReference;
import org.squashtest.tm.domain.NodeReferences;
import org.squashtest.tm.domain.NodeWorkspace;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.repository.ParameterDao;
import org.squashtest.tm.service.internal.repository.display.DatasetDuplicationTreeBrowserDao;
import org.squashtest.tm.service.internal.repository.display.MultipleHierarchyTreeBrowserDao;

@Repository
public class DatasetDuplicationTreeBrowserDaoImpl
implements DatasetDuplicationTreeBrowserDao {
    private final ParameterDao parameterDao;
    private final DSLContext dsl;
    private final MultipleHierarchyTreeBrowserDao multipleHierarchyTreeBrowserDao;

    public DatasetDuplicationTreeBrowserDaoImpl(ParameterDao parameterDao, DSLContext dsl, MultipleHierarchyTreeBrowserDao multipleHierarchyTreeBrowserDao) {
        this.parameterDao = parameterDao;
        this.dsl = dsl;
        this.multipleHierarchyTreeBrowserDao = multipleHierarchyTreeBrowserDao;
    }

    @Override
    public Set<NodeReference> findLibraryReferences(NodeWorkspace workspace, Collection<Long> projectIds) {
        return this.multipleHierarchyTreeBrowserDao.findLibraryReferences(workspace, projectIds);
    }

    @Override
    public ListMultimap<NodeReference, NodeReference> findChildrenReference(Set<NodeReference> parentReferences) {
        return this.multipleHierarchyTreeBrowserDao.findChildrenReference(parentReferences);
    }

    @Override
    public Set<NodeReference> findAncestors(NodeReferences nodeReferences) {
        return this.multipleHierarchyTreeBrowserDao.findAncestors(nodeReferences);
    }

    @Override
    public Set<NodeReference> getEligibleTestCaseNodeReferences(Set<NodeReference> nodesToFilter, List<Parameter> sourceDataSetParameters, Set<NodeReference> rootNodes) {
        List<Long> rootNodeIds = rootNodes.stream().map(NodeReference::getId).toList();
        Set<Long> tclnIds = this.findEligibleTclnIds(rootNodeIds);
        return nodesToFilter.stream().filter(nodeReference -> this.checkNodeReferenceEligibility(sourceDataSetParameters, (NodeReference)nodeReference, tclnIds)).collect(Collectors.toSet());
    }

    public Set<Long> findEligibleTclnIds(List<Long> rootNodeIds) {
        Condition isRootNodeDescendantCondition = Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID.in(rootNodeIds).or(Tables.TCLN_RELATIONSHIP.ANCESTOR_ID.in(rootNodeIds));
        return new LinkedHashSet<Long>(this.dsl.selectDistinct((SelectField)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID).from((TableLike)Tables.TEST_CASE_LIBRARY_NODE).leftJoin((TableLike)Tables.TEST_CASE_LIBRARY_CONTENT).on(Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.TCLN_RELATIONSHIP).on(Tables.TCLN_RELATIONSHIP.DESCENDANT_ID.eq((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID)).leftJoin((TableLike)Tables.MILESTONE_TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.MILESTONE_TEST_CASE.TEST_CASE_ID)).leftJoin((TableLike)Tables.MILESTONE).on(Tables.MILESTONE_TEST_CASE.MILESTONE_ID.eq((Field)Tables.MILESTONE.MILESTONE_ID)).leftJoin((TableLike)Tables.SCRIPTED_TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.SCRIPTED_TEST_CASE.TCLN_ID)).leftJoin((TableLike)Tables.EXPLORATORY_TEST_CASE).on(Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID.eq((Field)Tables.EXPLORATORY_TEST_CASE.TCLN_ID)).where(Tables.MILESTONE.STATUS.notEqual((Object)MilestoneStatus.LOCKED.toString()).or(Tables.MILESTONE.STATUS.isNull()).and(isRootNodeDescendantCondition).and(Tables.SCRIPTED_TEST_CASE.TCLN_ID.isNull()).and(Tables.EXPLORATORY_TEST_CASE.TCLN_ID.isNull())).fetch((Field)Tables.TEST_CASE_LIBRARY_NODE.TCLN_ID));
    }

    public boolean checkNodeReferenceEligibility(List<Parameter> sourceDatasetParameters, NodeReference nodeReference, Set<Long> testCaseIds) {
        boolean isFolderOrLibraryNode;
        boolean isEligibleTestCaseNode = "TestCase".equals(nodeReference.getNodeType().getTypeName()) && testCaseIds.contains(nodeReference.getId());
        boolean bl = isFolderOrLibraryNode = "TestCaseLibrary".equals(nodeReference.getNodeType().getTypeName()) || "TestCaseFolder".equals(nodeReference.getNodeType().getTypeName());
        if (isEligibleTestCaseNode) {
            List<Parameter> targetDataSetParameters = this.parameterDao.findOwnParametersByTestCaseOrderedByName(nodeReference.getId());
            return this.checkHasMatchingParameters(sourceDatasetParameters, targetDataSetParameters);
        }
        return isFolderOrLibraryNode;
    }

    @Override
    public boolean checkHasMatchingParameters(List<Parameter> sourceDatasetParameters, List<Parameter> targetDatasetParameters) {
        String concatenatedTargetParameterString;
        List<Parameter> sortedSourceDatasetParameters = this.sortParameterListByName(sourceDatasetParameters);
        List<Parameter> sortedTargetDatasetParameters = this.sortParameterListByName(targetDatasetParameters);
        String concatenatedSourceParameterString = sortedSourceDatasetParameters.stream().map(Parameter::getName).collect(Collectors.joining(","));
        return concatenatedSourceParameterString.equals(concatenatedTargetParameterString = sortedTargetDatasetParameters.stream().map(Parameter::getName).collect(Collectors.joining(","))) || concatenatedTargetParameterString.isEmpty();
    }

    private List<Parameter> sortParameterListByName(List<Parameter> unsortedParameterList) {
        ArrayList<Parameter> sortedParameterList = new ArrayList<Parameter>(unsortedParameterList);
        sortedParameterList.sort(Comparator.comparing(Parameter::getName));
        return sortedParameterList;
    }
}

