/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.repository.display.impl;

import java.util.HashMap;
import java.util.Map;
import org.jooq.Field;
import org.jooq.Record3;
import org.jooq.SelectConditionStep;
import org.jooq.SelectOnConditionStep;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.squashtest.tm.domain.NodeType;
import org.squashtest.tm.jooq.domain.Tables;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AncestorLookupDefinition {
    REQUIREMENT_FOLDER_ANCESTORS(NodeType.REQUIREMENT_FOLDER, Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID, Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.REQUIREMENT_FOLDER, Tables.REQUIREMENT_FOLDER.RLN_ID);
            return relations;
        }
    }
    ,
    HIGH_LEVEL_REQUIREMENT_ANCESTORS(NodeType.HIGH_LEVEL_REQUIREMENT, Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID, Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.REQUIREMENT_FOLDER, Tables.REQUIREMENT_FOLDER.RLN_ID);
            relations.put(NodeType.HIGH_LEVEL_REQUIREMENT, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID);
            return relations;
        }
    }
    ,
    REQUIREMENT_ANCESTORS(NodeType.REQUIREMENT, Tables.RLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, Tables.RLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, Tables.REQUIREMENT_LIBRARY_CONTENT.LIBRARY_ID, Tables.REQUIREMENT_LIBRARY_CONTENT.CONTENT_ID){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.REQUIREMENT_FOLDER, Tables.REQUIREMENT_FOLDER.RLN_ID);
            relations.put(NodeType.HIGH_LEVEL_REQUIREMENT, Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID);
            relations.put(NodeType.REQUIREMENT, Tables.REQUIREMENT.RLN_ID);
            return relations;
        }

        @Override
        public void addAdditionalJoins(SelectOnConditionStep<Record3<String, Long, Long>> initialJoin, NodeType lookedType) {
            if (NodeType.REQUIREMENT.equals((Object)lookedType)) {
                initialJoin.leftJoin((TableLike)Tables.HIGH_LEVEL_REQUIREMENT).on(Tables.REQUIREMENT.RLN_ID.eq((Field)Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID));
            }
        }

        @Override
        public void addAdditionalCondition(SelectConditionStep<Record3<String, Long, Long>> query, NodeType lookedType) {
            if (NodeType.REQUIREMENT.equals((Object)lookedType)) {
                query.and(Tables.HIGH_LEVEL_REQUIREMENT.RLN_ID.isNull());
            }
        }
    }
    ,
    TEST_CASE_FOLDER_ANCESTORS(NodeType.TEST_CASE_FOLDER, Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID, Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.TEST_CASE_FOLDER, Tables.TEST_CASE_FOLDER.TCLN_ID);
            return relations;
        }
    }
    ,
    TEST_CASE_ANCESTORS(NodeType.TEST_CASE, Tables.TCLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, Tables.TCLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, Tables.TEST_CASE_LIBRARY_CONTENT.LIBRARY_ID, Tables.TEST_CASE_LIBRARY_CONTENT.CONTENT_ID){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.TEST_CASE_FOLDER, Tables.TEST_CASE_FOLDER.TCLN_ID);
            relations.put(NodeType.TEST_CASE, Tables.TEST_CASE.TCLN_ID);
            return relations;
        }
    }
    ,
    CAMPAIGN_FOLDER_ANCESTORS(NodeType.CAMPAIGN_FOLDER, Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, Tables.CAMPAIGN_LIBRARY_CONTENT.LIBRARY_ID, Tables.CAMPAIGN_LIBRARY_CONTENT.CONTENT_ID){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.CAMPAIGN_FOLDER, Tables.CAMPAIGN_FOLDER.CLN_ID);
            relations.put(NodeType.SPRINT_GROUP, Tables.SPRINT_GROUP.CLN_ID);
            return relations;
        }
    }
    ,
    SPRINT_GROUP_ANCESTORS(NodeType.SPRINT_GROUP, Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, Tables.CAMPAIGN_LIBRARY_CONTENT.LIBRARY_ID, Tables.CAMPAIGN_LIBRARY_CONTENT.CONTENT_ID){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.SPRINT_GROUP, Tables.SPRINT_GROUP.CLN_ID);
            relations.put(NodeType.CAMPAIGN_FOLDER, Tables.CAMPAIGN_FOLDER.CLN_ID);
            return relations;
        }
    }
    ,
    SPRINT_ANCESTORS(NodeType.SPRINT, Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, Tables.CAMPAIGN_LIBRARY_CONTENT.LIBRARY_ID, Tables.CAMPAIGN_LIBRARY_CONTENT.CONTENT_ID){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.SPRINT, Tables.SPRINT.CLN_ID);
            relations.put(NodeType.SPRINT_GROUP, Tables.SPRINT_GROUP.CLN_ID);
            relations.put(NodeType.CAMPAIGN_FOLDER, Tables.CAMPAIGN_FOLDER.CLN_ID);
            return relations;
        }
    }
    ,
    CAMPAIGN_ANCESTORS(NodeType.CAMPAIGN, Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID, Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID, Tables.CAMPAIGN_LIBRARY_CONTENT.LIBRARY_ID, Tables.CAMPAIGN_LIBRARY_CONTENT.CONTENT_ID){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.CAMPAIGN_FOLDER, Tables.CAMPAIGN_FOLDER.CLN_ID);
            relations.put(NodeType.CAMPAIGN, Tables.CAMPAIGN.CLN_ID);
            return relations;
        }
    }
    ,
    ITERATION_ANCESTORS(NodeType.ITERATION, Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID, Tables.CAMPAIGN_ITERATION.ITERATION_ID, null, null){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.CAMPAIGN, Tables.CAMPAIGN.CLN_ID);
            return relations;
        }
    }
    ,
    TEST_SUITES_ANCESTORS(NodeType.TEST_SUITE, Tables.ITERATION_TEST_SUITE.ITERATION_ID, Tables.ITERATION_TEST_SUITE.TEST_SUITE_ID, null, null){

        @Override
        public Map<NodeType, TableField<?, Long>> getRelationshipIds() {
            HashMap relations = new HashMap();
            relations.put(NodeType.ITERATION, Tables.ITERATION.ITERATION_ID);
            return relations;
        }
    };

    private final NodeType nodeType;
    private final TableField<?, Long> ancestorField;
    private final TableField<?, Long> descendantField;
    private final TableField<?, Long> libraryField;
    private final TableField<?, Long> libraryContentField;

    private AncestorLookupDefinition(NodeType nodeType, TableField<?, Long> ancestorField, TableField<?, Long> descendantField, TableField<?, Long> libraryField, TableField<?, Long> libraryContentField) {
        this.nodeType = nodeType;
        this.ancestorField = ancestorField;
        this.descendantField = descendantField;
        this.libraryField = libraryField;
        this.libraryContentField = libraryContentField;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public TableField<?, Long> getAncestorField() {
        return this.ancestorField;
    }

    public TableField<?, Long> getDescendantField() {
        return this.descendantField;
    }

    public abstract Map<NodeType, TableField<?, Long>> getRelationshipIds();

    public TableField<?, Long> getLibraryField() {
        return this.libraryField;
    }

    public TableField<?, Long> getLibraryContentField() {
        return this.libraryContentField;
    }

    public void addAdditionalJoins(SelectOnConditionStep<Record3<String, Long, Long>> initialJoin, NodeType lookedType) {
    }

    public void addAdditionalCondition(SelectConditionStep<Record3<String, Long, Long>> query, NodeType key) {
    }
}

