/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter.parsers;

import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.bdd.Keyword;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.SquashCustomFieldInfo;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.ActionTestStepToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.CalledTestCaseStepToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.DatasetParamToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.DatasetParamValueToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.DatasetToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.KeywordTestStepToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.testcaseworkspace.TestCaseToImport;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.parsers.AttachmentParserHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.PivotJsonParsingHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.parsers.TestCaseWorkspaceParser;

@Service(value="TestCaseWorkspaceParser")
public class TestCaseWorkspaceParserImpl
implements TestCaseWorkspaceParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseWorkspaceParser.class);

    @Override
    public TestCaseToImport parseTestCase(JsonParser jsonParser, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        TestCaseToImport testCaseToImport = new TestCaseToImport();
        try {
            while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
                String fieldName = jsonParser.getCurrentName();
                jsonParser.nextToken();
                switch (fieldName) {
                    case "id": {
                        testCaseToImport.setInternalId(jsonParser.getText());
                        break;
                    }
                    case "test_case_kind": {
                        testCaseToImport.setTestCaseKind(jsonParser.getText());
                        break;
                    }
                    case "name": {
                        testCaseToImport.setName(jsonParser.getText());
                        break;
                    }
                    case "description": {
                        testCaseToImport.setDescription(jsonParser.getText());
                        break;
                    }
                    case "reference": {
                        testCaseToImport.setReference(jsonParser.getText());
                        break;
                    }
                    case "importance": {
                        testCaseToImport.setImportance(TestCaseImportance.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "status": {
                        testCaseToImport.setStatus(TestCaseStatus.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "nature": {
                        testCaseToImport.setNature(jsonParser.getText());
                        break;
                    }
                    case "type": {
                        testCaseToImport.setType(jsonParser.getText());
                        break;
                    }
                    case "custom_fields": {
                        testCaseToImport.setCustomFields(PivotJsonParsingHelper.getCustomFieldValues(jsonParser, pivotImportMetadata.getCustomFieldIdsMap()));
                        break;
                    }
                    case "dataset_params": {
                        this.handleDatasetParams(jsonParser, testCaseToImport);
                        break;
                    }
                    case "datasets": {
                        this.handleDataSets(jsonParser, testCaseToImport);
                        break;
                    }
                    case "verified_requirements": {
                        testCaseToImport.setVerifiedRequirementIds(PivotJsonParsingHelper.getArrayStringValues(jsonParser));
                        break;
                    }
                    case "prerequisite": {
                        testCaseToImport.setPrerequisite(jsonParser.getText());
                        break;
                    }
                    case "script": {
                        testCaseToImport.setScript(jsonParser.getText());
                        break;
                    }
                    case "charter": {
                        testCaseToImport.setCharter(jsonParser.getText());
                        break;
                    }
                    case "session_duration": {
                        testCaseToImport.setSessionDuration(jsonParser.getIntValue());
                        break;
                    }
                    case "action_steps": {
                        this.handleActionTestSteps(jsonParser, testCaseToImport, pivotImportMetadata.getCustomFieldIdsMap());
                        break;
                    }
                    case "keyword_steps": {
                        this.handleKeyWordSteps(jsonParser, testCaseToImport);
                        break;
                    }
                    case "parent_type": {
                        testCaseToImport.setParentType(EntityType.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "parent_id": {
                        testCaseToImport.setParentId(jsonParser.getText());
                        break;
                    }
                    case "attachments": {
                        testCaseToImport.setAttachments(AttachmentParserHelper.parseAttachments(jsonParser));
                        break;
                    }
                }
            }
            PivotFormatLoggerHelper.logParsingSuccessForEntity(LOGGER, "test case", testCaseToImport.getName(), testCaseToImport.getInternalId(), pivotFormatImport);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleParsingErrorForEntity(LOGGER, "test case", testCaseToImport.getInternalId(), pivotFormatImport, e);
        }
        return testCaseToImport;
    }

    private void handleDatasetParams(JsonParser jsonParser, TestCaseToImport testCase) throws IOException {
        ArrayList<DatasetParamToImport> datasetParams = new ArrayList<DatasetParamToImport>();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
            if (!PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) continue;
            this.parseDatasetParam(jsonParser, datasetParams);
        }
        testCase.setDatasetParams(datasetParams);
    }

    private void parseDatasetParam(JsonParser jsonParser, List<DatasetParamToImport> datasetParams) throws IOException {
        DatasetParamToImport datasetParam = new DatasetParamToImport();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
            String fieldName = jsonParser.getCurrentName();
            jsonParser.nextToken();
            switch (fieldName) {
                case "id": {
                    datasetParam.setInternalId(jsonParser.getText());
                    break;
                }
                case "name": {
                    datasetParam.setName(jsonParser.getText());
                    break;
                }
                case "description": {
                    datasetParam.setDescription(jsonParser.getText());
                    break;
                }
            }
        }
        datasetParams.add(datasetParam);
    }

    private void handleDataSets(JsonParser jsonParser, TestCaseToImport testCase) throws IOException {
        ArrayList<DatasetToImport> dataSets = new ArrayList<DatasetToImport>();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
            if (!PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) continue;
            this.parseDataSet(jsonParser, dataSets);
        }
        testCase.setDataSets(dataSets);
    }

    private void parseDataSet(JsonParser jsonParser, List<DatasetToImport> dataSets) throws IOException {
        DatasetToImport dataset = new DatasetToImport();
        ArrayList<DatasetParamValueToImport> datasetParamValues = new ArrayList<DatasetParamValueToImport>();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
            String fieldName = jsonParser.getCurrentName();
            jsonParser.nextToken();
            switch (fieldName) {
                case "id": {
                    dataset.setInternalId(jsonParser.getText());
                    break;
                }
                case "name": {
                    dataset.setName(jsonParser.getText());
                    break;
                }
                case "param_values": {
                    this.handleDatasetParamValues(jsonParser, datasetParamValues);
                    break;
                }
            }
        }
        dataset.setParamValues(datasetParamValues);
        dataSets.add(dataset);
    }

    private void handleDatasetParamValues(JsonParser jsonParser, List<DatasetParamValueToImport> datasetParamValues) throws IOException {
        while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
            if (!PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) continue;
            this.parseDatasetParamValue(jsonParser, datasetParamValues);
        }
    }

    private void parseDatasetParamValue(JsonParser jsonParser, List<DatasetParamValueToImport> datasetParamValues) throws IOException {
        DatasetParamValueToImport datasetParamValue = new DatasetParamValueToImport();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
            String fieldName = jsonParser.getCurrentName();
            jsonParser.nextToken();
            if ("param_id".equals(fieldName)) {
                datasetParamValue.setInternalParamId(jsonParser.getText());
                continue;
            }
            if (!"value".equals(fieldName)) continue;
            datasetParamValue.setValue(jsonParser.getText());
        }
        datasetParamValues.add(datasetParamValue);
    }

    private void handleKeyWordSteps(JsonParser jsonParser, TestCaseToImport testCase) throws IOException {
        ArrayList<KeywordTestStepToImport> keywordSteps = new ArrayList<KeywordTestStepToImport>();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
            if (!PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) continue;
            this.parseKeywordStep(jsonParser, keywordSteps);
        }
        testCase.setKeywordTestSteps(keywordSteps);
    }

    private void parseKeywordStep(JsonParser jsonParser, List<KeywordTestStepToImport> keywordSteps) throws IOException {
        KeywordTestStepToImport keywordTestStepToImport = new KeywordTestStepToImport();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
            String fieldName = jsonParser.getCurrentName();
            jsonParser.nextToken();
            switch (fieldName) {
                case "id": {
                    keywordTestStepToImport.setInternalId(jsonParser.getText());
                    break;
                }
                case "keyword": {
                    keywordTestStepToImport.setKeyword(Keyword.valueOf((String)jsonParser.getText()));
                    break;
                }
                case "action_word": {
                    keywordTestStepToImport.setActionWord(jsonParser.getText());
                    break;
                }
                case "doc_string": {
                    keywordTestStepToImport.setDocString(jsonParser.getText());
                    break;
                }
                case "comment": {
                    keywordTestStepToImport.setComment(jsonParser.getText());
                    break;
                }
                case "data_table": {
                    keywordTestStepToImport.setDataTable(jsonParser.getText());
                    break;
                }
            }
        }
        keywordSteps.add(keywordTestStepToImport);
    }

    private void handleActionTestSteps(JsonParser jsonParser, TestCaseToImport testCaseToImport, Map<String, SquashCustomFieldInfo> customFieldIdsMap) throws IOException {
        ArrayList<ActionTestStepToImport> actionTestStepToImports = new ArrayList<ActionTestStepToImport>();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
            if (!PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) continue;
            this.parseActionTestStep(jsonParser, actionTestStepToImports, customFieldIdsMap);
        }
        testCaseToImport.setActionTestSteps(actionTestStepToImports);
    }

    private void parseActionTestStep(JsonParser jsonParser, List<ActionTestStepToImport> actionTestStepToImports, Map<String, SquashCustomFieldInfo> customFieldIdsMap) throws IOException {
        ActionTestStepToImport actionTestStepToImport = new ActionTestStepToImport();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
            String fieldName = jsonParser.getCurrentName();
            jsonParser.nextToken();
            switch (fieldName) {
                case "id": {
                    actionTestStepToImport.setInternalId(jsonParser.getText());
                    break;
                }
                case "action": {
                    actionTestStepToImport.setAction(jsonParser.getText());
                    break;
                }
                case "expected_result": {
                    actionTestStepToImport.setExpectedResult(jsonParser.getText());
                    break;
                }
                case "custom_fields": {
                    actionTestStepToImport.setCustomFields(PivotJsonParsingHelper.getCustomFieldValues(jsonParser, customFieldIdsMap));
                    break;
                }
                case "verified_requirements": {
                    actionTestStepToImport.setVerifiedRequirementIds(PivotJsonParsingHelper.getArrayStringValues(jsonParser));
                    break;
                }
                case "attachments": {
                    actionTestStepToImport.setAttachments(AttachmentParserHelper.parseAttachments(jsonParser));
                    break;
                }
            }
        }
        actionTestStepToImports.add(actionTestStepToImport);
    }

    @Override
    public CalledTestCaseStepToImport parseCalledTestCase(JsonParser jsonParser, PivotFormatImport pivotFormatImport) {
        CalledTestCaseStepToImport calledTestCaseStepToImport = new CalledTestCaseStepToImport();
        try {
            while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
                String fieldName = jsonParser.getCurrentName();
                jsonParser.nextToken();
                switch (fieldName) {
                    case "id": {
                        calledTestCaseStepToImport.setInternalId(jsonParser.getText());
                        break;
                    }
                    case "caller_id": {
                        calledTestCaseStepToImport.setCallerId(jsonParser.getText());
                        break;
                    }
                    case "called_id": {
                        calledTestCaseStepToImport.setCalledTestCaseInternalId(jsonParser.getText());
                        break;
                    }
                    case "index": {
                        calledTestCaseStepToImport.setIndex(jsonParser.getIntValue());
                        break;
                    }
                    case "parameter_assignation_mode": {
                        calledTestCaseStepToImport.setParameterAssignationMode(ParameterAssignationMode.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "dataset_id": {
                        calledTestCaseStepToImport.setInternalDatasetId(jsonParser.getText());
                        break;
                    }
                }
            }
            PivotFormatLoggerHelper.logParsingSuccessForUnnamedEntity(LOGGER, "called test case", calledTestCaseStepToImport.getInternalId(), pivotFormatImport);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleParsingErrorForEntity(LOGGER, "called test case", calledTestCaseStepToImport.getInternalId(), pivotFormatImport, e);
        }
        return calledTestCaseStepToImport;
    }
}

