/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter.parsers;

import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.CampaignStatus;
import org.squashtest.tm.domain.campaign.IterationStatus;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.campaignworkspace.CampaignToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.campaignworkspace.ExecutionStepInfo;
import org.squashtest.tm.service.internal.dto.projectimporter.campaignworkspace.ExecutionToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.campaignworkspace.IterationToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.campaignworkspace.TestSuiteToImport;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.parsers.AttachmentParserHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.PivotJsonParsingHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.parsers.ExecutionWorkspaceParser;

@Service(value="ExecutionWorkspaceParser")
public class ExecutionWorkspaceParserImpl
implements ExecutionWorkspaceParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionWorkspaceParserImpl.class);

    @Override
    public CampaignToImport parseCampaign(JsonParser jsonParser, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        CampaignToImport campaignToImport = new CampaignToImport();
        try {
            while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
                String fieldName = jsonParser.getCurrentName();
                jsonParser.nextToken();
                switch (fieldName) {
                    case "id": {
                        campaignToImport.setInternalId(jsonParser.getText());
                        break;
                    }
                    case "name": {
                        campaignToImport.setName(jsonParser.getText());
                        break;
                    }
                    case "description": {
                        campaignToImport.setDescription(jsonParser.getText());
                        break;
                    }
                    case "reference": {
                        campaignToImport.setReference(jsonParser.getText());
                        break;
                    }
                    case "status": {
                        campaignToImport.setStatus(CampaignStatus.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "scheduled_start_date": {
                        campaignToImport.setScheduledStartDate(this.parseIso8601Date(jsonParser.getText()));
                        break;
                    }
                    case "scheduled_end_date": {
                        campaignToImport.setScheduledEndDate(this.parseIso8601Date(jsonParser.getText()));
                        break;
                    }
                    case "actual_start_date": {
                        campaignToImport.setActualStartDate(this.parseIso8601Date(jsonParser.getText()));
                        break;
                    }
                    case "actual_end_date": {
                        campaignToImport.setActualEndDate(this.parseIso8601Date(jsonParser.getText()));
                        break;
                    }
                    case "actual_start_date_auto": {
                        campaignToImport.setActualStartAuto(jsonParser.getBooleanValue());
                        break;
                    }
                    case "actual_end_date_auto": {
                        campaignToImport.setActualEndAuto(jsonParser.getBooleanValue());
                        break;
                    }
                    case "custom_fields": {
                        campaignToImport.setCustomFields(PivotJsonParsingHelper.getCustomFieldValues(jsonParser, pivotImportMetadata.getCustomFieldIdsMap()));
                        break;
                    }
                    case "test_plan_test_case_ids": {
                        campaignToImport.setTestPlanTestCaseIds(PivotJsonParsingHelper.getArrayStringValues(jsonParser));
                        break;
                    }
                    case "parent_type": {
                        campaignToImport.setParentType(EntityType.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "parent_id": {
                        campaignToImport.setParentId(jsonParser.getText());
                        break;
                    }
                    case "attachments": {
                        campaignToImport.setAttachments(AttachmentParserHelper.parseAttachments(jsonParser));
                        break;
                    }
                }
            }
            PivotFormatLoggerHelper.logParsingSuccessForEntity(LOGGER, "campaign", campaignToImport.getName(), campaignToImport.getInternalId(), pivotFormatImport);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleParsingErrorForEntity(LOGGER, "campaign", campaignToImport.getInternalId(), pivotFormatImport, e);
        }
        return campaignToImport;
    }

    @Override
    public IterationToImport parseIteration(JsonParser jsonParser, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        IterationToImport iterationToImport = new IterationToImport();
        try {
            while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
                String fieldName = jsonParser.getCurrentName();
                jsonParser.nextToken();
                switch (fieldName) {
                    case "id": {
                        iterationToImport.setInternalId(jsonParser.getText());
                        break;
                    }
                    case "name": {
                        iterationToImport.setName(jsonParser.getText());
                        break;
                    }
                    case "description": {
                        iterationToImport.setDescription(jsonParser.getText());
                        break;
                    }
                    case "reference": {
                        iterationToImport.setReference(jsonParser.getText());
                        break;
                    }
                    case "status": {
                        iterationToImport.setStatus(IterationStatus.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "scheduled_start_date": {
                        iterationToImport.setScheduledStartDate(this.parseIso8601Date(jsonParser.getText()));
                        break;
                    }
                    case "scheduled_end_date": {
                        iterationToImport.setScheduledEndDate(this.parseIso8601Date(jsonParser.getText()));
                        break;
                    }
                    case "actual_start_date": {
                        iterationToImport.setActualStartDate(this.parseIso8601Date(jsonParser.getText()));
                        break;
                    }
                    case "actual_end_date": {
                        iterationToImport.setActualEndDate(this.parseIso8601Date(jsonParser.getText()));
                        break;
                    }
                    case "actual_start_date_auto": {
                        iterationToImport.setActualStartAuto(jsonParser.getBooleanValue());
                        break;
                    }
                    case "actual_end_date_auto": {
                        iterationToImport.setActualEndAuto(jsonParser.getBooleanValue());
                        break;
                    }
                    case "custom_fields": {
                        iterationToImport.setCustomFields(PivotJsonParsingHelper.getCustomFieldValues(jsonParser, pivotImportMetadata.getCustomFieldIdsMap()));
                        break;
                    }
                    case "test_plan_test_case_ids": {
                        iterationToImport.setTestPlanTestCaseIds(PivotJsonParsingHelper.getArrayStringValues(jsonParser));
                        break;
                    }
                    case "parent_id": {
                        iterationToImport.setParentId(jsonParser.getText());
                        break;
                    }
                    case "attachments": {
                        iterationToImport.setAttachments(AttachmentParserHelper.parseAttachments(jsonParser));
                        break;
                    }
                }
            }
            PivotFormatLoggerHelper.logParsingSuccessForEntity(LOGGER, "iteration", iterationToImport.getName(), iterationToImport.getInternalId(), pivotFormatImport);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleParsingErrorForEntity(LOGGER, "iteration", iterationToImport.getInternalId(), pivotFormatImport, e);
        }
        return iterationToImport;
    }

    @Override
    public TestSuiteToImport parseTestSuite(JsonParser jsonParser, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        TestSuiteToImport testSuiteToImport = new TestSuiteToImport();
        try {
            while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
                String fieldName = jsonParser.getCurrentName();
                jsonParser.nextToken();
                switch (fieldName) {
                    case "id": {
                        testSuiteToImport.setInternalId(jsonParser.getText());
                        break;
                    }
                    case "name": {
                        testSuiteToImport.setName(jsonParser.getText());
                        break;
                    }
                    case "description": {
                        testSuiteToImport.setDescription(jsonParser.getText());
                        break;
                    }
                    case "status": {
                        testSuiteToImport.setExecutionStatus(ExecutionStatus.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "custom_fields": {
                        testSuiteToImport.setCustomFields(PivotJsonParsingHelper.getCustomFieldValues(jsonParser, pivotImportMetadata.getCustomFieldIdsMap()));
                        break;
                    }
                    case "test_plan_test_case_ids": {
                        testSuiteToImport.setTestPlanTestCaseIds(PivotJsonParsingHelper.getArrayStringValues(jsonParser));
                        break;
                    }
                    case "parent_id": {
                        testSuiteToImport.setParentId(jsonParser.getText());
                        break;
                    }
                    case "attachments": {
                        testSuiteToImport.setAttachments(AttachmentParserHelper.parseAttachments(jsonParser));
                        break;
                    }
                }
            }
            PivotFormatLoggerHelper.logParsingSuccessForEntity(LOGGER, "test suite", testSuiteToImport.getName(), testSuiteToImport.getInternalId(), pivotFormatImport);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleParsingErrorForEntity(LOGGER, "test suite", testSuiteToImport.getInternalId(), pivotFormatImport, e);
        }
        return testSuiteToImport;
    }

    @Override
    public ExecutionToImport parseExecution(JsonParser jsonParser, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        ExecutionToImport executionToImport = new ExecutionToImport();
        try {
            while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
                String fieldName = jsonParser.getCurrentName();
                jsonParser.nextToken();
                switch (fieldName) {
                    case "id": {
                        executionToImport.setInternalId(jsonParser.getText());
                        break;
                    }
                    case "comment": {
                        executionToImport.setComment(jsonParser.getText());
                        break;
                    }
                    case "status": {
                        executionToImport.setExecutionStatus(ExecutionStatus.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "custom_fields": {
                        executionToImport.setCustomFields(PivotJsonParsingHelper.getCustomFieldValues(jsonParser, pivotImportMetadata.getCustomFieldIdsMap()));
                        break;
                    }
                    case "last_executed_by": {
                        executionToImport.setLastExecutedBy(jsonParser.getText());
                        break;
                    }
                    case "last_executed_on": {
                        executionToImport.setLastExecutedOn(this.parseIso8601DateTime(jsonParser.getText()));
                        break;
                    }
                    case "execution_steps": {
                        this.handleExecutionSteps(jsonParser, executionToImport, pivotImportMetadata);
                        break;
                    }
                    case "test_case_id": {
                        executionToImport.setTestCaseId(jsonParser.getText());
                        break;
                    }
                    case "dataset_id": {
                        executionToImport.setDatasetId(jsonParser.getText());
                        break;
                    }
                    case "parent_id": {
                        executionToImport.setParentId(jsonParser.getText());
                        break;
                    }
                    case "parent_type": {
                        executionToImport.setParentType(EntityType.valueOf((String)jsonParser.getText()));
                        break;
                    }
                    case "attachments": {
                        executionToImport.setAttachments(AttachmentParserHelper.parseAttachments(jsonParser));
                        break;
                    }
                }
            }
            PivotFormatLoggerHelper.logParsingSuccessForUnnamedEntity(LOGGER, "execution", executionToImport.getInternalId(), pivotFormatImport);
        }
        catch (Exception e) {
            PivotFormatLoggerHelper.handleParsingErrorForEntity(LOGGER, "execution", executionToImport.getInternalId(), pivotFormatImport, e);
        }
        return executionToImport;
    }

    private void handleExecutionSteps(JsonParser jsonParser, ExecutionToImport execution, PivotImportMetadata pivotImportMetadata) throws IOException, ParseException {
        ArrayList<ExecutionStepInfo> executionStepsInfo = new ArrayList<ExecutionStepInfo>();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedArray(jsonParser)) {
            if (!PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) continue;
            this.parseExecutionStep(jsonParser, executionStepsInfo, pivotImportMetadata);
        }
        execution.setExecutionSteps(executionStepsInfo);
    }

    private void parseExecutionStep(JsonParser jsonParser, List<ExecutionStepInfo> executionStepsInfo, PivotImportMetadata pivotImportMetadata) throws IOException, ParseException {
        ExecutionStepInfo executionStepInfo = new ExecutionStepInfo();
        while (PivotJsonParsingHelper.isNotTheEndOfParsedObject(jsonParser)) {
            String fieldName = jsonParser.getCurrentName();
            jsonParser.nextToken();
            switch (fieldName) {
                case "test_step_id": {
                    executionStepInfo.setTestStepId(jsonParser.getText());
                    break;
                }
                case "status": {
                    executionStepInfo.setStatus(ExecutionStatus.valueOf((String)jsonParser.getText()));
                    break;
                }
                case "comment": {
                    executionStepInfo.setComment(jsonParser.getText());
                    break;
                }
                case "custom_fields": {
                    executionStepInfo.setCustomFields(PivotJsonParsingHelper.getCustomFieldValues(jsonParser, pivotImportMetadata.getCustomFieldIdsMap()));
                    break;
                }
                case "last_executed_by": {
                    executionStepInfo.setLastExecutedBy(jsonParser.getText());
                    break;
                }
                case "last_executed_on": {
                    executionStepInfo.setLastExecutedOn(this.parseIso8601DateTime(jsonParser.getText()));
                    break;
                }
                case "attachments": {
                    executionStepInfo.setAttachments(AttachmentParserHelper.parseAttachments(jsonParser));
                    break;
                }
            }
        }
        executionStepsInfo.add(executionStepInfo);
    }

    private Date parseIso8601Date(String date) throws ParseException {
        try {
            return DateUtils.parseIso8601Date((String)date);
        }
        catch (ParseException e) {
            LOGGER.error("Error while trying to parse date: {}", new Object[]{date});
            throw e;
        }
    }

    private Date parseIso8601DateTime(String date) throws ParseException {
        try {
            return DateUtils.parseIso8601DateTime((String)date);
        }
        catch (ParseException e) {
            LOGGER.error("Error while trying to parse date: {}", new Object[]{date});
            throw e;
        }
    }
}

