/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.projectimporter.pivotimporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Service;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.projectimporter.PivotFormatImport;
import org.squashtest.tm.exception.pivotformatimport.CouldNotBindCustomFieldDuringImportException;
import org.squashtest.tm.service.customfield.CustomCustomFieldManagerService;
import org.squashtest.tm.service.customfield.CustomFieldBindingModificationService;
import org.squashtest.tm.service.customfield.CustomFieldFinderService;
import org.squashtest.tm.service.internal.dto.projectimporter.CustomFieldToImport;
import org.squashtest.tm.service.internal.dto.projectimporter.JsonImportFile;
import org.squashtest.tm.service.internal.dto.projectimporter.PivotImportMetadata;
import org.squashtest.tm.service.internal.dto.projectimporter.ProjectIdsReferences;
import org.squashtest.tm.service.internal.dto.projectimporter.SquashCustomFieldInfo;
import org.squashtest.tm.service.internal.projectimporter.pivotimporter.PivotFormatLoggerHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.CustomFieldPivotImporterService;
import org.squashtest.tm.service.projectimporter.pivotimporter.PivotJsonParsingHelper;
import org.squashtest.tm.service.projectimporter.pivotimporter.parsers.CustomFieldParser;

@Service(value="CustomFieldPivotImporterService")
public class CustomFieldPivotImporterServiceImpl
implements CustomFieldPivotImporterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldPivotImporterServiceImpl.class);
    private final CustomCustomFieldManagerService customFieldManagerService;
    private final CustomFieldBindingModificationService customFieldBindingModificationService;
    private final CustomFieldFinderService customFieldFinderService;
    private final CustomFieldParser customFieldParser;
    @PersistenceContext
    private EntityManager entityManager;

    public CustomFieldPivotImporterServiceImpl(CustomCustomFieldManagerService customFieldManagerService, CustomFieldBindingModificationService customFieldBindingModificationService, CustomFieldFinderService customFieldFinderService, CustomFieldParser customFieldParser) {
        this.customFieldManagerService = customFieldManagerService;
        this.customFieldBindingModificationService = customFieldBindingModificationService;
        this.customFieldFinderService = customFieldFinderService;
        this.customFieldParser = customFieldParser;
    }

    @Override
    public void importCustomFieldsFromZipArchive(ZipFile zipFile, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        PivotFormatLoggerHelper.logImportStartedForEntitiesKind(LOGGER, zipFile.getName(), "custom fields", pivotFormatImport);
        ZipEntry entry = zipFile.getEntry(JsonImportFile.CUSTOM_FIELDS.getFileName());
        if (Objects.nonNull(entry)) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream jsonInputStream = zipFile.getInputStream(entry);){
                    this.handleCustomFieldsInJsonFile(jsonInputStream, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
                    PivotFormatLoggerHelper.logImportSuccessForEntitiesKind(LOGGER, "custom fields", pivotFormatImport);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.logImportFailureForEntitiesKind(LOGGER, "custom fields", pivotFormatImport);
                throw e;
            }
        }
    }

    private void handleCustomFieldsInJsonFile(InputStream jsonInputStream, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        Throwable throwable = null;
        Object var7_8 = null;
        try (JsonParser jsonParser = jsonFactory.createParser(jsonInputStream);){
            while (jsonParser.nextToken() != null) {
                this.parseCustomFieldArray(jsonParser, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseCustomFieldArray(JsonParser jsonParser, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) throws IOException {
        customFieldsToImport = new ArrayList<CustomFieldToImport>();
        if ("custom_fields".equals(jsonParser.getCurrentName())) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            if (PivotJsonParsingHelper.isStartingToParseNewObject(jsonParser)) {
                customFieldToImport = this.customFieldParser.parseCustomField(jsonParser, pivotFormatImport);
                this.addParsedCustomFieldToCustomFieldsToImport(customFieldsToImport, pivotImportMetadata, projectIdsReferences, pivotFormatImport, customFieldToImport);
            }
            if (customFieldsToImport.size() != 100) continue;
            this.createCustomFields(customFieldsToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
lbl9:
            // 3 sources

            ** while (PivotJsonParsingHelper.isNotTheEndOfParsedArray((JsonParser)jsonParser))
        }
lbl10:
        // 1 sources

        if (!customFieldsToImport.isEmpty()) {
            this.createCustomFields(customFieldsToImport, projectIdsReferences, pivotImportMetadata, pivotFormatImport);
        }
    }

    private void addParsedCustomFieldToCustomFieldsToImport(List<CustomFieldToImport> customFieldsToImport, PivotImportMetadata pivotImportMetadata, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport, CustomFieldToImport customFieldToImport) {
        CustomField existingCustomField = this.customFieldFinderService.findByCodeAndInputType(customFieldToImport.getCustomField().getCode(), customFieldToImport.getCustomField().getInputType());
        if (Objects.nonNull(existingCustomField)) {
            this.handleExistingCustomField(pivotImportMetadata, projectIdsReferences, customFieldToImport, existingCustomField, pivotFormatImport);
        } else {
            customFieldsToImport.add(customFieldToImport);
        }
    }

    private void handleExistingCustomField(PivotImportMetadata pivotImportMetadata, ProjectIdsReferences projectIdsReferences, CustomFieldToImport customFieldToImport, CustomField existingCustomField, PivotFormatImport pivotFormatImport) {
        CustomFieldPivotImporterServiceImpl.logCustomFieldAlreadyExistsInSquash(customFieldToImport, pivotFormatImport);
        pivotImportMetadata.getCustomFieldIdsMap().put(customFieldToImport.getInternalId(), new SquashCustomFieldInfo(existingCustomField.getId(), existingCustomField.getInputType()));
        this.addCustomFieldBindingsToProject(existingCustomField, projectIdsReferences, customFieldToImport.getBoundEntities(), pivotFormatImport);
    }

    private static void logCustomFieldAlreadyExistsInSquash(CustomFieldToImport customFieldToImport, PivotFormatImport pivotFormatImport) {
        LOGGER.info("CustomFieldPivotImporterService - Import id {} - Custom field \"{}\" with internal id {} already exists in Squash. Import will use the existing custom field for entity bindings", new Object[]{pivotFormatImport.getId(), customFieldToImport.getCustomField().getName(), customFieldToImport.getInternalId()});
    }

    private void createCustomFields(List<CustomFieldToImport> customFieldsToImport, ProjectIdsReferences projectIdsReferences, PivotImportMetadata pivotImportMetadata, PivotFormatImport pivotFormatImport) {
        for (CustomFieldToImport customFieldToImport : customFieldsToImport) {
            PivotFormatLoggerHelper.logEntityCreationStarted(LOGGER, "custom field", customFieldToImport.getInternalId(), pivotFormatImport);
            try {
                CustomField customField = this.customFieldManagerService.persistUnsecured(customFieldToImport.getCustomField());
                this.addCustomFieldBindingsToProject(customFieldToImport.getCustomField(), projectIdsReferences, customFieldToImport.getBoundEntities(), pivotFormatImport);
                pivotImportMetadata.getCustomFieldIdsMap().put(customFieldToImport.getInternalId(), new SquashCustomFieldInfo(customField.getId(), customField.getInputType()));
                PivotFormatLoggerHelper.logEntityCreatedSuccessfully(LOGGER, "custom field", customFieldToImport.getCustomField().getName(), customFieldToImport.getInternalId(), pivotFormatImport);
            }
            catch (Exception e) {
                PivotFormatLoggerHelper.handleEntityCreationFailed(LOGGER, "custom field", customFieldToImport.getCustomField().getName(), customFieldToImport.getInternalId(), pivotFormatImport, e);
            }
        }
        customFieldsToImport.clear();
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void addCustomFieldBindingsToProject(CustomField customField, ProjectIdsReferences projectIdsReferences, List<BindableEntity> boundEntities, PivotFormatImport pivotFormatImport) {
        CustomFieldPivotImporterServiceImpl.logAddCustomFieldBindings(customField, projectIdsReferences, pivotFormatImport);
        boundEntities.forEach(boundEntity -> {
            try {
                this.customFieldBindingModificationService.addNewCustomFieldBindingUnsecured(projectIdsReferences.getId(), (BindableEntity)boundEntity, customField.getId());
            }
            catch (Exception e) {
                String message = String.format("Import Id: %s - Project id: %s - Failed to add custom field binding to entity \"%s\" for the custom field \"%s\"", pivotFormatImport.getId(), projectIdsReferences.getId(), boundEntity, customField.getName());
                LOGGER.error(message, new Object[0]);
                throw new CouldNotBindCustomFieldDuringImportException(message, (Throwable)e);
            }
        });
    }

    private static void logAddCustomFieldBindings(CustomField customField, ProjectIdsReferences projectIdsReferences, PivotFormatImport pivotFormatImport) {
        LOGGER.info("Import Id: {} - Adding custom field bindings to project (id: {}) for the custom field \"{}\"", new Object[]{pivotFormatImport.getId(), projectIdsReferences.getId(), customField.getName()});
    }
}

