/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.project;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.projectfilter.ProjectFilter;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.internal.repository.ProjectFilterDao;
import org.squashtest.tm.service.project.ProjectFilterModificationService;
import org.squashtest.tm.service.project.ProjectManagerService;
import org.squashtest.tm.service.security.UserContextService;

@Service(value="squashtest.tm.service.ProjectFilterModificationService")
@Transactional
public class ProjectFilterModificationServiceImpl
implements ProjectFilterModificationService {
    @Inject
    private ProjectFilterDao projectFilterDao;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private ProjectManagerService projectManager;
    @Inject
    private UserContextService userContextService;

    @Override
    public ProjectFilter findProjectFilterByUserLogin() {
        ProjectFilter filter = this.findPersistentProjectFilter();
        if (filter != null) {
            return filter;
        }
        return this.createDefaultProjectFilter();
    }

    @Override
    public List<ProjectFilter> removeProjectFiltersByUserLogin(String userLogin) {
        return this.projectFilterDao.removeByUserLogin(userLogin);
    }

    @Override
    public void saveOrUpdateProjectFilter(List<Long> projectIdList, boolean isActive) {
        ProjectFilter projectFilter = this.findOrCreateProjectFilter();
        projectFilter.setProjects(this.projectDao.findByIdIn(projectIdList));
        projectFilter.setActivated(isActive);
    }

    @Override
    public void updateProjectFilterStatus(boolean status) {
        this.findOrCreateProjectFilter().setActivated(status);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Project> getAllProjects() {
        return this.projectManager.findAllOrderedByName();
    }

    private ProjectFilter findPersistentProjectFilter() {
        String userLogin = this.userContextService.getUsername();
        return this.projectFilterDao.findByUserLogin(userLogin);
    }

    private ProjectFilter createDefaultProjectFilter() {
        ProjectFilter toReturn = new ProjectFilter();
        String userLogin = this.userContextService.getUsername();
        toReturn.setProjects(this.getAllProjects());
        toReturn.setUserLogin(userLogin);
        toReturn.setActivated(false);
        return toReturn;
    }

    private ProjectFilter findOrCreateProjectFilter() {
        ProjectFilter filter = this.findPersistentProjectFilter();
        if (filter == null) {
            filter = this.createDefaultProjectFilter();
            this.projectFilterDao.save(filter);
        }
        return filter;
    }
}

