/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.Sprint;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.NodeVisitor;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.requirement.HighLevelRequirement;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.internal.library.NodePairing;

@Component
@Scope(value="prototype")
public class NextLayerFeeder
implements NodeVisitor {
    private Collection<NodePairing> nextLayer;
    private TreeNode destination;
    private Collection<? extends TreeNode> outputList;
    private ClipboardPayload clipboardPayload;

    public void feedNextLayer(TreeNode destination, TreeNode source, Collection<NodePairing> nextLayer, Collection<? extends TreeNode> outputList, ClipboardPayload clipboardPayload) {
        this.nextLayer = nextLayer;
        this.destination = destination;
        this.outputList = outputList;
        this.clipboardPayload = clipboardPayload;
        source.accept((NodeVisitor)this);
    }

    public void feedNextLayerFromReqToTc(TreeNode destination, TreeNode source, Collection<NodePairing> nextLayer, Collection<? extends TreeNode> outputList) {
        this.nextLayer = nextLayer;
        this.destination = destination;
        this.outputList = outputList;
        if (source instanceof Requirement) {
            Requirement req = (Requirement)source;
            if (req.hasContent()) {
                ArrayList<TreeNode> sourceContent = new ArrayList<TreeNode>(req.getOrderedContent());
                sourceContent.removeAll(this.outputList);
                nextLayer.add(new NodePairing((NodeContainer<TreeNode>)((NodeContainer)destination), sourceContent));
            }
        } else {
            RequirementFolder reqFolder = (RequirementFolder)source;
            if (reqFolder.hasContent()) {
                ArrayList<TreeNode> sourceContent = new ArrayList<TreeNode>(reqFolder.getOrderedContent());
                sourceContent.removeAll(outputList);
                nextLayer.add(new NodePairing((NodeContainer<TreeNode>)((NodeContainer)destination), sourceContent));
            }
        }
    }

    public void visit(CampaignFolder campaignFolder) {
        this.saveNextToCopy((NodeContainer<? extends TreeNode>)campaignFolder, (NodeContainer<? extends TreeNode>)((CampaignFolder)this.destination));
    }

    public void visit(RequirementFolder requirementFolder) {
        this.saveNextToCopy((NodeContainer<? extends TreeNode>)requirementFolder, (NodeContainer<? extends TreeNode>)((RequirementFolder)this.destination));
    }

    public void visit(TestCaseFolder testCaseFolder) {
        this.saveNextToCopy((NodeContainer<? extends TreeNode>)testCaseFolder, (NodeContainer<? extends TreeNode>)((TestCaseFolder)this.destination));
    }

    public void visit(Campaign campaign) {
        this.saveNextToCopy((NodeContainer<? extends TreeNode>)campaign, (NodeContainer<? extends TreeNode>)((Campaign)this.destination));
    }

    public void visit(Iteration iteration) {
        this.saveNextToCopy((NodeContainer<? extends TreeNode>)iteration, (NodeContainer<? extends TreeNode>)((Iteration)this.destination));
    }

    public void visit(TestSuite testSuite) {
    }

    public void visit(Sprint sprint) {
    }

    public void visit(SprintGroup sprintGroup) {
        this.saveNextToCopy((NodeContainer<? extends TreeNode>)sprintGroup, (NodeContainer<? extends TreeNode>)((SprintGroup)this.destination));
    }

    public void visit(Requirement requirement) {
        this.saveNextToCopy((NodeContainer<? extends TreeNode>)requirement, (NodeContainer<? extends TreeNode>)((Requirement)this.destination));
    }

    public void visit(HighLevelRequirement highLevelRequirement) {
        this.saveNextToCopy((NodeContainer<? extends TreeNode>)highLevelRequirement, (NodeContainer<? extends TreeNode>)((HighLevelRequirement)this.destination));
    }

    public void visit(TestCase testCase) {
    }

    private void saveNextToCopy(NodeContainer<? extends TreeNode> source, NodeContainer<? extends TreeNode> destination) {
        if (source.hasContent()) {
            List<TreeNode> sourceContent = new ArrayList<TreeNode>(source.getOrderedContent());
            sourceContent.removeAll(this.outputList);
            if (!this.clipboardPayload.shouldWhiteListBeIgnored()) {
                sourceContent = sourceContent.stream().filter(node -> this.clipboardPayload.getWhiteListNodeIds().contains(node.getId())).toList();
            }
            this.nextLayer.add(new NodePairing(destination, sourceContent));
        }
    }
}

