/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.library;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.customfield.RichTextValue;
import org.squashtest.tm.domain.library.AbstractExportData;
import org.squashtest.tm.domain.library.Folder;
import org.squashtest.tm.domain.library.Library;
import org.squashtest.tm.domain.library.LibraryNode;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.exception.library.NameAlreadyExistsAtDestinationException;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.clipboard.model.ClipboardPayload;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.library.FirstLayerTreeNodeMover;
import org.squashtest.tm.service.internal.library.NextLayersTreeNodeMover;
import org.squashtest.tm.service.internal.library.NodeDeletionHandler;
import org.squashtest.tm.service.internal.library.PasteStrategy;
import org.squashtest.tm.service.internal.library.TreeNodeCopier;
import org.squashtest.tm.service.internal.repository.FolderDao;
import org.squashtest.tm.service.internal.repository.LibraryDao;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.library.LibraryNavigationService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.security.PermissionsUtils;
import org.squashtest.tm.service.security.SecurityCheckableObject;

@Transactional
public abstract class AbstractLibraryNavigationService<LIBRARY extends Library<NODE>, FOLDER extends Folder<NODE>, NODE extends LibraryNode>
implements LibraryNavigationService<LIBRARY, FOLDER, NODE> {
    private static final String CREATE = "CREATE";
    private static final String READ = "READ";
    @Inject
    protected PermissionEvaluationService permissionService;
    @Inject
    private PrivateCustomFieldValueService customFieldValuesService;
    @Inject
    private Provider<TreeNodeCopier> treeNodeCopierProvider;
    @Inject
    private Provider<FirstLayerTreeNodeMover> firstLayerMoverProvider;
    @Inject
    private Provider<NextLayersTreeNodeMover> nextLayersMoverProvider;
    @Inject
    protected AttachmentManagerService attachmentManagerService;

    protected abstract FolderDao<FOLDER, NODE> getFolderDao();

    protected abstract LibraryDao<LIBRARY, NODE> getLibraryDao();

    protected abstract LibraryNodeDao<NODE> getLibraryNodeDao();

    protected abstract NodeDeletionHandler<NODE, FOLDER> getDeletionHandler();

    protected abstract PasteStrategy<FOLDER, NODE> getPasteToFolderStrategy();

    protected abstract PasteStrategy<LIBRARY, NODE> getPasteToLibraryStrategy();

    @Override
    public LIBRARY findLibrary(long libraryId) {
        LIBRARY library = this.getLibraryDao().findById(libraryId);
        this.checkPermission(new SecurityCheckableObject(library, READ));
        return library;
    }

    @Override
    public LIBRARY findCreatableLibrary(long libraryId) {
        LIBRARY library = this.getLibraryDao().findById(libraryId);
        this.checkPermission(new SecurityCheckableObject(library, CREATE));
        return library;
    }

    @Override
    public FOLDER findFolder(long folderId) {
        Folder folder = (Folder)this.getFolderDao().findById(folderId);
        this.checkPermission(new SecurityCheckableObject(folder, READ));
        return (FOLDER)((Folder)this.getFolderDao().findById(folderId));
    }

    @Override
    public FOLDER addFolderToLibrary(long destinationId, FOLDER newFolder) {
        this.doAddFolderToLibrary(destinationId, newFolder);
        return newFolder;
    }

    @Override
    public FOLDER addFolderToLibrary(long destinationId, FOLDER newFolder, Map<Long, RawValue> customFields) {
        this.doAddFolderToLibrary(destinationId, newFolder);
        this.addCustomFieldsToFolder(customFields, newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        return newFolder;
    }

    @Override
    public FOLDER addFolderToFolder(long destinationId, FOLDER newFolder) {
        this.doAddFolderToFolder(destinationId, newFolder);
        return newFolder;
    }

    @Override
    public FOLDER addFolderToFolder(long destinationId, FOLDER newFolder, Map<Long, RawValue> customFields) {
        this.doAddFolderToFolder(destinationId, newFolder);
        this.addCustomFieldsToFolder(customFields, newFolder);
        this.createAttachmentsFromLibraryNode((LibraryNode)newFolder, (BoundEntity)newFolder);
        return newFolder;
    }

    @Override
    public FOLDER findParentIfExists(LibraryNode node) {
        return this.getFolderDao().findParentOf(node.getId());
    }

    @Override
    public FOLDER findParentIfExists(Long node) {
        return this.getFolderDao().findParentOf(node);
    }

    @Override
    public LIBRARY findLibraryOfRootNodeIfExist(NODE node) {
        return this.getLibraryDao().findByRootContent(node);
    }

    @Override
    public LIBRARY findLibraryOfRootNodeIfExist(Long nodeId) {
        LibraryNode node = (LibraryNode)this.getLibraryNodeDao().findById(nodeId);
        return this.getLibraryDao().findByRootContent(node);
    }

    protected void createCustomFieldValues(BoundEntity entity) {
        this.customFieldValuesService.createAllCustomFieldValues(entity, entity.getProject());
    }

    protected void createCustomFieldValues(Collection<? extends BoundEntity> entities) {
        for (BoundEntity boundEntity : entities) {
            this.createCustomFieldValues(boundEntity);
        }
    }

    protected void createBatchCustomFieldValues(Collection<? extends BoundEntity> boundEntities, Project project) {
        this.customFieldValuesService.createAllCustomFieldValues(boundEntities, project);
    }

    protected void copyAttachmentsFromLibraryNode(LibraryNode node, Long copiedAttachmentListId) {
        if (node.getId() != null) {
            String html;
            Long attachmentListId = node.getAttachmentList().getId();
            EntityReference entityReference = node.toEntityReference();
            String description = node.getDescription();
            if (description != null && !description.isEmpty() && !description.equals(html = this.attachmentManagerService.copyAttachmentsFromRichText(description, attachmentListId, copiedAttachmentListId, entityReference))) {
                node.setDescription(html);
            }
        }
    }

    protected void createAttachmentsFromLibraryNode(LibraryNode node, BoundEntity entity) {
        if (node.getId() != null) {
            Long attachmentListId = node.getAttachmentList().getId();
            EntityReference entityReference = node.toEntityReference();
            this.createAttachmentsFromNodeDescription(node, attachmentListId, entityReference);
            this.createAttachmentsFromCuf(entity, attachmentListId, entityReference);
        }
    }

    private void createAttachmentsFromNodeDescription(LibraryNode node, Long attachmentListId, EntityReference entityReference) {
        String html;
        String description = node.getDescription();
        if (description != null && !description.isEmpty() && !description.equals(html = this.attachmentManagerService.addAttachmentsFromRichText(description, attachmentListId, entityReference))) {
            node.setDescription(html);
        }
    }

    public void createAttachmentsFromCuf(BoundEntity entity, Long attachmentListId, EntityReference entityReference) {
        List<CustomFieldValue> persistentValues = this.customFieldValuesService.findAllCustomFieldValues(entity);
        persistentValues.forEach(customFieldValue -> {
            String html;
            String value;
            if (customFieldValue instanceof RichTextValue && !(value = customFieldValue.getValue()).equals(html = this.attachmentManagerService.addAttachmentsFromRichText(value, attachmentListId, entityReference))) {
                customFieldValue.setValue(html);
            }
        });
    }

    @Override
    public void moveNodesToFolder(long destinationId, Long[] targetIds, ClipboardPayload clipboardPayload) {
        if (targetIds.length == 0) {
            return;
        }
        try {
            PasteStrategy<FOLDER, NODE> pasteStrategy = this.getPasteToFolderStrategy();
            this.makeMoverStrategy(pasteStrategy);
            pasteStrategy.pasteNodes(destinationId, clipboardPayload);
        }
        catch (NullArgumentException | DuplicateNameException dne) {
            throw new NameAlreadyExistsAtDestinationException((Exception)dne);
        }
    }

    @Override
    public void moveNodesToFolder(long destinationId, Long[] targetIds) {
        this.moveNodesToFolder(destinationId, targetIds, ClipboardPayload.withWhiteListIgnored(Arrays.asList(targetIds)));
    }

    @Override
    public void moveNodesToLibrary(long destinationId, Long[] targetIds, ClipboardPayload clipboardPayload) {
        if (targetIds.length == 0) {
            return;
        }
        try {
            PasteStrategy<LIBRARY, NODE> pasteStrategy = this.getPasteToLibraryStrategy();
            this.makeMoverStrategy(pasteStrategy);
            pasteStrategy.pasteNodes(destinationId, clipboardPayload);
        }
        catch (NullArgumentException | DuplicateNameException dne) {
            throw new NameAlreadyExistsAtDestinationException((Exception)dne);
        }
    }

    @Override
    public void moveNodesToFolder(long destinationId, Long[] targetIds, int position, ClipboardPayload clipboardPayload) {
        if (targetIds.length == 0) {
            return;
        }
        try {
            PasteStrategy<FOLDER, NODE> pasteStrategy = this.getPasteToFolderStrategy();
            this.makeMoverStrategy(pasteStrategy);
            pasteStrategy.pasteNodes(destinationId, clipboardPayload, position);
        }
        catch (NullArgumentException | DuplicateNameException dne) {
            throw new NameAlreadyExistsAtDestinationException((Exception)dne);
        }
    }

    @Override
    public void moveNodesToLibrary(long destinationId, Long[] targetIds, int position, ClipboardPayload clipboardPayload) {
        if (targetIds.length == 0) {
            return;
        }
        try {
            PasteStrategy<LIBRARY, NODE> pasteStrategy = this.getPasteToLibraryStrategy();
            this.makeMoverStrategy(pasteStrategy);
            pasteStrategy.pasteNodes(destinationId, clipboardPayload, position);
        }
        catch (NullArgumentException | DuplicateNameException dne) {
            throw new NameAlreadyExistsAtDestinationException((Exception)dne);
        }
    }

    @Override
    public void copyNodesToFolder(long destinationId, Long[] sourceNodesIds, ClipboardPayload clipboardPayload) {
        PasteStrategy<FOLDER, NODE> pasteStrategy = this.getPasteToFolderStrategy();
        this.makeCopierStrategy(pasteStrategy);
        pasteStrategy.pasteNodes(destinationId, clipboardPayload);
    }

    @Override
    public void copyReqToTestCasesNodesToFolder(long destinationId, Long[] sourceNodesIds, ClipboardPayload clipboardPayload) {
        if (sourceNodesIds.length == 0) {
            return;
        }
        try {
            PasteStrategy<FOLDER, NODE> pasteStrategy = this.getPasteToFolderStrategy();
            this.makeMoverStrategy(pasteStrategy);
            pasteStrategy.pasteNodes(destinationId, clipboardPayload, 0);
        }
        catch (NullArgumentException | DuplicateNameException dne) {
            throw new NameAlreadyExistsAtDestinationException((Exception)dne);
        }
    }

    @Override
    public void copyNodesToLibrary(long destinationId, Long[] targetIds, ClipboardPayload clipboardPayload) {
        PasteStrategy<LIBRARY, NODE> pasteStrategy = this.getPasteToLibraryStrategy();
        this.makeCopierStrategy(pasteStrategy);
        pasteStrategy.pasteNodes(destinationId, clipboardPayload);
    }

    @Override
    public List<SuppressionPreviewReport> simulateDeletion(List<Long> targetIds) {
        return this.getDeletionHandler().simulateDeletion(targetIds);
    }

    @Override
    public OperationReport deleteNodes(List<Long> targetIds) {
        List nodes = this.getLibraryNodeDao().findAllByIds(targetIds);
        for (LibraryNode node : nodes) {
            this.checkPermission(new SecurityCheckableObject(node, "DELETE"));
        }
        return this.getDeletionHandler().deleteNodes(targetIds);
    }

    protected void makeCopierStrategy(PasteStrategy<?, ?> pasteStrategy) {
        pasteStrategy.setFirstLayerOperationFactory(this.treeNodeCopierProvider);
        pasteStrategy.setNextLayersOperationFactory(this.treeNodeCopierProvider);
    }

    protected void makeMoverStrategy(PasteStrategy<?, ?> pasteStrategy) {
        pasteStrategy.setFirstLayerOperationFactory(this.firstLayerMoverProvider);
        pasteStrategy.setNextLayersOperationFactory(this.nextLayersMoverProvider);
    }

    protected void checkPermission(SecurityCheckableObject ... checkableObjects) {
        PermissionsUtils.checkPermission(this.permissionService, checkableObjects);
    }

    protected List<? extends AbstractExportData> setFullFolderPath(List<? extends AbstractExportData> dataset) {
        for (AbstractExportData abstractExportData : dataset) {
            Long id = abstractExportData.getFolderId();
            StringBuilder path = new StringBuilder();
            if (!id.equals(AbstractExportData.NO_FOLDER)) {
                for (String name : this.getLibraryNodeDao().getParentsName(id)) {
                    path.append('/').append(name);
                }
                if (path.length() != 0) {
                    path.deleteCharAt(0);
                }
            }
            abstractExportData.setFolderName(path.toString());
        }
        return dataset;
    }

    protected Set<Long> securityFilterIds(Collection<Long> original, String entityType, String permission) {
        HashSet<Long> effective = new HashSet<Long>();
        for (Long id : original) {
            if (!this.permissionService.hasRoleOrPermissionOnObject("ROLE_ADMIN", permission, id, entityType)) continue;
            effective.add(id);
        }
        return effective;
    }

    private void addCustomFieldsToFolder(Map<Long, RawValue> customFields, FOLDER newFolder) {
        this.createCustomFieldValues((BoundEntity)newFolder);
        if (customFields != null && !customFields.isEmpty()) {
            this.customFieldValuesService.initCustomFieldValues((BoundEntity)newFolder, customFields);
        }
    }

    private void doAddFolderToLibrary(long destinationId, FOLDER newFolder) {
        LIBRARY container = this.getLibraryDao().findById(destinationId);
        this.checkPermission(new SecurityCheckableObject(container, CREATE));
        container.addContent(newFolder);
        this.getFolderDao().persist(newFolder);
    }

    private void doAddFolderToFolder(long destinationId, FOLDER newFolder) {
        Folder container = (Folder)this.getFolderDao().findById(destinationId);
        this.checkPermission(new SecurityCheckableObject(container, CREATE));
        container.addContent(newFolder);
        this.getFolderDao().persist(newFolder);
    }
}

