/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.feature;

import javax.inject.Inject;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.milestone.MilestoneManagerService;

@Service(value="featureManager")
@Transactional
public class FeatureManagerImpl
implements FeatureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureManagerImpl.class);
    @Inject
    @Lazy
    private ConfigurationService configuration;
    @Inject
    @Lazy
    private MilestoneManagerService milestoneManager;

    @Override
    public boolean isEnabled(FeatureManager.Feature feature) {
        LOGGER.trace("Polling feature {}", new Object[]{feature});
        return switch (feature) {
            case FeatureManager.Feature.MILESTONE -> this.configuration.getBoolean("feature.milestone.enabled");
            case FeatureManager.Feature.CASE_INSENSITIVE_LOGIN -> this.configuration.getBoolean("feature.caseInsensitiveLogin.enabled");
            case FeatureManager.Feature.CASE_INSENSITIVE_ACTIONS -> this.configuration.getBoolean("feature.caseInsensitiveActions.enabled");
            case FeatureManager.Feature.STACK_TRACE -> this.configuration.getBoolean("feature.stackTrace.enabled");
            case FeatureManager.Feature.AUTOCONNECT_ON_CONNECTION -> this.configuration.getBoolean("autoconnect.on.connection.enabled");
            case FeatureManager.Feature.SEARCH_ACTIVATION -> this.configuration.getBoolean("feature.searchActivation.enabled");
            case FeatureManager.Feature.UNSAFE_ATTACHMENT_PREVIEW -> this.configuration.getBoolean("feature.unsafeAttachmentPreview.enabled");
            default -> throw new IllegalArgumentException("I don't know feature '" + (Object)((Object)feature) + "'. I am unable to tell if it's enabled or not");
        };
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void setEnabled(FeatureManager.Feature feature, boolean enabled) {
        LOGGER.trace("Setting feature {} to {}", new Object[]{feature, enabled});
        switch (feature) {
            case MILESTONE: {
                this.setMilestoneFeatureEnabled(enabled);
                break;
            }
            case CASE_INSENSITIVE_LOGIN: {
                this.setCaseInsensitiveLoginFeatureEnabled(enabled);
                break;
            }
            case CASE_INSENSITIVE_ACTIONS: {
                this.setCaseInsensitiveActionsFeatureEnabled(enabled);
                break;
            }
            case STACK_TRACE: {
                this.setStackTraceFeatureEnabled(enabled);
                break;
            }
            case AUTOCONNECT_ON_CONNECTION: {
                this.setAutoconnectOnConnectionEnabled(enabled);
                break;
            }
            case SEARCH_ACTIVATION: {
                this.setSearchActivationFeatureEnabled(enabled);
                break;
            }
            case UNSAFE_ATTACHMENT_PREVIEW: {
                this.setUnsafeAttachmentPreviewEnabled(enabled);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown feature '%s'.".formatted(new Object[]{feature}));
            }
        }
    }

    private void setCaseInsensitiveLoginFeatureEnabled(boolean enabled) {
        this.configuration.set("feature.caseInsensitiveLogin.enabled", enabled);
    }

    private void setCaseInsensitiveActionsFeatureEnabled(boolean enabled) {
        this.configuration.set("feature.caseInsensitiveActions.enabled", enabled);
    }

    private void setStackTraceFeatureEnabled(boolean enabled) {
        this.configuration.set("feature.stackTrace.enabled", enabled);
    }

    private void setAutoconnectOnConnectionEnabled(boolean enabled) {
        this.configuration.set("autoconnect.on.connection.enabled", enabled);
    }

    private void setMilestoneFeatureEnabled(boolean enabled) {
        this.configuration.set("feature.milestone.enabled", enabled);
        if (enabled) {
            this.milestoneManager.enableFeature();
        } else {
            this.milestoneManager.disableFeature();
        }
    }

    private void setSearchActivationFeatureEnabled(boolean enabled) {
        this.configuration.set("feature.searchActivation.enabled", enabled);
    }

    private void setUnsafeAttachmentPreviewEnabled(boolean enabled) {
        this.configuration.set("feature.unsafeAttachmentPreview.enabled", enabled);
    }
}

