/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentList;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldValue;
import org.squashtest.tm.domain.customfield.CustomFieldVisitor;
import org.squashtest.tm.domain.customfield.MultiSelectField;
import org.squashtest.tm.domain.customfield.NumericField;
import org.squashtest.tm.domain.customfield.RichTextField;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldHolder;
import org.squashtest.tm.domain.denormalizedfield.DenormalizedFieldValue;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.CallTestStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.DatasetParamValue;
import org.squashtest.tm.domain.testcase.TestStepVisitor;
import org.squashtest.tm.service.denormalizedfield.DenormalizedFieldValueManager;
import org.squashtest.tm.service.execution.ExecutionProcessingService;
import org.squashtest.tm.service.internal.denormalizedfield.PrivateDenormalizedFieldValueService;
import org.squashtest.tm.service.internal.repository.CustomFieldValueDao;
import org.squashtest.tm.service.internal.repository.ExecutionStepDao;

@Component
public class ExecutionStepModificationHelper {
    @Inject
    private DenormalizedFieldValueManager denormalizedFieldValueManager;
    @Inject
    private CustomFieldValueDao customFieldValueDao;
    @Inject
    private ExecutionStepDao executionStepDao;
    @Inject
    private PrivateDenormalizedFieldValueService privateDenormalizedFieldValueService;
    @Inject
    private ExecutionProcessingService executionProcessingService;

    public long doUpdateStep(List<ExecutionStep> toBeUpdated, Execution execution) {
        long firstModifiedIndex = -1L;
        for (ExecutionStep execStep : toBeUpdated) {
            ActionTestStep step = (ActionTestStep)execStep.getReferencedTestStep();
            if (step == null) {
                execution.removeStep(execStep.getId().longValue());
                continue;
            }
            firstModifiedIndex = firstModifiedIndex < 0L ? (long)execution.getStepIndex(execStep.getId().longValue()) : firstModifiedIndex;
            Dataset dataset = this.findStepDataset(execution, step);
            if (dataset != null) {
                execStep.fillParameterMap(dataset);
            }
            step.accept((TestStepVisitor)execStep);
            this.executionProcessingService.changeExecutionStepStatus(execStep.getId(), ExecutionStatus.READY);
            this.privateDenormalizedFieldValueService.deleteAllDenormalizedFieldValues((DenormalizedFieldHolder)execStep);
            this.privateDenormalizedFieldValueService.createAllDenormalizedFieldValues((BoundEntity)step, (DenormalizedFieldHolder)execStep);
            for (Attachment actionStepAttach : step.getAllAttachments()) {
                if (this.doesListContainAttachment(execStep.getAttachmentList(), actionStepAttach)) continue;
                Attachment clone = actionStepAttach.shallowCopy();
                execStep.getAttachmentList().addAttachment(clone);
            }
            this.executionStepDao.persist(execStep);
        }
        return firstModifiedIndex;
    }

    private Dataset findStepDataset(Execution execution, ActionTestStep step) {
        if (this.isExecutionWithParameters(step)) {
            Long aStepTestCaseId = step.getTestCase().getId();
            Optional<CallTestStep> optionalCallTestStep = execution.getReferencedTestCase().getCallSteps().stream().filter(callTestStep -> callTestStep.getCalledTestCase().getId().equals(aStepTestCaseId)).findFirst();
            if (optionalCallTestStep.isPresent() && !optionalCallTestStep.get().isDelegateParameterValues()) {
                return optionalCallTestStep.get().getCalledDataset();
            }
            return execution.getReferencedDataset();
        }
        return null;
    }

    public List<ExecutionStep> findStepsToUpdate(Execution execution) {
        List execSteps = execution.getSteps();
        ArrayList<ExecutionStep> toBeUpdated = new ArrayList<ExecutionStep>();
        for (ExecutionStep eStep : execSteps) {
            ActionTestStep aStep = (ActionTestStep)eStep.getReferencedTestStep();
            if (aStep == null) continue;
            if (this.isExecutionWithParameters(aStep)) {
                Long aStepTestCaseId = aStep.getTestCase().getId();
                Optional<CallTestStep> optionalCallTestStep = execution.getReferencedTestCase().getCallSteps().stream().filter(callTestStep -> callTestStep.getCalledTestCase().getId().equals(aStepTestCaseId)).findFirst();
                this.handleStepParam(execution, toBeUpdated, eStep, aStep, optionalCallTestStep);
                continue;
            }
            this.testingStep(aStep, eStep, toBeUpdated);
        }
        return toBeUpdated;
    }

    private void handleStepParam(Execution execution, List<ExecutionStep> toBeUpdated, ExecutionStep eStep, ActionTestStep aStep, Optional<CallTestStep> optionalCallTestStep) {
        if (optionalCallTestStep.isPresent() && !optionalCallTestStep.get().isDelegateParameterValues()) {
            Dataset dataset = optionalCallTestStep.get().getCalledDataset();
            this.changeStepParamsByValue(eStep, aStep, dataset, toBeUpdated);
        } else if (this.isExecutionWithDataset(execution)) {
            Dataset dataset = execution.getTestPlan().getReferencedDataset();
            this.changeStepParamsByValue(eStep, aStep, dataset, toBeUpdated);
        } else {
            this.testingStep(aStep, eStep, toBeUpdated);
        }
    }

    private void testingStep(ActionTestStep aStep, ExecutionStep eStep, List<ExecutionStep> toBeUpdated) {
        if (!this.isStepEqual(eStep, aStep)) {
            toBeUpdated.add(eStep);
        }
    }

    private boolean isExecutionWithParameters(ActionTestStep aStep) {
        return aStep.findUsedParametersNames() != null;
    }

    private boolean isExecutionWithDataset(Execution execution) {
        if (execution.getTestPlan() != null) {
            return execution.getTestPlan().getReferencedDataset() != null;
        }
        return false;
    }

    private void changeStepParamsByValue(ExecutionStep eStep, ActionTestStep aStep, Dataset dataset, List<ExecutionStep> toBeUpdated) {
        String action = aStep.getAction();
        String expectedResult = aStep.getExpectedResult();
        Set params = aStep.findUsedParametersNames();
        for (String param : params) {
            for (DatasetParamValue dpv : dataset.getParameterValues()) {
                this.changeStepParamByValue(aStep, param, dpv);
            }
        }
        if (!this.isStepEqual(eStep, aStep)) {
            toBeUpdated.add(eStep);
        }
        this.reinitiateActionTestStep(aStep, action, expectedResult);
    }

    private void changeStepParamByValue(ActionTestStep aStep, String param, DatasetParamValue dpv) {
        String paramValue = "";
        if (dpv.getParameter().getName().equals(param)) {
            paramValue = dpv.getParamValue();
            if (aStep.getExpectedResult().contains(param)) {
                aStep.setExpectedResult(aStep.getExpectedResult().replace("${" + param + "}", paramValue));
            }
            aStep.setAction(aStep.getAction().replace("${" + param + "}", paramValue));
        }
    }

    private void reinitiateActionTestStep(ActionTestStep aStep, String action, String expectedResult) {
        aStep.setAction(action);
        aStep.setExpectedResult(expectedResult);
    }

    private boolean isStepEqual(ExecutionStep eStep, ActionTestStep aStep) {
        return this.actionStepExist(aStep) && this.sameAction(eStep, aStep) && this.sameResult(eStep, aStep) && this.sameAttach(eStep, aStep) && this.sameCufs(eStep, aStep);
    }

    private boolean sameCufs(ExecutionStep eStep, ActionTestStep aStep) {
        List<DenormalizedFieldValue> denormalizedFieldValues = this.denormalizedFieldValueManager.findAllForEntity((DenormalizedFieldHolder)eStep);
        List<CustomFieldValue> originalValues = this.customFieldValueDao.findAllCustomValues(aStep.getId(), BindableEntity.TEST_STEP);
        if (originalValues.size() != denormalizedFieldValues.size()) {
            return false;
        }
        for (DenormalizedFieldValue denormVal : denormalizedFieldValues) {
            CustomFieldValue origVal = denormVal.getCustomFieldValue();
            if (origVal != null && !this.hasChanged(denormVal, origVal)) continue;
            return false;
        }
        return true;
    }

    private boolean hasChanged(final DenormalizedFieldValue denormVal, final CustomFieldValue origVal) {
        final boolean[] hasChanged = new boolean[1];
        origVal.getCustomField().accept(new CustomFieldVisitor(){

            private void testValChange() {
                if (ExecutionStepModificationHelper.this.valueHasChanged(denormVal, origVal)) {
                    hasChanged[0] = true;
                }
            }

            public void visit(MultiSelectField multiSelect) {
                this.testValChange();
            }

            public void visit(RichTextField richField) {
                this.testValChange();
            }

            public void visit(NumericField numericField) {
                this.testValChange();
            }

            public void visit(CustomField standardValue) {
                this.testValChange();
            }

            public void visit(SingleSelectField selectField) {
                this.testValChange();
            }
        });
        return hasChanged[0];
    }

    private boolean valueHasChanged(DenormalizedFieldValue denormVal, CustomFieldValue origVal) {
        return !denormVal.getValue().equals(origVal.getValue());
    }

    private boolean actionStepExist(ActionTestStep aStep) {
        return aStep != null;
    }

    private boolean sameAction(ExecutionStep eStep, ActionTestStep aStep) {
        return eStep.getAction().equals(aStep.getAction());
    }

    private boolean sameResult(ExecutionStep eStep, ActionTestStep aStep) {
        return eStep.getExpectedResult().equals(aStep.getExpectedResult());
    }

    private boolean sameAttach(ExecutionStep eStep, ActionTestStep aStep) {
        AttachmentList eStepAttach = eStep.getAttachmentList();
        Set aStepAttach = aStep.getAllAttachments();
        for (Attachment aAttach : aStepAttach) {
            boolean exist = this.doesListContainAttachment(eStepAttach, aAttach);
            if (exist) continue;
            return false;
        }
        return true;
    }

    boolean doesListContainAttachment(AttachmentList attachmentList, Attachment attachment) {
        return CollectionUtils.exists((Collection)attachmentList.getAllAttachments(), item -> {
            Attachment toCompare = (Attachment)item;
            boolean sameName = toCompare.getName().equals(attachment.getName());
            boolean sameSize = toCompare.getSize().equals(attachment.getSize());
            return sameName && sameSize;
        });
    }
}

