/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.dto.projectimporterxray.topivotdto.entity.testcaseworkspace;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.internal.dto.projectimporterxray.jooq.dto.CustomFieldXrayDto;
import org.squashtest.tm.service.internal.dto.projectimporterxray.topivotdto.entity.AbstractPivotEntity;
import org.squashtest.tm.service.internal.dto.projectimporterxray.topivotdto.mapping.XrayPriority;
import org.squashtest.tm.service.internal.dto.projectimporterxray.topivotdto.mapping.XrayStatus;

public abstract class CommonTestCase
extends AbstractPivotEntity {
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @JsonProperty(value="test_case_kind")
    private TestCaseKind testCaseKind;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="reference")
    private String reference;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @JsonProperty(value="importance")
    private TestCaseImportance importance;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @JsonProperty(value="status")
    private TestCaseStatus status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="nature")
    private String nature;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="verified_requirements")
    private List<String> verifiedRequirements = new ArrayList<String>();
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @JsonProperty(value="parent_type")
    private EntityType parentType;

    public void setParentTypeAndId(List<CustomFieldXrayDto> testRepositoryPath, Map<String, String> testCaseFolderIdMap) {
        if (Objects.nonNull(testRepositoryPath) && !testRepositoryPath.isEmpty()) {
            this.parentType = EntityType.TEST_CASE_FOLDER;
            String path = StringUtils.trim((String)testRepositoryPath.get(0).getValue().replaceAll("</?\\w+>", ""));
            this.parentId = testCaseFolderIdMap.get(path);
        } else {
            this.parentType = EntityType.TEST_CASE_LIBRARY;
        }
    }

    @Override
    public BindableEntity getBindableEntity() {
        return BindableEntity.TEST_CASE;
    }

    public void setPivotId(Integer id) {
        this.pivotId = String.format("%s%s", "TC", id);
    }

    public TestCaseKind getTestCaseKind() {
        return this.testCaseKind;
    }

    public void setTestCaseKind(TestCaseKind testCaseKind) {
        this.testCaseKind = testCaseKind;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public TestCaseImportance getImportance() {
        return this.importance;
    }

    public void setImportance(XrayPriority priority) {
        this.importance = priority.getTestCaseImportance();
    }

    public TestCaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(XrayStatus status) {
        this.status = status.getTestCaseStatus();
    }

    public String getNature() {
        return this.nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getVerifiedRequirements() {
        return this.verifiedRequirements;
    }

    public void setVerifiedRequirements(List<String> verifiedRequirements) {
        this.verifiedRequirements = verifiedRequirements;
    }

    public EntityType getParentType() {
        return this.parentType;
    }

    public void setParentType(EntityType parentType) {
        this.parentType = parentType;
    }
}

