/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.testcase;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.service.display.testcase.TestCasePathFinderService;
import org.squashtest.tm.service.internal.library.HibernatePathService;

@Service
@Transactional(readOnly=true)
public class TestCasePathFinderServiceImpl
implements TestCasePathFinderService {
    @PersistenceContext
    private EntityManager em;

    @Override
    public String buildTestCasePath(Long testCaseId, String testCaseProjectName) {
        if (testCaseId != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(testCaseProjectName);
            String pathFromFolder = this.getPathFromFolder(testCaseId);
            sb.append(pathFromFolder);
            return HibernatePathService.substituteSpecialPathSeparator(sb.toString());
        }
        return null;
    }

    private String getPathFromFolder(Long testCaseId) {
        String result = this.testCaseQuery("TestCase.findPathById", testCaseId, "");
        if (!result.isEmpty()) {
            return " \u001f " + result;
        }
        return "";
    }

    private <R> R testCaseQuery(String queryName, Long testCaseId, R defaultValue) {
        Session session = this.getStatelessSession();
        Query q = session.getNamedQuery(queryName);
        q.setParameter("testCaseId", (Object)testCaseId);
        Object result = q.uniqueResult();
        return (R)(result != null ? result : defaultValue);
    }

    private Session getStatelessSession() {
        Session s = (Session)this.em.unwrap(Session.class);
        s.setHibernateFlushMode(FlushMode.MANUAL);
        return s;
    }
}

