/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.scm.server;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.scm.ScmRepository;
import org.squashtest.tm.domain.scm.ScmServer;
import org.squashtest.tm.service.display.scm.server.ScmServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.CredentialsDto;
import org.squashtest.tm.service.internal.display.dto.ScmRepositoryDto;
import org.squashtest.tm.service.internal.display.dto.ScmServerAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.ScmServerDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.administration.ScmServerGrid;
import org.squashtest.tm.service.internal.repository.ScmServerDao;
import org.squashtest.tm.service.internal.repository.display.ScmServerDisplayDao;
import org.squashtest.tm.service.scmserver.ScmRepositoryManagerService;
import org.squashtest.tm.service.scmserver.ScmServerCredentialsService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@Service
@Transactional
public class ScmServerDisplayServiceImpl
implements ScmServerDisplayService {
    private final DSLContext dsl;
    private final ScmServerDao scmServerDao;
    private final ScmServerDisplayDao scmServerDisplayDao;
    private final ScmRepositoryManagerService scmRepositoryManager;
    private final StoredCredentialsManager credentialsManager;
    private final ScmServerCredentialsService scmServerCredentialsService;
    private final PermissionEvaluationService permissionEvaluationService;

    @Inject
    ScmServerDisplayServiceImpl(DSLContext dsl, ScmServerDao scmServerDao, ScmRepositoryManagerService scmRepositoryManager, ScmServerDisplayDao scmServerDisplayDao, StoredCredentialsManager credentialsManager, ScmServerCredentialsService scmServerCredentialsService, PermissionEvaluationService permissionEvaluationService) {
        this.dsl = dsl;
        this.scmServerDao = scmServerDao;
        this.scmRepositoryManager = scmRepositoryManager;
        this.scmServerDisplayDao = scmServerDisplayDao;
        this.credentialsManager = credentialsManager;
        this.scmServerCredentialsService = scmServerCredentialsService;
        this.permissionEvaluationService = permissionEvaluationService;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public GridResponse findAll(GridRequest gridRequest) {
        return new ScmServerGrid().getRows(gridRequest, this.dsl);
    }

    @Override
    public List<ScmServerDto> getAllServersAndRepositories() {
        this.permissionEvaluationService.checkAtLeastOneProjectManagementPermissionOrAdmin();
        List<ScmServer> allServers = this.scmServerDao.findAllByOrderByNameAsc();
        return allServers.stream().map(scmServer -> new ScmServerDto((ScmServer)scmServer, this.scmRepositoryManager.findClonedByScmServerOrderByName(scmServer.getId()))).toList();
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ScmServerAdminViewDto getScmServerView(long scmServerId) {
        ScmServerAdminViewDto scmServer = this.scmServerDisplayDao.getScmServerViewById(scmServerId);
        ManageableCredentials credentials = this.credentialsManager.findAppLevelCredentials(scmServerId);
        scmServer.setCredentials(CredentialsDto.from(credentials));
        ScmServer actualScmServer = (ScmServer)this.scmServerDao.getReferenceById(scmServerId);
        List<String> supportedProtocols = Arrays.stream(this.scmServerCredentialsService.getSupportedProtocols(actualScmServer)).map(Enum::name).toList();
        scmServer.setSupportedAuthenticationProtocols(supportedProtocols);
        this.appendRepositories(scmServerId, scmServer);
        return scmServer;
    }

    private void appendRepositories(long scmServerId, ScmServerAdminViewDto scmServer) {
        List<ScmRepository> repositories = this.scmRepositoryManager.findByScmServerOrderByPath(scmServerId);
        List<ScmRepositoryDto> repositoriesDto = repositories.stream().map(ScmRepositoryDto::new).toList();
        scmServer.setRepositories(repositoriesDto);
    }
}

