/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.infolist;

import javax.inject.Inject;
import javax.transaction.Transactional;
import org.jooq.DSLContext;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.service.display.infolist.InfoListDisplayService;
import org.squashtest.tm.service.internal.display.dto.InfoListAdminViewDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.administration.InfoListGrid;
import org.squashtest.tm.service.internal.repository.display.InfoListDisplayDao;

@Service
@Transactional
public class InfoListDisplayServiceImpl
implements InfoListDisplayService {
    private final DSLContext dsl;
    private InfoListDisplayDao infoListDisplayDao;

    @Inject
    public InfoListDisplayServiceImpl(DSLContext dsl, InfoListDisplayDao infoListDisplayDao) {
        this.dsl = dsl;
        this.infoListDisplayDao = infoListDisplayDao;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public GridResponse findAll(GridRequest request) {
        GridResponse response = new InfoListGrid().getRows(request, this.dsl);
        response.sanitizeField("description");
        return response;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public InfoListAdminViewDto getInfoListView(long infoListId) {
        InfoListAdminViewDto infoList = this.infoListDisplayDao.getInfoListById(infoListId);
        this.checkInfoListIsSystem(infoList.getCode());
        return infoList;
    }

    private void checkInfoListIsSystem(String infoListCode) {
        if (SystemInfoListCode.isSystem((String)infoListCode)) {
            throw new IllegalAccessError("This is a system info list! Access denied");
        }
    }
}

