/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.testcase;

import java.util.Arrays;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.ClnRelationshipClosure;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;
import org.squashtest.tm.service.internal.display.grid.columns.LevelEnumColumn;

public class TestCaseSessionsGrid
extends AbstractGrid {
    private static final String CLN_FULL_PATH = "CLN_FULL_PATH";
    private static final String PATH_SEPARATOR = " > ";
    private static final String CLN_PATH = "CLN_PATH";
    private final Long testCaseId;

    public TestCaseSessionsGrid(Long testCaseId) {
        this.testCaseId = testCaseId;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn(DSL.field((String)"PROJECT_ID")), new GridColumn(DSL.field((String)"OVERVIEW_ID")), new LevelEnumColumn(ExecutionStatus.class, (Field<String>)DSL.field((String)"EXECUTION_STATUS", String.class)), new GridColumn(DSL.field((String)"EXECUTION_COUNT")), new GridColumn(DSL.field((String)"EXECUTION_PATH")), new GridColumn(DSL.field((String)"LAST_EXECUTED_ON")), new GridColumn(DSL.field((String)"NB_ISSUES")));
    }

    private SelectHavingStep<?> getTestSuite() {
        return DSL.select((SelectField)DSL.groupConcat((Field)Tables.TEST_SUITE.NAME).as("TEST_SUITES"), (SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID).from((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).innerJoin((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID.eq((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).innerJoin((TableLike)Tables.TEST_SUITE).on(Tables.TEST_SUITE_TEST_PLAN_ITEM.SUITE_ID.eq((Field)Tables.TEST_SUITE.ID)).where(Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID.eq((Object)this.testCaseId)).groupBy(new GroupField[]{Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.TEST_SUITE.ID});
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<?> testSuites = this.getTestSuite();
        Table<?> clnPathTable = this.getClnPathTable();
        return DSL.select((SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, (SelectField)DSL.coalesce((Field)Tables.ITERATION_TEST_PLAN_ITEM.EXECUTION_STATUS, (Field[])new Field[]{Tables.TEST_PLAN_ITEM.EXECUTION_STATUS}).as("EXECUTION_STATUS"), (SelectField)Tables.PROJECT.PROJECT_ID, (SelectField)DSL.countDistinct((Field)Tables.EXECUTION.EXECUTION_ID).as("EXECUTION_COUNT"), (SelectField)DSL.countDistinct((Field)Tables.ISSUE.REMOTE_ISSUE_ID).as("NB_ISSUES"), (SelectField)DSL.coalesce((Field)Tables.ITERATION_TEST_PLAN_ITEM.TCLN_ID, (Field[])new Field[]{Tables.TEST_PLAN_ITEM.TCLN_ID}).as("TCLN_ID"), (SelectField)DSL.coalesce((Field)Tables.ITERATION_TEST_PLAN_ITEM.LAST_EXECUTED_ON, (Field[])new Field[]{Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON}).as("LAST_EXECUTED_ON"), (SelectField)DSL.concat((Field[])new Field[]{clnPathTable.field(CLN_FULL_PATH, String.class), DSL.when((Condition)Tables.ITERATION.NAME.isNotNull(), (Field)DSL.concat((Field[])new Field[]{DSL.val((String)PATH_SEPARATOR), Tables.ITERATION.NAME, DSL.coalesce((Field)DSL.concat((String)PATH_SEPARATOR, (Field)testSuites.field("TEST_SUITES", String.class)), (Object)"")})).otherwise((Object)"")}).as("EXECUTION_PATH")).from((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).leftJoin((TableLike)Tables.ITERATION_TEST_PLAN_ITEM).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID)).leftJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID)).leftJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).leftJoin((TableLike)Tables.ITERATION).on(Tables.ITEM_TEST_PLAN_LIST.ITERATION_ID.eq((Field)Tables.ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.CAMPAIGN_ITERATION).on(Tables.ITERATION.ITERATION_ID.eq((Field)Tables.CAMPAIGN_ITERATION.ITERATION_ID)).leftJoin((TableLike)Tables.TEST_PLAN_ITEM).on(Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID.eq((Field)Tables.EXPLORATORY_SESSION_OVERVIEW.TEST_PLAN_ITEM_ID)).leftJoin((TableLike)Tables.SPRINT_REQ_VERSION).on(Tables.SPRINT_REQ_VERSION.TEST_PLAN_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ID)).leftJoin((TableLike)Tables.SPRINT).on(Tables.SPRINT.CLN_ID.eq((Field)Tables.SPRINT_REQ_VERSION.SPRINT_ID)).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.CAMPAIGN_ITERATION.CAMPAIGN_ID).or(Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID.eq((Field)Tables.SPRINT.CLN_ID))).leftJoin((TableLike)Tables.EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID).or(Tables.EXECUTION.TEST_PLAN_ITEM_ID.eq((Field)Tables.TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID))).leftJoin((TableLike)Tables.EXECUTION_ISSUES_CLOSURE).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.EXECUTION_ISSUES_CLOSURE.EXECUTION_ID)).leftJoin((TableLike)Tables.ISSUE).on(Tables.EXECUTION_ISSUES_CLOSURE.ISSUE_ID.eq((Field)Tables.ISSUE.ISSUE_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).leftJoin(testSuites).on(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq(testSuites.field("OVERVIEW_ID", Long.class))).leftJoin(clnPathTable).on(clnPathTable.field("CLN_ID", Long.class).eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).groupBy(new GroupField[]{Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID, Tables.ITERATION_TEST_PLAN_ITEM.ITEM_TEST_PLAN_ID, Tables.ITERATION.ITERATION_ID, Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID, Tables.PROJECT.PROJECT_ID, Tables.TEST_PLAN_ITEM.TCLN_ID, Tables.TEST_PLAN_ITEM.LAST_EXECUTED_ON, Tables.TEST_PLAN_ITEM.EXECUTION_STATUS, Tables.SPRINT.CLN_ID, testSuites.field("TEST_SUITES"), clnPathTable.field(CLN_FULL_PATH, String.class)}).asTable();
    }

    @Override
    protected Field<?> getIdentifier() {
        return DSL.field((SelectField)DSL.field((String)"OVERVIEW_ID"));
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return DSL.field((String)"PROJECT_ID");
    }

    @Override
    protected Condition craftInvariantFilter() {
        return DSL.field((String)"TCLN_ID").eq((Object)this.testCaseId);
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.field((String)"LAST_EXECUTED_ON").desc();
    }

    private Table<?> getClnPathTable() {
        short zero = 0;
        ClnRelationshipClosure descendant = Tables.CLN_RELATIONSHIP_CLOSURE.as("descendant");
        Table path = DSL.select((SelectField)Tables.PROJECT.PROJECT_ID.as("PROJECT_ID"), (SelectField)Tables.PROJECT.NAME, (SelectField)Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.as("CLN_ID"), (SelectField)DSL.groupConcat((Field)Tables.CAMPAIGN_LIBRARY_NODE.NAME).orderBy(new OrderField[]{Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.desc()}).separator(PATH_SEPARATOR).as(CLN_PATH)).from((TableLike)Tables.CLN_RELATIONSHIP_CLOSURE).innerJoin((TableLike)Tables.CAMPAIGN_LIBRARY_NODE).on(Tables.CLN_RELATIONSHIP_CLOSURE.ANCESTOR_ID.eq((Field)Tables.CAMPAIGN_LIBRARY_NODE.CLN_ID)).innerJoin((TableLike)Tables.PROJECT).on(Tables.CAMPAIGN_LIBRARY_NODE.PROJECT_ID.eq((Field)Tables.PROJECT.PROJECT_ID)).innerJoin((TableLike)descendant).on(Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID.eq((Field)descendant.ANCESTOR_ID)).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(descendant.DESCENDANT_ID.eq((Field)Tables.CAMPAIGN_FOLDER.CLN_ID).and(Tables.CLN_RELATIONSHIP_CLOSURE.DEPTH.ne((Object)zero))).where(Tables.CAMPAIGN_FOLDER.CLN_ID.isNull()).groupBy(new GroupField[]{Tables.PROJECT.PROJECT_ID, Tables.CLN_RELATIONSHIP_CLOSURE.DESCENDANT_ID}).asTable("CLN_PATH_TABLE", new String[]{"PROJECT_ID", "PROJECT_NAME", "CLN_ID", CLN_PATH});
        return DSL.select((SelectField)path.field("CLN_ID"), (SelectField)path.field("PROJECT_ID"), (SelectField)DSL.concat((Field[])new Field[]{path.field("PROJECT_NAME"), DSL.value((String)PATH_SEPARATOR), path.field(CLN_PATH), DSL.when((Condition)Tables.CAMPAIGN_FOLDER.CLN_ID.isNotNull(), (Field)DSL.value((String)PATH_SEPARATOR)).otherwise((Object)"")}).as(CLN_FULL_PATH)).from((TableLike)path).leftJoin((TableLike)Tables.CAMPAIGN_FOLDER).on(path.field("CLN_ID", Long.class).eq((Field)Tables.CAMPAIGN_FOLDER.CLN_ID)).asTable();
    }
}

