/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.campaign;

import java.util.Arrays;
import java.util.List;
import org.jooq.AggregateFunction;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.domain.environmenttag.DenormalizedEnvironmentHolderType;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.jooq.domain.tables.AutomatedSuite;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class AutomatedSuiteExecutionGrid
extends AbstractGrid {
    private static final String ALIAS_EXTENDER_ID = "ALIAS_EXTENDER_ID";
    private static final String EXTENDER_ID = "EXTENDER_ID";
    private static final String AUTOMATED_EXECUTION_EXTENDER_TYPE = DenormalizedEnvironmentHolderType.AUTOMATED_EXECUTION_EXTENDER.name();
    private static final String ENVIRONMENT_VARIABLE = "ENVIRONMENT_VARIABLE";
    private static final String ENVIRONMENT_TAG = "ENVIRONMENT_TAG";
    private static final String TEST_TECHNOLOGY = "TEST_TECHNOLOGY";
    private final String automatedSuiteId;

    public AutomatedSuiteExecutionGrid(String automatedSuiteId) {
        this.automatedSuiteId = automatedSuiteId;
    }

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.EXECUTION.EXECUTION_STATUS), new GridColumn((Field<?>)Tables.EXECUTION.NAME), new GridColumn((Field<?>)Tables.EXECUTION.REFERENCE), new GridColumn((Field<?>)Tables.EXECUTION.DATASET_LABEL), new GridColumn((Field<?>)Tables.EXECUTION.LAST_EXECUTED_ON), new GridColumn((Field<?>)Tables.EXECUTION.EXECUTION_ID), new GridColumn((Field<?>)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID), new GridColumn(this.getDenormalizedEnvironmentVariables().field("ENVIRONMENT_VARIABLES")), new GridColumn(this.getDenormalizedEnvironmentTags().field("ENVIRONMENT_TAGS")), new GridColumn((Field<?>)Tables.AUTOMATED_EXECUTION_EXTENDER.DURATION), new GridColumn((Field<?>)Tables.AUTOMATED_EXECUTION_EXTENDER.FLAG));
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<?> environmentVariables = this.getDenormalizedEnvironmentVariables();
        SelectHavingStep<?> environmentTags = this.getDenormalizedEnvironmentTags();
        return AutomatedSuite.AUTOMATED_SUITE.innerJoin((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).on(AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Field)Tables.AUTOMATED_EXECUTION_EXTENDER.SUITE_ID)).innerJoin((TableLike)Tables.EXECUTION).on(Tables.AUTOMATED_EXECUTION_EXTENDER.MASTER_EXECUTION_ID.eq((Field)Tables.EXECUTION.EXECUTION_ID)).leftJoin(environmentVariables).on(Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.eq(environmentVariables.field(ALIAS_EXTENDER_ID, Long.class))).leftJoin(environmentTags).on(Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.eq(environmentTags.field(ALIAS_EXTENDER_ID, Long.class))).leftJoin((TableLike)Tables.ITEM_TEST_PLAN_EXECUTION).on(Tables.EXECUTION.EXECUTION_ID.eq((Field)Tables.ITEM_TEST_PLAN_EXECUTION.EXECUTION_ID)).leftJoin((TableLike)Tables.ITEM_TEST_PLAN_LIST).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ID)).leftJoin((TableLike)Tables.TEST_SUITE_TEST_PLAN_ITEM).on(Tables.ITEM_TEST_PLAN_EXECUTION.ITEM_TEST_PLAN_ID.eq((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TPI_ID));
    }

    private SelectHavingStep<?> getDenormalizedEnvironmentVariables() {
        Table result = DSL.select((SelectField)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.as(EXTENDER_ID), (SelectField)DSL.concat((Field[])new Field[]{Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.NAME, DSL.val((String)" : "), Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.VALUE}).as(ENVIRONMENT_VARIABLE)).from((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).innerJoin((TableLike)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE).on(Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.eq((Field)Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.HOLDER_ID)).where(Tables.DENORMALIZED_ENVIRONMENT_VARIABLE.HOLDER_TYPE.eq((Object)AUTOMATED_EXECUTION_EXTENDER_TYPE)).asTable();
        return DSL.select((SelectField)result.field(EXTENDER_ID).as(ALIAS_EXTENDER_ID), (SelectField)DSL.groupConcat((Field)result.field(ENVIRONMENT_VARIABLE)).separator(", ").as("ENVIRONMENT_VARIABLES")).from((TableLike)result).groupBy(new GroupField[]{result.field(EXTENDER_ID)});
    }

    private SelectHavingStep<?> getDenormalizedEnvironmentTags() {
        Table result = DSL.select((SelectField)Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.as(EXTENDER_ID), (SelectField)Tables.DENORMALIZED_ENVIRONMENT_TAG.VALUE.as(ENVIRONMENT_TAG), (SelectField)Tables.AUTOMATED_EXECUTION_EXTENDER.TEST_TECHNOLOGY.as(TEST_TECHNOLOGY)).from((TableLike)Tables.AUTOMATED_EXECUTION_EXTENDER).leftJoin((TableLike)Tables.DENORMALIZED_ENVIRONMENT_TAG).on(Tables.AUTOMATED_EXECUTION_EXTENDER.EXTENDER_ID.eq((Field)Tables.DENORMALIZED_ENVIRONMENT_TAG.HOLDER_ID).and(Tables.DENORMALIZED_ENVIRONMENT_TAG.HOLDER_TYPE.eq((Object)AUTOMATED_EXECUTION_EXTENDER_TYPE))).asTable();
        Field testTechnologyField = result.field(TEST_TECHNOLOGY).coerce(String.class);
        Condition containTags = DSL.count((Field)result.field(ENVIRONMENT_TAG)).greaterThan((Object)0);
        AggregateFunction concatTags = DSL.groupConcat((Field)result.field(ENVIRONMENT_TAG)).separator(", ");
        Field withDenormalizedTags = DSL.when((Condition)DSL.length((Field)testTechnologyField).greaterThan((Object)0), (Field)concatTags.concat(new Field[]{DSL.val((String)", "), testTechnologyField})).otherwise((Field)concatTags);
        return DSL.select((SelectField)result.field(EXTENDER_ID).as(ALIAS_EXTENDER_ID), (SelectField)DSL.when((Condition)containTags, (Field)withDenormalizedTags).otherwise(testTechnologyField).as("ENVIRONMENT_TAGS")).from((TableLike)result).where(DSL.length((Field)testTechnologyField).greaterThan((Object)0).or(result.field(ENVIRONMENT_TAG).isNotNull())).groupBy(new GroupField[]{result.field(EXTENDER_ID), result.field(TEST_TECHNOLOGY)});
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.EXECUTION.EXECUTION_ID;
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.when((Condition)AutomatedSuite.AUTOMATED_SUITE.ITERATION_ID.isNotNull(), (Field)Tables.ITEM_TEST_PLAN_LIST.ITEM_TEST_PLAN_ORDER).otherwise((Field)Tables.TEST_SUITE_TEST_PLAN_ITEM.TEST_PLAN_ORDER).asc();
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return null;
    }

    @Override
    protected Condition craftInvariantFilter() {
        return AutomatedSuite.AUTOMATED_SUITE.SUITE_ID.eq((Object)this.automatedSuiteId);
    }
}

