/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.grid.administration;

import java.util.Arrays;
import java.util.List;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record2;
import org.jooq.SelectField;
import org.jooq.SelectHavingStep;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.display.grid.AbstractGrid;
import org.squashtest.tm.service.internal.display.grid.columns.GridColumn;

public class UserGrid
extends AbstractGrid {
    private static final String TEAM_MEMBER_ID = "TEAM_MEMBER_ID";
    private static final String USER_ID = "USER_ID";

    @Override
    protected List<GridColumn> getColumns() {
        return Arrays.asList(new GridColumn((Field<?>)Tables.CORE_USER.PARTY_ID), new GridColumn((Field<?>)Tables.CORE_USER.ACTIVE), new GridColumn((Field<?>)Tables.CORE_USER.LOGIN), new GridColumn(Tables.CORE_GROUP.QUALIFIED_NAME.as("USER_GROUP")), new GridColumn((Field<?>)Tables.CORE_USER.FIRST_NAME), new GridColumn((Field<?>)Tables.CORE_USER.LAST_NAME), new GridColumn((Field<?>)Tables.CORE_USER.EMAIL), new GridColumn((Field<?>)Tables.CORE_USER.CREATED_ON), new GridColumn((Field<?>)Tables.CORE_USER.CREATED_BY), new GridColumn(DSL.isnull((Field)DSL.field((String)"HABILITATION_COUNT", Integer.class), (Object)0).as("HABILITATION_COUNT")), new GridColumn(DSL.isnull((Field)DSL.field((String)"TEAM_COUNT", Integer.class), (Object)0).as("TEAM_COUNT")), new GridColumn((Field<?>)Tables.CORE_USER.LAST_CONNECTED_ON));
    }

    @Override
    protected Table<?> getTable() {
        SelectHavingStep<Record2<Long, Integer>> teamCount = this.getTeamCount();
        SelectHavingStep<Record2<Long, Integer>> habilitationCount = this.getHabilitationCount();
        return Tables.CORE_USER.leftJoin((TableLike)Tables.CORE_GROUP_MEMBER).on(Tables.CORE_GROUP_MEMBER.PARTY_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).leftJoin((TableLike)Tables.CORE_GROUP).on(Tables.CORE_GROUP_MEMBER.GROUP_ID.eq((Field)Tables.CORE_GROUP.ID)).leftJoin(teamCount).on(teamCount.field(TEAM_MEMBER_ID, Long.class).eq((Field)Tables.CORE_USER.PARTY_ID)).leftJoin(habilitationCount).on(habilitationCount.field(USER_ID, Long.class).eq((Field)Tables.CORE_USER.PARTY_ID));
    }

    private SelectHavingStep<Record2<Long, Integer>> getTeamCount() {
        return DSL.select((SelectField)Tables.CORE_USER.PARTY_ID.as(TEAM_MEMBER_ID), (SelectField)DSL.count((Field)Tables.CORE_TEAM_MEMBER.TEAM_ID).as("TEAM_COUNT")).from((TableLike)Tables.CORE_USER).leftJoin((TableLike)Tables.CORE_TEAM_MEMBER).on(Tables.CORE_TEAM_MEMBER.USER_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).groupBy(new GroupField[]{Tables.CORE_USER.PARTY_ID});
    }

    private SelectHavingStep<Record2<Long, Integer>> getHabilitationCount() {
        return DSL.select((SelectField)Tables.CORE_USER.PARTY_ID.as(USER_ID), (SelectField)DSL.count((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.ID).as("HABILITATION_COUNT")).from((TableLike)Tables.CORE_USER).leftJoin((TableLike)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY).on(Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.PARTY_ID.eq((Field)Tables.CORE_USER.PARTY_ID)).leftJoin((TableLike)Tables.ACL_OBJECT_IDENTITY).on(Tables.ACL_OBJECT_IDENTITY.ID.eq((Field)Tables.ACL_RESPONSIBILITY_SCOPE_ENTRY.OBJECT_IDENTITY_ID)).where(Tables.ACL_OBJECT_IDENTITY.CLASS_ID.eq((Object)1L)).groupBy(new GroupField[]{Tables.CORE_USER.PARTY_ID});
    }

    @Override
    protected Field<?> getIdentifier() {
        return Tables.CORE_USER.PARTY_ID;
    }

    @Override
    protected Field<?> getProjectIdentifier() {
        return null;
    }

    @Override
    protected SortField<?> getDefaultOrder() {
        return DSL.upper((Field)Tables.CORE_USER.LOGIN).asc();
    }
}

