/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.display.execution;

import java.util.List;
import javax.persistence.EntityManager;
import org.jooq.DSLContext;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.ExploratorySessionOverview;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.UnknownEntityException;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.campaign.SprintTestPlanItemManagerService;
import org.squashtest.tm.service.display.execution.ExploratorySessionOverviewDisplayService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.ExploratorySessionOverviewKnownIssueFinder;
import org.squashtest.tm.service.internal.display.dto.UserView;
import org.squashtest.tm.service.internal.display.dto.execution.ExploratorySessionOverviewView;
import org.squashtest.tm.service.internal.display.dto.execution.SessionNoteDto;
import org.squashtest.tm.service.internal.display.grid.DataRow;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.internal.display.grid.campaign.ExploratorySessionExecutionGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.SprintTestPlanExploratorySessionExecutionGrid;
import org.squashtest.tm.service.internal.display.grid.campaign.TestPlanGridHelpers;
import org.squashtest.tm.service.internal.library.EntityPathHeaderService;
import org.squashtest.tm.service.internal.repository.display.AttachmentDisplayDao;
import org.squashtest.tm.service.internal.repository.display.ExploratorySessionOverviewDisplayDao;
import org.squashtest.tm.service.internal.repository.display.MilestoneDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SessionNoteDisplayDao;
import org.squashtest.tm.service.internal.repository.display.SprintDisplayDao;
import org.squashtest.tm.service.internal.repository.display.TestPlanExploratorySessionOverviewDisplayDao;

@Service
@Transactional(readOnly=true)
public class ExploratorySessionOverviewDisplayServiceImpl
implements ExploratorySessionOverviewDisplayService {
    private final ExploratorySessionOverviewDisplayDao exploratorySessionOverviewDisplayDao;
    private final TestPlanExploratorySessionOverviewDisplayDao testPlanExploratorySessionOverviewDisplayDao;
    private final ExploratorySessionOverviewKnownIssueFinder exploratorySessionOverviewKnownIssueFinder;
    private final EntityPathHeaderService entityPathHeaderService;
    private final EntityManager entityManager;
    private final IterationTestPlanManagerService iterationTestPlanManagerService;
    private final AttachmentDisplayDao attachmentDisplayDao;
    private final SessionNoteDisplayDao sessionNoteDisplayDao;
    private final MilestoneDisplayDao milestoneDisplayDao;
    private final DSLContext dslContext;
    private final MessageSource messageSource;
    private final SprintTestPlanItemManagerService sprintTestPlanItemManagerService;
    private final SprintDisplayDao sprintDisplayDao;

    public ExploratorySessionOverviewDisplayServiceImpl(ExploratorySessionOverviewDisplayDao exploratorySessionOverviewDisplayDao, TestPlanExploratorySessionOverviewDisplayDao testPlanExploratorySessionOverviewDisplayDao, ExploratorySessionOverviewKnownIssueFinder exploratorySessionOverviewKnownIssueFinder, EntityPathHeaderService entityPathHeaderService, EntityManager entityManager, IterationTestPlanManagerService iterationTestPlanManagerService, AttachmentDisplayDao attachmentDisplayDao, SessionNoteDisplayDao sessionNoteDisplayDao, MilestoneDisplayDao milestoneDisplayDao, DSLContext dslContext, MessageSource messageSource, SprintTestPlanItemManagerService sprintTestPlanItemManagerService, SprintDisplayDao sprintDisplayDao) {
        this.exploratorySessionOverviewDisplayDao = exploratorySessionOverviewDisplayDao;
        this.testPlanExploratorySessionOverviewDisplayDao = testPlanExploratorySessionOverviewDisplayDao;
        this.exploratorySessionOverviewKnownIssueFinder = exploratorySessionOverviewKnownIssueFinder;
        this.entityPathHeaderService = entityPathHeaderService;
        this.entityManager = entityManager;
        this.iterationTestPlanManagerService = iterationTestPlanManagerService;
        this.attachmentDisplayDao = attachmentDisplayDao;
        this.sessionNoteDisplayDao = sessionNoteDisplayDao;
        this.milestoneDisplayDao = milestoneDisplayDao;
        this.dslContext = dslContext;
        this.messageSource = messageSource;
        this.sprintTestPlanItemManagerService = sprintTestPlanItemManagerService;
        this.sprintDisplayDao = sprintDisplayDao;
    }

    @Override
    public ExploratorySessionOverviewView findById(long overviewId) {
        Long iterationId = this.exploratorySessionOverviewDisplayDao.findIterationIdByOverviewId(overviewId);
        if (iterationId != null) {
            return this.findByIdWithIteration(overviewId);
        }
        return this.findByIdWithTestPlan(overviewId);
    }

    private ExploratorySessionOverviewView findByIdWithIteration(long overviewId) {
        ExploratorySessionOverviewView view = this.exploratorySessionOverviewDisplayDao.findById(overviewId);
        view.setPath(this.entityPathHeaderService.buildExploratorySessionOverviewPathHeader(overviewId));
        List<UserView> assignableUsers = UserView.fromEntities(this.iterationTestPlanManagerService.findAssignableUsersForTestPlan(view.getIterationId()));
        view.setAssignableUsers(assignableUsers);
        view.setInferredSessionReviewStatus(this.exploratorySessionOverviewDisplayDao.inferReviewStatus(overviewId));
        view.setNbIssues(this.exploratorySessionOverviewKnownIssueFinder.countKnownIssues(overviewId));
        view.setNbExecutions(this.getNbExecutions(overviewId));
        view.setNbNotes(this.getAllSessionNotes(overviewId).size());
        view.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(view.getAttachmentListId()));
        view.setMilestones(this.milestoneDisplayDao.getMilestonesBySessionOverviewId(view.getId()));
        return view;
    }

    private ExploratorySessionOverviewView findByIdWithTestPlan(long overviewId) {
        ExploratorySessionOverviewView view = this.testPlanExploratorySessionOverviewDisplayDao.findById(overviewId);
        view.setPath(this.entityPathHeaderService.buildExploratorySessionOverviewPathHeader(overviewId));
        List<UserView> assignableUsers = UserView.fromEntities(this.sprintTestPlanItemManagerService.findAssignableUsersByTestPlanItemId(view.getTestPlanItemId()));
        view.setAssignableUsers(assignableUsers);
        view.setInferredSessionReviewStatus(this.testPlanExploratorySessionOverviewDisplayDao.inferReviewStatus(overviewId));
        view.setNbIssues(this.exploratorySessionOverviewKnownIssueFinder.countKnownIssues(overviewId));
        view.setNbExecutions(this.getNbExecutions(overviewId));
        view.setAttachmentList(this.attachmentDisplayDao.findAttachmentListById(view.getAttachmentListId()));
        view.setSprintStatus(this.sprintDisplayDao.getSprintStatusBySessionOverviewId(overviewId));
        return view;
    }

    private Integer getNbExecutions(long overviewId) {
        Integer executionCount = this.exploratorySessionOverviewDisplayDao.countExecutions(overviewId);
        return executionCount == null ? 0 : executionCount;
    }

    @Override
    public GridResponse getExecutionGrid(Long overviewId, GridRequest gridRequest) {
        GridResponse gridResponse;
        Long iterationTestPlanItemId = (Long)this.dslContext.select((SelectField)Tables.EXPLORATORY_SESSION_OVERVIEW.ITEM_TEST_PLAN_ID).from((TableLike)Tables.EXPLORATORY_SESSION_OVERVIEW).where(Tables.EXPLORATORY_SESSION_OVERVIEW.OVERVIEW_ID.eq((Object)overviewId)).fetchOneInto(Long.class);
        if (iterationTestPlanItemId != null) {
            grid = new ExploratorySessionExecutionGrid(overviewId);
            gridResponse = grid.getRows(gridRequest, this.dslContext);
        } else {
            grid = new SprintTestPlanExploratorySessionExecutionGrid(overviewId);
            gridResponse = grid.getRows(gridRequest, this.dslContext);
        }
        for (DataRow row : gridResponse.getDataRows()) {
            TestPlanGridHelpers.formatDeactivatedUserNameInRowData(row, this.messageSource);
        }
        return gridResponse;
    }

    @Override
    public Project findProjectBySessionOverviewId(Long overviewId) {
        Long projectId = this.exploratorySessionOverviewDisplayDao.findProjectIdBySessionOverviewId(overviewId);
        if (projectId == null) {
            throw new UnknownEntityException(overviewId.longValue(), ExploratorySessionOverview.class);
        }
        return (Project)this.entityManager.find(Project.class, (Object)projectId);
    }

    @Override
    public List<SessionNoteDto> getAllSessionNotes(Long overviewId) {
        return this.sessionNoteDisplayDao.fetchSessionNotesByOverviewId(overviewId);
    }

    @Override
    public List<UserView> getUnassignedUsers(Long overviewId) {
        List<Long> alreadyAssigned = this.exploratorySessionOverviewDisplayDao.findAlreadyAssignedUserIds(overviewId);
        Long iterationId = this.exploratorySessionOverviewDisplayDao.findIterationIdByOverviewId(overviewId);
        List<User> assignableUsers = iterationId != null ? this.iterationTestPlanManagerService.findAssignableUsersForTestPlan(iterationId) : this.sprintTestPlanItemManagerService.findAssignableUsersByExploratorySessionOverviewId(overviewId);
        return UserView.fromEntities(assignableUsers).stream().filter(user -> !alreadyAssigned.contains(user.getId())).toList();
    }
}

