/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion.jdbc;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import javax.persistence.EntityManager;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.Record3;
import org.jooq.SelectConditionStep;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.service.internal.attachment.AttachmentRepository;
import org.squashtest.tm.service.internal.attachment.AttachmentRepositoryVisitor;
import org.squashtest.tm.service.internal.attachment.DatabaseAttachmentRepository;
import org.squashtest.tm.service.internal.attachment.FileSystemAttachmentRepository;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcBatchReorderHelper;
import org.squashtest.tm.service.internal.deletion.jdbc.JdbcWorkingTables;
import org.squashtest.tm.service.internal.deletion.jdbc.delegate.AbstractDelegateDeleteQuery;

public abstract class AbstractJdbcDeletionHandler {
    protected final DSLContext dslContext;
    protected final AttachmentRepository attachmentRepository;
    protected final JdbcBatchReorderHelper reorderHelper;
    protected final JdbcWorkingTables workingTables;
    protected final String operationId;
    protected final Param<String> operationIdParam;
    protected final LocalDateTime startDate = LocalDateTime.now();
    protected final EntityManager entityManager;
    protected LocalDateTime lastStageEnd = LocalDateTime.now();

    protected AbstractJdbcDeletionHandler(DSLContext dslContext, AttachmentRepository attachmentRepository, JdbcBatchReorderHelper reorderHelper, String operationId, EntityManager entityManager) {
        this.dslContext = dslContext;
        this.attachmentRepository = attachmentRepository;
        this.reorderHelper = reorderHelper;
        this.operationId = operationId;
        this.operationIdParam = DSL.val((String)operationId);
        this.workingTables = new JdbcWorkingTables(dslContext, operationId);
        this.entityManager = entityManager;
    }

    protected SelectSelectStep<Record3<Long, String, String>> makeSelectClause(TableField<?, Long> tableField) {
        Param<String> fieldName = AbstractDelegateDeleteQuery.extractFieldTableNameAsParam(tableField);
        return this.makeSelectClause(tableField, fieldName);
    }

    protected SelectSelectStep<Record3<Long, String, String>> makeSelectClause(TableField<?, Long> tableField, Param<String> fieldName) {
        return DSL.select(tableField, fieldName, this.operationIdParam);
    }

    protected SelectConditionStep<Record3<Long, String, String>> makeSelectCustomFieldValues(TableField<?, Long> tableField, BindableEntity bindableEntity) {
        return this.makeSelectClause(Tables.CUSTOM_FIELD_VALUE.CFV_ID).from((TableLike)Tables.CUSTOM_FIELD_VALUE).where(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_ID.in(this.workingTables.makeSelectIds(tableField))).and(Tables.CUSTOM_FIELD_VALUE.BOUND_ENTITY_TYPE.eq((Object)bindableEntity.name()));
    }

    protected SelectConditionStep<Record3<Long, String, String>> makeSelectAttachmentList(TableField<?, Long> idField, TableField<?, Long> attachmentListIdField) {
        return this.makeSelectClause(attachmentListIdField, (Param<String>)DSL.val((String)Tables.ATTACHMENT_LIST.getName())).from((TableLike)idField.getTable()).where(idField.in(this.workingTables.makeSelectIds(idField)));
    }

    protected SelectConditionStep<Record3<Long, String, String>> makeSelectOrphanContent() {
        return this.makeSelectClause(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, (Param<String>)DSL.val((String)Tables.ATTACHMENT_CONTENT.getName())).from((TableLike)Tables.ATTACHMENT_CONTENT).leftJoin((TableLike)Tables.ATTACHMENT).on(Tables.ATTACHMENT.CONTENT_ID.eq((Field)Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID)).where(Tables.ATTACHMENT.CONTENT_ID.isNull());
    }

    protected void updateTime() {
        this.lastStageEnd = LocalDateTime.now();
    }

    protected long timeDiff() {
        return this.lastStageEnd.until(LocalDateTime.now(), ChronoUnit.MILLIS);
    }

    protected void logDelete(Table<?> denormalizedFieldValue) {
        this.getLogger().debug(String.format("Deleted root table %s and sub tables. Time on this stage : %d ms", denormalizedFieldValue.getName(), this.timeDiff()), new Object[0]);
        this.updateTime();
    }

    protected void deleteCustomFieldValues() {
        this.workingTables.delete(Tables.CUSTOM_FIELD_VALUE.CFV_ID, Tables.CUSTOM_FIELD_VALUE_OPTION.CFV_ID);
        this.workingTables.delete(Tables.CUSTOM_FIELD_VALUE.CFV_ID, Tables.CUSTOM_FIELD_VALUE.CFV_ID);
        this.logDelete((Table<?>)Tables.CUSTOM_FIELD_VALUE);
    }

    protected void deleteAttachmentLists() {
        this.workingTables.delete(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID, Tables.ATTACHMENT.ATTACHMENT_LIST_ID);
        this.workingTables.delete(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID, Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID);
        this.logDelete((Table<?>)Tables.ATTACHMENT_LIST);
    }

    protected void deleteAttachmentContents() {
        AttachmentRepositoryVisitor visitor = new AttachmentRepositoryVisitor(){

            @Override
            public void visit(FileSystemAttachmentRepository fileSystemAttachmentRepository) {
                List<Long> attachmentLidIds = AbstractJdbcDeletionHandler.this.workingTables.selectIds(Tables.ATTACHMENT_LIST.ATTACHMENT_LIST_ID);
                fileSystemAttachmentRepository.deleteContent(attachmentLidIds);
            }

            @Override
            public void visit(DatabaseAttachmentRepository databaseAttachmentRepository) {
                AbstractJdbcDeletionHandler.this.workingTables.addEntity(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, () -> AbstractJdbcDeletionHandler.this.makeSelectOrphanContent());
                AbstractJdbcDeletionHandler.this.workingTables.delete(Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID, Tables.ATTACHMENT_CONTENT.ATTACHMENT_CONTENT_ID);
            }
        };
        this.attachmentRepository.accept(visitor);
        this.logDelete((Table<?>)Tables.ATTACHMENT_CONTENT);
    }

    protected void logReferenceEntitiesComplete() {
        this.getLogger().debug("All references are known in WORK_DELETE_ENTITIES table. Time on this stage : " + this.timeDiff() + " ms", new Object[0]);
        this.updateTime();
    }

    protected void cleanWorkingTable() {
        this.workingTables.clean();
    }

    protected void clearPersistenceContext() {
        this.entityManager.flush();
        this.entityManager.clear();
    }

    protected abstract Logger getLogger();
}

