/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.deletion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.attachment.ExternalContentCoordinates;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.domain.library.WhichNodeVisitor;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.service.deletion.BoundToLockedMilestonesReport;
import org.squashtest.tm.service.deletion.BoundToMultipleMilestonesReport;
import org.squashtest.tm.service.deletion.MilestoneModeNoFolderDeletion;
import org.squashtest.tm.service.deletion.Node;
import org.squashtest.tm.service.deletion.NodeMovement;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SingleMilestonesReport;
import org.squashtest.tm.service.deletion.SingleOrMultipleMilestonesReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.deletion.AbstractNodeDeletionHandler;
import org.squashtest.tm.service.internal.deletion.LockedFolderInferenceTree;
import org.squashtest.tm.service.internal.deletion.SubRequirementRewiringTree;
import org.squashtest.tm.service.internal.deletion.TestCaseImportanceManagerForRequirementDeletion;
import org.squashtest.tm.service.internal.repository.FolderDao;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.RequirementDao;
import org.squashtest.tm.service.internal.repository.RequirementDeletionDao;
import org.squashtest.tm.service.internal.repository.RequirementFolderDao;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.internal.requirement.RequirementNodeDeletionHandler;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;

@Component(value="squashtest.tm.service.deletion.RequirementNodeDeletionHandler")
public class RequirementDeletionHandlerImpl
extends AbstractNodeDeletionHandler<RequirementLibraryNode, RequirementFolder>
implements RequirementNodeDeletionHandler {
    private static final String REQUIREMENTS_TYPE = "requirements";
    private static final String REQUIREMENT = "requirement";
    @Inject
    private RequirementFolderDao folderDao;
    @Inject
    private Provider<TestCaseImportanceManagerForRequirementDeletion> provider;
    @Inject
    private RequirementDao requirementDao;
    @Inject
    @Qualifier(value="squashtest.tm.repository.RequirementLibraryNodeDao")
    private LibraryNodeDao<RequirementLibraryNode> libraryNodeDao;
    @Inject
    private RequirementDeletionDao deletionDao;
    @Inject
    private PrivateCustomFieldValueService customValueService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    SprintReqVersionDao sprintReqVersionDao;

    @Override
    protected FolderDao<RequirementFolder, RequirementLibraryNode> getFolderDao() {
        return this.folderDao;
    }

    @Override
    protected List<SuppressionPreviewReport> diagnoseSuppression(List<Long> nodeIds) {
        LinkedList<SuppressionPreviewReport> preview = new LinkedList<SuppressionPreviewReport>();
        if (this.isMilestoneMode()) {
            List<Long>[] separatedIds = this.deletionDao.separateFolderFromRequirementIds(nodeIds);
            List<Long> targetVersionIds = this.deletionDao.findVersionIdsForMilestone(separatedIds[1], this.getActiveMilestoneId());
            this.reportNoFoldersAllowed(separatedIds[0], preview);
            this.reportVersionLocksByMilestone(targetVersionIds, preview);
            this.reportMultipleMilestoneBinding(targetVersionIds, preview);
        } else {
            this.reportLocksByMilestone(nodeIds, preview);
        }
        return preview;
    }

    protected void reportMultipleMilestoneBinding(List<Long> targetVersionIds, List<SuppressionPreviewReport> preview) {
        List<Long> boundNodes = this.deletionDao.filterVersionIdsHavingMultipleMilestones(targetVersionIds);
        if (!boundNodes.isEmpty()) {
            if (boundNodes.size() == targetVersionIds.size()) {
                preview.add(new BoundToMultipleMilestonesReport(REQUIREMENTS_TYPE));
            } else {
                preview.add(new SingleOrMultipleMilestonesReport(REQUIREMENTS_TYPE));
            }
        } else {
            preview.add(new SingleMilestonesReport(REQUIREMENTS_TYPE));
        }
    }

    protected void reportVersionLocksByMilestone(List<Long> versionIds, List<SuppressionPreviewReport> preview) {
        List<Long> lockedNodes = this.deletionDao.filterVersionIdsWhichMilestonesForbidsDeletion(versionIds);
        if (!lockedNodes.isEmpty()) {
            preview.add(new BoundToLockedMilestonesReport(REQUIREMENTS_TYPE));
        }
    }

    protected void reportNoFoldersAllowed(List<Long> folderIds, List<SuppressionPreviewReport> preview) {
        if (!folderIds.isEmpty()) {
            preview.add(new MilestoneModeNoFolderDeletion(REQUIREMENTS_TYPE));
        }
    }

    protected void reportLocksByMilestone(List<Long> nodeIds, List<SuppressionPreviewReport> preview) {
        List<Long> lockedNodes = this.deletionDao.filterRequirementsIdsWhichMilestonesForbidsDeletion(nodeIds);
        if (!lockedNodes.isEmpty()) {
            preview.add(new BoundToLockedMilestonesReport(REQUIREMENTS_TYPE));
        }
    }

    @Override
    protected List<Long> detectLockedNodes(List<Long> nodeIds) {
        ArrayList<Long> lockedIds = new ArrayList<Long>();
        if (this.isMilestoneMode()) {
            List<Long>[] separateIds = this.deletionDao.separateFolderFromRequirementIds(nodeIds);
            List<Long> folderIds = separateIds[0];
            lockedIds.addAll(folderIds);
            List<Long> requirementIds = separateIds[1];
            List<Long> deletableRequirements = this.deletionDao.filterRequirementsHavingDeletableVersions(requirementIds, this.getActiveMilestoneId());
            List<Long> reqHavingManyVersions = this.requirementDao.filterRequirementHavingManyVersions(deletableRequirements);
            deletableRequirements.removeAll(reqHavingManyVersions);
            requirementIds.removeAll(deletableRequirements);
            lockedIds.addAll(requirementIds);
        } else {
            List<Long> lockedRequirementIds = this.deletionDao.filterRequirementsIdsWhichMilestonesForbidsDeletion(nodeIds);
            lockedIds.addAll(lockedRequirementIds);
        }
        return lockedIds;
    }

    protected TargetsSortedByAppropriatePunishment sortThatMess(List<Long> nodeIds) {
        List<Long> requirementsWithOneDeletableVersion = null;
        List<Long> requirementsWithOneUnbindableVersion = null;
        List<Long>[] candidateIds = this.deletionDao.separateFolderFromRequirementIds(nodeIds);
        List<Long> candidateFolders = candidateIds[0];
        List<Long> candidateRequirementIds = candidateIds[1];
        LockedFolderInferenceTree folderTree = this.createLockedFileInferenceTree(candidateFolders);
        List treeNodeIds = folderTree.collectKeys();
        List<Long> deletableNodeIds = folderTree.collectDeletableIds();
        List<Long> deletableFolderIds = this.deletionDao.separateFolderFromRequirementIds(deletableNodeIds)[0];
        List<Long> rule1DeletableRequirementIds = this.deletionDao.separateFolderFromRequirementIds(treeNodeIds)[1];
        List<Long> lockedTreeRequirementIds = this.detectLockedNodes(rule1DeletableRequirementIds);
        rule1DeletableRequirementIds.removeAll(lockedTreeRequirementIds);
        ArrayList<Long> deletableRequirementIds = new ArrayList<Long>(rule1DeletableRequirementIds);
        ArrayList<Long> requirementWithRewirableChildren = new ArrayList<Long>(rule1DeletableRequirementIds);
        List<Long> lockedCandidateIds = this.detectLockedNodes(candidateRequirementIds);
        ArrayList<Long> rule2DeletableRequirementIds = new ArrayList<Long>(candidateRequirementIds);
        rule2DeletableRequirementIds.removeAll(lockedCandidateIds);
        deletableRequirementIds.addAll(rule2DeletableRequirementIds);
        requirementWithRewirableChildren.addAll(rule2DeletableRequirementIds);
        if (this.isMilestoneMode()) {
            List<Long> allRequirementsEncompassed = this.deletionDao.separateFolderFromRequirementIds(folderTree.collectKeys())[1];
            allRequirementsEncompassed.removeAll(deletableRequirementIds);
            allRequirementsEncompassed.addAll(lockedCandidateIds);
            requirementsWithOneDeletableVersion = this.deletionDao.filterRequirementsHavingDeletableVersions(allRequirementsEncompassed, this.getActiveMilestoneId());
            requirementsWithOneUnbindableVersion = this.deletionDao.filterRequirementsHavingUnbindableVersions(allRequirementsEncompassed, this.getActiveMilestoneId());
        }
        TargetsSortedByAppropriatePunishment sortedTargets = new TargetsSortedByAppropriatePunishment();
        sortedTargets.setDeletableFolderIds(deletableFolderIds);
        sortedTargets.setDeletableRequirementIds(deletableRequirementIds);
        sortedTargets.setRequirementsWithRewirableChildren(requirementWithRewirableChildren);
        sortedTargets.setRequirementsWithOneDeletableVersion(requirementsWithOneDeletableVersion);
        sortedTargets.setRequirementsWithOneUnbindableVersion(requirementsWithOneUnbindableVersion);
        return sortedTargets;
    }

    @Override
    public OperationReport deleteNodes(List<Long> targetIds) {
        OperationReport globalReport = new OperationReport();
        TargetsSortedByAppropriatePunishment sortedTargets = this.sortThatMess(targetIds);
        List<Long> childrenRewirableRequirements = sortedTargets.getRequirementsWithRewirableChildren();
        OperationReport rewiredRequirementsReport = this.rewireChildrenRequirements(childrenRewirableRequirements);
        globalReport.mergeWith(rewiredRequirementsReport);
        List<Long> deletableRequirements = sortedTargets.getDeletableRequirementIds();
        this.sprintReqVersionDao.removeReqVersionsFromSprintReqVersion(deletableRequirements);
        OperationReport deletedRequirementsReport = this.batchDeleteRequirement(deletableRequirements);
        globalReport.mergeWith(deletedRequirementsReport);
        List<Long> deletableFolderIds = sortedTargets.getDeletableFolderIds();
        OperationReport deletedFoldersReport = this.batchDeleteFolders(deletableFolderIds);
        globalReport.mergeWith(deletedFoldersReport);
        if (this.isMilestoneMode()) {
            List<Long> requirementWithDeletableVersion = sortedTargets.getRequirementsWithOneDeletableVersion();
            OperationReport removedVersionsReport = this.batchRemoveMilestoneVersion(requirementWithDeletableVersion, this.getActiveMilestoneId());
            globalReport.mergeWith(removedVersionsReport);
            List<Long> requirementWithUnbindableVersion = sortedTargets.getRequirementsWithOneUnbindableVersion();
            OperationReport unboundVerionsReport = this.batchUnbindFromMilestone(requirementWithUnbindableVersion);
            globalReport.mergeWith(unboundVerionsReport);
        }
        return globalReport;
    }

    protected OperationReport batchDeleteFolders(List<Long> folderIds) {
        OperationReport report = new OperationReport();
        if (!folderIds.isEmpty()) {
            List<Long> attachmentsLists = this.attachmentManager.getAttachmentsListsFromRequirementFolders(folderIds);
            List<ExternalContentCoordinates> pairContentIdListId = this.attachmentManager.getListIDbyContentIdForAttachmentLists(attachmentsLists);
            this.customValueService.deleteAllCustomFieldValues(BindableEntity.REQUIREMENT_FOLDER, folderIds);
            this.deletionDao.removeEntities(folderIds);
            report.addRemoved(folderIds, "folder");
            this.deletionDao.flush();
            this.attachmentManager.deleteContents(pairContentIdListId);
        }
        return report;
    }

    protected OperationReport batchDeleteRequirement(List<Long> ids) {
        OperationReport report = new OperationReport();
        if (!ids.isEmpty()) {
            TestCaseImportanceManagerForRequirementDeletion testCaseImportanceManager = (TestCaseImportanceManagerForRequirementDeletion)this.provider.get();
            testCaseImportanceManager.prepareRequirementDeletion(ids);
            this.deletionDao.unsetRequirementCurrentVersion(ids);
            List<Long> allVersionIds = this.deletionDao.findVersionIds(ids);
            this.batchDeleteVersions(allVersionIds);
            this.deletionDao.deleteRequirementAuditEvents(ids);
            this.deletionDao.deleteHighLevelRequirementReferenceIfExists(ids);
            this.deletionDao.removeEntities(ids);
            testCaseImportanceManager.changeImportanceAfterRequirementDeletion();
            report.addRemoved(ids, REQUIREMENT);
            this.deletionDao.flush();
        }
        return report;
    }

    protected OperationReport batchRemoveMilestoneVersion(List<Long> requirementIds, Long milestoneId) {
        OperationReport report = new OperationReport();
        if (!requirementIds.isEmpty()) {
            TestCaseImportanceManagerForRequirementDeletion testCaseImportanceManager = (TestCaseImportanceManagerForRequirementDeletion)this.provider.get();
            testCaseImportanceManager.prepareRequirementDeletion(requirementIds);
            this.deletionDao.unsetRequirementCurrentVersion(requirementIds);
            List<Long> versionIds = this.deletionDao.findDeletableVersions(requirementIds, milestoneId);
            this.batchDeleteVersions(versionIds);
            this.deletionDao.resetRequirementCurrentVersion(requirementIds);
            this.deletionDao.reorderRequirementVersions(requirementIds);
            testCaseImportanceManager.changeImportanceAfterRequirementDeletion();
            report.addRemoved(requirementIds, REQUIREMENT);
            this.deletionDao.flush();
        }
        return report;
    }

    @Override
    protected OperationReport batchUnbindFromMilestone(List<Long> requirementIds) {
        OperationReport report = new OperationReport();
        if (!requirementIds.isEmpty()) {
            List<Long> versionIds = this.deletionDao.findUnbindableVersions(requirementIds, this.getActiveMilestoneId());
            List<Long> unbindableRequirements = this.requirementDao.findByRequirementVersion(versionIds);
            this.deletionDao.unbindFromMilestone(unbindableRequirements, this.getActiveMilestoneId());
            report.addRemoved(requirementIds, REQUIREMENT);
            this.deletionDao.flush();
        }
        return report;
    }

    private OperationReport batchDeleteVersions(List<Long> versionIds) {
        OperationReport report = new OperationReport();
        if (!versionIds.isEmpty()) {
            this.customValueService.deleteAllCustomFieldValues(BindableEntity.REQUIREMENT_VERSION, versionIds);
            List<Long> attachmentListIds = this.deletionDao.findRequirementVersionAttachmentListIds(versionIds);
            List<ExternalContentCoordinates> listPairContenIDListID = this.attachmentManager.getListIDbyContentIdForAttachmentLists(attachmentListIds);
            this.deletionDao.deleteRequirementVersionAuditEvents(versionIds);
            this.deletionDao.removeTestStepsCoverageByRequirementVersionIds(versionIds);
            this.deletionDao.removeFromVerifiedVersionsLists(versionIds);
            this.deletionDao.removeFromLinkedVersionsLists(versionIds);
            this.deletionDao.deleteVersions(versionIds);
            this.attachmentManager.removeAttachmentsAndLists(attachmentListIds);
            this.deletionDao.flush();
            this.attachmentManager.deleteContents(listPairContenIDListID);
        }
        return report;
    }

    private OperationReport rewireChildrenRequirements(List<Long> requirements) {
        OperationReport report = new OperationReport();
        List<Long[]> treeData = this.findPairedNodeHierarchy(requirements);
        SubRequirementRewiringTree rewirer = new SubRequirementRewiringTree();
        rewirer.build(treeData);
        rewirer.markDeletableNodes(requirements);
        rewirer.resolveMovements();
        List<SubRequirementRewiringTree.Movement> movements = rewirer.getNodeMovements();
        List deletedRequirements = this.requirementDao.findAllByIds(requirements);
        for (Requirement r : deletedRequirements) {
            r.getContent().clear();
        }
        for (SubRequirementRewiringTree.Movement mouv : movements) {
            NodeContainer newParent;
            boolean isknown;
            Long newParentId = mouv.getId();
            boolean bl = isknown = !mouv.isTheParentOf();
            if (isknown) {
                newParent = (NodeContainer)this.libraryNodeDao.findById(newParentId);
            } else {
                List<Object[]> allParents = this.requirementDao.findAllParentsOf(Arrays.asList(newParentId));
                newParent = (NodeContainer)allParents.get(0)[0];
            }
            List<Requirement> rewiredRequirements = this.requirementDao.findAllByIds(mouv.getNewChildren());
            this.attachChildNodesToNewParent((NodeContainer<Requirement>)newParent, rewiredRequirements, report);
        }
        return report;
    }

    private void attachChildNodesToNewParent(NodeContainer<Requirement> newParent, Collection<Requirement> rewired, OperationReport report) {
        if (rewired.isEmpty()) {
            return;
        }
        ArrayList<Requirement> children = new ArrayList<Requirement>(rewired);
        ArrayList<Node> movedNodesLog = new ArrayList<Node>(rewired.size());
        for (Requirement child : children) {
            movedNodesLog.add(new Node(child.getId(), REQUIREMENT));
        }
        for (Requirement child : children) {
            newParent.addContent((TreeNode)child);
        }
        EntityType type = new WhichNodeVisitor().getTypeOf(newParent);
        String strtype = switch (type) {
            case EntityType.REQUIREMENT_LIBRARY -> "drive";
            case EntityType.REQUIREMENT_FOLDER -> "folder";
            default -> REQUIREMENT;
        };
        NodeMovement nodeMovement = new NodeMovement(new Node(newParent.getId(), strtype), movedNodesLog);
        report.addMoved(nodeMovement);
    }

    @Override
    protected OperationReport batchDeleteNodes(List<Long> ids) {
        return null;
    }

    @Override
    protected boolean isMilestoneMode() {
        return this.activeMilestoneHolder.getActiveMilestone().isPresent();
    }

    private Long getActiveMilestoneId() {
        return this.activeMilestoneHolder.getActiveMilestone().get().getId();
    }

    private static final class TargetsSortedByAppropriatePunishment {
        List<Long> deletableFolderIds;
        List<Long> deletableRequirementIds;
        List<Long> requirementsWithRewirableChildren;
        List<Long> requirementsWithOneDeletableVersion;
        List<Long> requirementsWithOneUnbindableVersion;

        private TargetsSortedByAppropriatePunishment() {
        }

        List<Long> getDeletableRequirementIds() {
            return this.deletableRequirementIds != null ? this.deletableRequirementIds : new ArrayList<Long>();
        }

        List<Long> getRequirementsWithOneDeletableVersion() {
            return this.requirementsWithOneDeletableVersion != null ? this.requirementsWithOneDeletableVersion : new ArrayList<Long>();
        }

        List<Long> getDeletableFolderIds() {
            return this.deletableFolderIds != null ? this.deletableFolderIds : new ArrayList<Long>();
        }

        List<Long> getRequirementsWithOneUnbindableVersion() {
            return this.requirementsWithOneUnbindableVersion != null ? this.requirementsWithOneUnbindableVersion : new ArrayList<Long>();
        }

        List<Long> getRequirementsWithRewirableChildren() {
            return this.requirementsWithRewirableChildren != null ? this.requirementsWithRewirableChildren : new ArrayList<Long>();
        }

        void setDeletableRequirementIds(List<Long> deletableRequirementIds) {
            this.deletableRequirementIds = deletableRequirementIds;
        }

        public void setDeletableFolderIds(List<Long> deletableFolderIds) {
            this.deletableFolderIds = deletableFolderIds;
        }

        void setRequirementsWithOneDeletableVersion(List<Long> requirementsWithOneDeletableVersion) {
            this.requirementsWithOneDeletableVersion = requirementsWithOneDeletableVersion;
        }

        void setRequirementsWithOneUnbindableVersion(List<Long> requirementsWithOneUnbindableVersion) {
            this.requirementsWithOneUnbindableVersion = requirementsWithOneUnbindableVersion;
        }

        void setRequirementsWithRewirableChildren(List<Long> requirementsWithRewirableChildren) {
            this.requirementsWithRewirableChildren = requirementsWithRewirableChildren;
        }
    }
}

