/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.customreport;

import java.util.List;
import javax.inject.Inject;
import org.springframework.stereotype.Component;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeLibraryNode;
import org.squashtest.tm.domain.tree.TreeLibraryNode;
import org.squashtest.tm.service.internal.customreport.NameResolver;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@Component
public class CRLNMover {
    @Inject
    private NameResolver nameResolver;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;

    public void moveNodes(List<CustomReportLibraryNode> nodes, CustomReportLibraryNode target) {
        this.moveFirstLayerNodes(nodes, target);
    }

    private void moveFirstLayerNodes(List<CustomReportLibraryNode> nodes, CustomReportLibraryNode target) {
        for (CustomReportLibraryNode node : nodes) {
            if (!this.targetIsNotOriginalParent(target, node) || !this.targetIsNotSelf(target, node)) continue;
            this.moveOneFirstLayerNode(target, node);
        }
    }

    private void moveOneFirstLayerNode(CustomReportLibraryNode target, CustomReportLibraryNode node) {
        if (this.userCanDeleteMovedNode(node)) {
            CustomReportTreeLibraryNode parent = node.getParent();
            this.nameResolver.resolveNewName(node, target);
            parent.removeChild((CustomReportTreeLibraryNode)node);
            this.changeNodeLibrary(node, target);
            target.addChild((CustomReportTreeLibraryNode)node);
            this.moveChild(node, target);
        }
    }

    private void moveChild(CustomReportLibraryNode node, CustomReportLibraryNode target) {
        this.changeNodeLibrary(node, target);
        for (TreeLibraryNode childNode : node.getChildren()) {
            this.moveChild((CustomReportLibraryNode)childNode, target);
        }
    }

    private void changeNodeLibrary(CustomReportLibraryNode node, CustomReportLibraryNode target) {
        node.setLibrary(target.getCustomReportLibrary());
        node.getEntity().setProject(target.getCustomReportLibrary().getProject());
    }

    private boolean userCanDeleteMovedNode(CustomReportLibraryNode node) {
        return this.permissionEvaluationService.hasRoleOrPermissionOnObject("ROLE_ADMIN", "DELETE", node);
    }

    private boolean targetIsNotOriginalParent(CustomReportLibraryNode target, CustomReportLibraryNode node) {
        return !node.getParent().equals(target);
    }

    private boolean targetIsNotSelf(CustomReportLibraryNode target, CustomReportLibraryNode node) {
        return !target.equals(node);
    }
}

