/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.copier;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.library.NodeContainer;
import org.squashtest.tm.domain.library.TreeNode;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.copier.CampaignWorkspaceCopierService;
import org.squashtest.tm.service.internal.copier.ChildEntityDto;
import org.squashtest.tm.service.internal.copier.NodeCopierVisitor;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;

@Service
@Transactional
public class CampaignWorkspaceCopierServiceImpl
implements CampaignWorkspaceCopierService {
    private final PrivateCustomFieldValueService customFieldValueManagerService;
    private final AttachmentManagerService attachmentManagerService;
    private final MessageSource messageSource;
    private final EntityManager entityManager;

    public CampaignWorkspaceCopierServiceImpl(PrivateCustomFieldValueService customFieldValueManagerService, AttachmentManagerService attachmentManagerService, MessageSource messageSource, EntityManager entityManager) {
        this.customFieldValueManagerService = customFieldValueManagerService;
        this.attachmentManagerService = attachmentManagerService;
        this.messageSource = messageSource;
        this.entityManager = entityManager;
    }

    @Override
    public <ENTITY extends TreeNode, NODE extends ENTITY> void copyNodeToContainer(NodeContainer<ENTITY> container, List<NODE> nodes, Map<String, Map<Long, Long>> pairingIdsSourceCopyNode) {
        String copySuffix = this.messageSource.getMessage("label.CopySuffix", null, LocaleContextHolder.getLocale());
        NodeCopierVisitor nodeCopierVisitor = new NodeCopierVisitor(this.entityManager, this.attachmentManagerService, container, copySuffix, pairingIdsSourceCopyNode);
        nodes.forEach(source -> {
            boolean projectChanged = !source.getProject().getId().equals(container.getProject().getId());
            nodeCopierVisitor.setProjectChanged(projectChanged);
            nodeCopierVisitor.performCopy((TreeNode)source);
        });
        this.customFieldValueManagerService.copyCustomFieldValues(nodeCopierVisitor.getBoundEntityCopies());
        this.customFieldValueManagerService.copyCustomFieldValuesOnProjectChanged(nodeCopierVisitor.getBoundEntityCopiesProjectChanged(), container.getProject().getId());
        this.attachmentManagerService.batchCopyContentsOnExternalRepository(nodeCopierVisitor.getAttachmentHolders());
        this.entityManager.flush();
        nodes.stream().filter(node -> container.getContent().contains(node)).forEach(arg_0 -> ((EntityManager)this.entityManager).detach(arg_0));
    }

    @Override
    public void copyNodeToMultipleContainers(List<ChildEntityDto> childEntityDtos, Map<String, Map<Long, Long>> pairingIdsSourceCopyNode) {
        if (childEntityDtos.isEmpty()) {
            return;
        }
        String copySuffix = this.messageSource.getMessage("label.CopySuffix", null, LocaleContextHolder.getLocale());
        NodeCopierVisitor nodeCopierVisitor = new NodeCopierVisitor(this.entityManager, this.attachmentManagerService, null, copySuffix, pairingIdsSourceCopyNode);
        childEntityDtos.forEach(childEntityDto -> {
            nodeCopierVisitor.setDestination(childEntityDto.getTargetContainer());
            childEntityDto.getChildren().forEach(source -> {
                boolean projectChanged = !source.getProject().getId().equals(childEntityDto.getTargetContainer().getProject().getId());
                nodeCopierVisitor.setProjectChanged(projectChanged);
                nodeCopierVisitor.performCopy((TreeNode)source);
            });
        });
        this.customFieldValueManagerService.copyCustomFieldValues(nodeCopierVisitor.getBoundEntityCopies());
        this.customFieldValueManagerService.copyCustomFieldValuesOnProjectChanged(nodeCopierVisitor.getBoundEntityCopiesProjectChanged(), childEntityDtos.get(0).getTargetContainer().getProject().getId());
        this.attachmentManagerService.batchCopyContentsOnExternalRepository(nodeCopierVisitor.getAttachmentHolders());
        this.entityManager.flush();
    }
}

