/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.configuration;

import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.squashtest.tm.event.ConfigUpdateEvent;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.testautomation.spi.BadConfiguration;

@Component
public class CallbackUrlProvider {
    @Inject
    private ConfigurationService configService;
    private String callbackUrlFromDatabase = null;

    @PostConstruct
    @EventListener(classes={ConfigUpdateEvent.class}, condition="#root.event.source=='squashtest.tm.callbackurl'")
    private void updateCallbackUrlFromDatabase() {
        this.callbackUrlFromDatabase = this.configService.findConfiguration("squashtest.tm.callbackurl");
    }

    public URL getCallbackUrl() {
        if (this.callbackUrlFromDatabase != null && !this.callbackUrlFromDatabase.isEmpty()) {
            try {
                return new URL(this.callbackUrlFromDatabase);
            }
            catch (MalformedURLException ex) {
                String message = "The url '" + this.callbackUrlFromDatabase + "' specified at property '" + "squashtest.tm.callbackurl" + "' in database is malformed. " + "Please contact the administration team.";
                throw new BadConfiguration(message, ex, "squashtest.tm.callbackurl");
            }
        }
        throw new BadConfiguration("The public Url of Squash is not set. Please contact the administration team. It is recommended to set SquashTM callback url property in administration settings page.");
    }
}

