/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.api.plugin.UsedInPlugin;
import org.squashtest.tm.domain.IdentifiersOrderComparator;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.exception.campaign.SprintNotLinkableException;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.annotation.PreventConcurrent;
import org.squashtest.tm.service.campaign.SprintReqVersionTestPlanManagerService;
import org.squashtest.tm.service.display.sprint.SprintDisplayService;
import org.squashtest.tm.service.internal.display.dto.sprint.AvailableTestPlanItemIdsDto;
import org.squashtest.tm.service.internal.repository.LibraryNodeDao;
import org.squashtest.tm.service.internal.repository.SprintReqVersionDao;
import org.squashtest.tm.service.internal.repository.TestCaseDao;
import org.squashtest.tm.service.internal.testcase.TestCaseNodeWalker;

@Service(value="squashtest.tm.service.SprintReqVersionTestPlanManagerService")
@Transactional
public class SprintReqVersionTestPlanManagerServiceImpl
implements SprintReqVersionTestPlanManagerService {
    private static final String SPRINT_REQ_VERSION_ID = "sprintReqVersionId";
    private final SprintReqVersionDao sprintReqVersionDao;
    private final SprintDisplayService sprintDisplayService;
    private final LibraryNodeDao<TestCaseLibraryNode> testCaseLibraryNodeDao;
    private final TestCaseDao testCaseDao;

    public SprintReqVersionTestPlanManagerServiceImpl(SprintReqVersionDao sprintReqVersionDao, SprintDisplayService sprintDisplayService, @Qualifier(value="squashtest.tm.repository.TestCaseLibraryNodeDao") LibraryNodeDao<TestCaseLibraryNode> testCaseLibraryNodeDao, TestCaseDao testCaseDao) {
        this.sprintReqVersionDao = sprintReqVersionDao;
        this.sprintDisplayService = sprintDisplayService;
        this.testCaseLibraryNodeDao = testCaseLibraryNodeDao;
        this.testCaseDao = testCaseDao;
    }

    @Override
    @PreventConcurrent(entityType=SprintReqVersion.class, paramName="sprintReqVersionId")
    @PreAuthorize(value="hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion' ,'LINK')  or hasRole('ROLE_ADMIN')")
    public void addTestCaseLibraryNodesToTestPlan(@Id Long sprintReqVersionId, List<Long> testCaseIds) {
        SprintReqVersion sprintReqVersion = this.sprintReqVersionDao.findByIdWithTestPlanAndSprint(sprintReqVersionId);
        if (SprintStatus.CLOSED.equals((Object)sprintReqVersion.getSprint().getStatus())) {
            throw new SprintNotLinkableException();
        }
        this.addTestCaseLibraryNodesToTestPlan(sprintReqVersion, testCaseIds);
    }

    private void addTestCaseLibraryNodesToTestPlan(SprintReqVersion sprintReqVersion, List<Long> tclnIds) {
        List<TestCaseLibraryNode> nodes = this.testCaseLibraryNodeDao.findAllByIds(tclnIds);
        nodes.sort((Comparator<TestCaseLibraryNode>)new IdentifiersOrderComparator(tclnIds));
        List<TestCase> testCases = new TestCaseNodeWalker().walk(nodes);
        sprintReqVersion.getTestPlan().createAndAddTestPlanItems(testCases);
        sprintReqVersion.updateLastModificationWithCurrentUser();
    }

    @Override
    public void addTestCasesWithDatasetsToTestPlan(Long sprintReqVersionId, Map<Long, List<Long>> datasetIdsByTestCaseId) {
        SprintReqVersion sprintReqVersion = this.sprintReqVersionDao.findByIdWithTestPlanAndSprint(sprintReqVersionId);
        if (SprintStatus.CLOSED.equals((Object)sprintReqVersion.getSprint().getStatus())) {
            throw new SprintNotLinkableException();
        }
        Map datasetsByTestCase = this.testCaseDao.findTestCaseAndDatasets(datasetIdsByTestCaseId);
        sprintReqVersion.getTestPlan().createAndAddTestPlanItems(datasetsByTestCase);
    }

    @Override
    @UsedInPlugin(value="Xsquash4Jira & Xsquash4GitLab")
    public void addAllTestPlanItemsToSprintReqVersion(Long sprintReqVersionId) {
        List<AvailableTestPlanItemIdsDto> availableTestPlanItemIds = this.sprintDisplayService.findAvailableTestPlanItemIds(sprintReqVersionId);
        HashMap<Long, List<Long>> datasetIdsByTestCaseId = new HashMap<Long, List<Long>>();
        for (AvailableTestPlanItemIdsDto availableTPI : availableTestPlanItemIds) {
            Long testCaseId = availableTPI.testCaseId();
            if (Objects.isNull(testCaseId)) continue;
            List datasetIds = datasetIdsByTestCaseId.computeIfAbsent(testCaseId, key -> new ArrayList());
            datasetIds.add(availableTPI.datasetId());
        }
        if (!datasetIdsByTestCaseId.isEmpty()) {
            this.addTestCasesWithDatasetsToTestPlan(sprintReqVersionId, datasetIdsByTestCaseId);
        }
    }
}

