/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import javax.persistence.EntityManager;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.domain.campaign.SprintReqVersionValidationStatus;
import org.squashtest.tm.domain.campaign.SprintStatus;
import org.squashtest.tm.exception.campaign.SprintClosedException;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.campaign.SprintManagerService;
import org.squashtest.tm.service.campaign.SprintReqVersionModificationService;

@Service
@Transactional
public class SprintReqVersionModificationServiceImpl
implements SprintReqVersionModificationService {
    private final SprintManagerService sprintManagerService;
    private final EntityManager entityManager;

    public SprintReqVersionModificationServiceImpl(SprintManagerService sprintManagerService, EntityManager entityManager) {
        this.sprintManagerService = sprintManagerService;
        this.entityManager = entityManager;
    }

    @Override
    @PreAuthorize(value="hasPermission(#sprintReqVersionId, 'org.squashtest.tm.domain.campaign.SprintReqVersion' ,'WRITE')  or hasRole('ROLE_ADMIN')")
    public void changeValidationStatus(@Id long sprintReqVersionId, SprintReqVersionValidationStatus newValidationStatus) {
        SprintStatus sprintStatus = this.sprintManagerService.getSprintStatusBySprintReqVersionId(sprintReqVersionId);
        if (SprintStatus.CLOSED.equals((Object)sprintStatus)) {
            throw new SprintClosedException();
        }
        ((SprintReqVersion)this.entityManager.find(SprintReqVersion.class, (Object)sprintReqVersionId)).setValidationStatus(newValidationStatus);
    }
}

