/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.campaign;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStatusReport;
import org.squashtest.tm.exception.DuplicateNameException;
import org.squashtest.tm.service.annotation.CheckBlockingMilestone;
import org.squashtest.tm.service.annotation.Id;
import org.squashtest.tm.service.campaign.CustomTestSuiteModificationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;

@Transactional
@Service(value="CustomTestSuiteModificationService")
public class CustomTestSuiteModificationServiceImpl
implements CustomTestSuiteModificationService {
    private static final String HAS_WRITE_PERMISSION_ID = "hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'WRITE') ";
    private static final String HAS_READ_PERMISSION_ID = "hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite','READ') ";
    private static final String PERMISSION_EXECUTE_ITEM = "hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.IterationTestPlanItem', 'EXECUTE') ";
    @Inject
    private TestSuiteDao testSuiteDao;
    @Inject
    private IterationModificationService iterationService;

    @Override
    @PreAuthorize(value="hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite', 'WRITE')  or hasRole('ROLE_ADMIN')")
    @CheckBlockingMilestone(entityType=TestSuite.class)
    public void rename(@Id long suiteId, String newName) throws DuplicateNameException {
        TestSuite suite = (TestSuite)this.testSuiteDao.getReferenceById(suiteId);
        suite.rename(newName);
    }

    @Override
    public void updateExecutionStatus(Collection<TestSuite> tests) {
        List<Long> testIds = tests.stream().map(TestSuite::getId).toList();
        Map reportsMap = this.testSuiteDao.getStatusReport(testIds);
        for (TestSuite test : tests) {
            ExecutionStatusReport report = (ExecutionStatusReport)reportsMap.get(test.getId());
            if (report == null) continue;
            ExecutionStatus newStatus = ExecutionStatus.computeNewStatus((ExecutionStatusReport)report);
            test.setExecutionStatus(newStatus);
        }
    }

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasPermission(#suiteId, 'org.squashtest.tm.domain.campaign.TestSuite','READ')  or hasRole('ROLE_ADMIN')")
    public TestSuite findById(long suiteId) {
        return (TestSuite)this.testSuiteDao.getReferenceById(suiteId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#testPlanItemId, 'org.squashtest.tm.domain.campaign.IterationTestPlanItem', 'EXECUTE')  or hasRole('ROLE_ADMIN')")
    public Execution addExecution(long testPlanItemId) {
        return this.iterationService.addExecution(testPlanItemId);
    }
}

