/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase.excel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.service.batchimport.excel.ColumnMismatch;
import org.squashtest.tm.service.batchimport.excel.WorksheetFormatStatus;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ColumnDef;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ColumnMismatchException;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ColumnProcessingMode;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CustomFieldColumnDef;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StdColumnDef;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateColumnUtils;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateWorksheet;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.UnknownColumnDef;

public class WorksheetDef<COL extends TemplateColumn> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorksheetDef.class);
    private final TemplateWorksheet worksheetType;
    private final Map<COL, StdColumnDef<COL>> stdColumnDefs = new HashMap<COL, StdColumnDef<COL>>();
    private final List<CustomFieldColumnDef> customFieldDefs = new ArrayList<CustomFieldColumnDef>();
    private final List<UnknownColumnDef> unknownColumnDefs = new ArrayList<UnknownColumnDef>();

    public WorksheetDef(@NotNull TemplateWorksheet worksheetType) {
        this.worksheetType = worksheetType;
    }

    public TemplateWorksheet getWorksheetType() {
        return this.worksheetType;
    }

    private boolean addColumnDef(@NotNull StdColumnDef<COL> columnDef) {
        StdColumnDef<COL> stdColumnDef = columnDef;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(stdColumnDef);
        return this.stdColumnDefs.put(columnDef.getType(), columnDef) != null;
    }

    WorksheetFormatStatus validate() {
        ArrayList<TemplateColumn> missingMandatoryColumnMismatch = new ArrayList<TemplateColumn>();
        TemplateColumn[] templateColumnArray = this.worksheetType.getColumnTypes();
        int n = templateColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateColumn col = templateColumnArray[n2];
            if (this.isMandatory(col) && this.noColumnDef(col)) {
                missingMandatoryColumnMismatch.add(col);
            }
            ++n2;
        }
        WorksheetFormatStatus worksheetStatus = new WorksheetFormatStatus(this.worksheetType);
        worksheetStatus.addMismatches(ColumnMismatch.MISSING_MANDATORY, missingMandatoryColumnMismatch);
        return worksheetStatus;
    }

    public Collection<UnknownColumnDef> getUnknownColumns() {
        return this.unknownColumnDefs;
    }

    private boolean isMandatory(TemplateColumn col) {
        return ColumnProcessingMode.MANDATORY == col.getProcessingMode();
    }

    private boolean noColumnDef(TemplateColumn col) {
        return this.stdColumnDefs.get(col) == null;
    }

    public boolean isCustomFieldHeader(String header) {
        return this.parseCustomFieldHeader(header) != null;
    }

    ColumnDef addColumnDef(String header, int colIndex) throws ColumnMismatchException {
        ColumnDef res = null;
        TemplateColumn colType = TemplateColumnUtils.coerceFromHeader(this.worksheetType.columnTypesClass, header);
        boolean duplicate = false;
        if (colType != null) {
            LOGGER.trace("Column named '{}' will be added to metamodel as standard column {}", new Object[]{header, colType});
            res = new StdColumnDef<TemplateColumn>(colType, colIndex);
            duplicate = this.addColumnDef((StdColumnDef<COL>)res);
        } else if (this.isCustomFieldHeader(header)) {
            LOGGER.trace("Column named '{}' will be added to metamodel as custom field", new Object[]{header});
            res = new CustomFieldColumnDef(this.parseCustomFieldHeader(header), colIndex);
            List<CustomFieldColumnDef> cufDefs = this.getCustomFieldDefs();
            duplicate = cufDefs.contains(res);
            cufDefs.add((CustomFieldColumnDef)res);
        } else {
            LOGGER.trace("Column named '{}' is unknown", new Object[]{header});
            this.unknownColumnDefs.add(new UnknownColumnDef(colIndex, header));
        }
        if (duplicate) {
            throw new ColumnMismatchException(ColumnMismatch.DUPLICATE, colType);
        }
        return res;
    }

    private String parseCustomFieldHeader(String header) {
        return this.worksheetType.customFieldPattern.parseFieldCode(header);
    }

    public StdColumnDef<COL> getColumnDef(COL col) {
        return this.stdColumnDefs.get(col);
    }

    public List<StdColumnDef<COL>> getImportableColumnDefs() {
        ArrayList<StdColumnDef<COL>> res = new ArrayList<StdColumnDef<COL>>(this.stdColumnDefs.size());
        for (Map.Entry<COL, StdColumnDef<COL>> entry : this.stdColumnDefs.entrySet()) {
            if (this.isIgnored((TemplateColumn)entry.getKey())) continue;
            if ("ACTION".equals(((TemplateColumn)entry.getKey()).getHeader())) {
                res.add(0, entry.getValue());
                continue;
            }
            res.add(entry.getValue());
        }
        return res;
    }

    private boolean isIgnored(COL col) {
        return ColumnProcessingMode.IGNORED == col.getProcessingMode();
    }

    public String getSheetName() {
        return this.worksheetType.sheetName;
    }

    public List<CustomFieldColumnDef> getCustomFieldDefs() {
        return this.customFieldDefs;
    }
}

