/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase.excel;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Component;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementNature;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.testcase.TestCaseAutomatable;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseKind;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.internal.batchimport.excel.CellValueCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.ImportModeCellCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.InfoListItemCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.OptionalBooleanCellCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.OptionalDateCellCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.OptionalEnumCellCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.OptionalIntegerCellCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.OptionalOneBasedIndexCellCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.OptionalStringArrayCellCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.ParamAssignationModeCellCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.StringCellCoercer;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementLinksSheetColumn;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.DatasetParamValuesSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.DatasetSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ParameterSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StepSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateWorksheet;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TestCaseSheetColumn;

@Component
final class CellValueCoercerRepository<COL extends Enum<COL>> {
    private static final CellValueCoercer<String> DEFAULT_COERCER = StringCellCoercer.INSTANCE;
    private static final Map<TemplateWorksheet, CellValueCoercerRepository<?>> COERCER_REPO_BY_WORKSHEET = new HashMap(TemplateWorksheet.values().length);
    private Map<COL, CellValueCoercer<?>> coercerByColumn = new HashMap();

    static {
        COERCER_REPO_BY_WORKSHEET.put(TemplateWorksheet.TEST_CASES_SHEET, CellValueCoercerRepository.createTestCasesSheetRepo());
        COERCER_REPO_BY_WORKSHEET.put(TemplateWorksheet.STEPS_SHEET, CellValueCoercerRepository.createStepsSheetRepo());
        COERCER_REPO_BY_WORKSHEET.put(TemplateWorksheet.PARAMETERS_SHEET, CellValueCoercerRepository.createParamsSheetRepo());
        COERCER_REPO_BY_WORKSHEET.put(TemplateWorksheet.DATASETS_SHEET, CellValueCoercerRepository.createDatasetsSheetRepo());
        COERCER_REPO_BY_WORKSHEET.put(TemplateWorksheet.DATASET_PARAM_VALUES_SHEET, CellValueCoercerRepository.createDatasetParamValuesSheetRepo());
        COERCER_REPO_BY_WORKSHEET.put(TemplateWorksheet.REQUIREMENT_SHEET, CellValueCoercerRepository.createRequirementSheetRepo());
        COERCER_REPO_BY_WORKSHEET.put(TemplateWorksheet.REQUIREMENT_LINKS_SHEET, CellValueCoercerRepository.createRequirementLinkSheetRepo());
        COERCER_REPO_BY_WORKSHEET.put(TemplateWorksheet.LINKED_LOW_LEVEL_REQS_SHEET, CellValueCoercerRepository.createLinkedLowLevelReqSheetRepo());
        COERCER_REPO_BY_WORKSHEET.put(TemplateWorksheet.COVERAGE_SHEET, CellValueCoercerRepository.createCoverageSheetRepo());
    }

    private CellValueCoercerRepository() {
    }

    public static final <C extends Enum<C>> CellValueCoercerRepository<C> forWorksheet(@NotNull TemplateWorksheet worksheet) {
        TemplateWorksheet templateWorksheet = worksheet;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)templateWorksheet);
        return COERCER_REPO_BY_WORKSHEET.get((Object)worksheet);
    }

    private static CellValueCoercerRepository<?> createCoverageSheetRepo() {
        CellValueCoercerRepository repo = new CellValueCoercerRepository();
        repo.coercerByColumn.put(CoverageSheetColumn.REQ_VERSION_NUM, OptionalIntegerCellCoercer.INSTANCE);
        return repo;
    }

    private static CellValueCoercerRepository<?> createRequirementSheetRepo() {
        CellValueCoercerRepository repo = new CellValueCoercerRepository();
        repo.coercerByColumn.put(RequirementSheetColumn.ACTION, ImportModeCellCoercer.INSTANCE);
        repo.coercerByColumn.put(RequirementSheetColumn.REQ_NUM, OptionalOneBasedIndexCellCoercer.INSTANCE);
        repo.coercerByColumn.put(RequirementSheetColumn.REQ_VERSION_CATEGORY, new InfoListItemCoercer(InfoListItemCoercer.ListRole.ROLE_CATEGORY));
        repo.coercerByColumn.put(RequirementSheetColumn.REQ_VERSION_CREATED_ON, OptionalDateCellCoercer.INSTANCE);
        repo.coercerByColumn.put(RequirementSheetColumn.REQ_NATURE, OptionalEnumCellCoercer.forEnum(RequirementNature.class));
        repo.coercerByColumn.put(RequirementSheetColumn.REQ_VERSION_CRITICALITY, OptionalEnumCellCoercer.forEnum(RequirementCriticality.class));
        repo.coercerByColumn.put(RequirementSheetColumn.REQ_VERSION_MILESTONE, OptionalStringArrayCellCoercer.INSTANCE);
        repo.coercerByColumn.put(RequirementSheetColumn.REQ_VERSION_NUM, OptionalIntegerCellCoercer.INSTANCE);
        repo.coercerByColumn.put(RequirementSheetColumn.REQ_VERSION_STATUS, OptionalEnumCellCoercer.forEnum(RequirementStatus.class));
        return repo;
    }

    private static CellValueCoercerRepository<?> createRequirementLinkSheetRepo() {
        CellValueCoercerRepository repo = new CellValueCoercerRepository();
        repo.coercerByColumn.put(RequirementLinksSheetColumn.ACTION, ImportModeCellCoercer.INSTANCE);
        repo.coercerByColumn.put(RequirementLinksSheetColumn.REQ_VERSION_NUM, OptionalIntegerCellCoercer.INSTANCE);
        repo.coercerByColumn.put(RequirementLinksSheetColumn.RELATED_REQ_VERSION_NUM, OptionalIntegerCellCoercer.INSTANCE);
        return repo;
    }

    private static CellValueCoercerRepository<?> createLinkedLowLevelReqSheetRepo() {
        return new CellValueCoercerRepository();
    }

    private static CellValueCoercerRepository<?> createDatasetsSheetRepo() {
        CellValueCoercerRepository repo = new CellValueCoercerRepository();
        repo.coercerByColumn.put(DatasetSheetColumn.ACTION, ImportModeCellCoercer.INSTANCE);
        return repo;
    }

    private static CellValueCoercerRepository<?> createDatasetParamValuesSheetRepo() {
        CellValueCoercerRepository repo = new CellValueCoercerRepository();
        repo.coercerByColumn.put(DatasetParamValuesSheetColumn.ACTION, ImportModeCellCoercer.INSTANCE);
        return repo;
    }

    private static CellValueCoercerRepository<ParameterSheetColumn> createParamsSheetRepo() {
        CellValueCoercerRepository<ParameterSheetColumn> repo = new CellValueCoercerRepository<ParameterSheetColumn>();
        repo.coercerByColumn.put(ParameterSheetColumn.ACTION, ImportModeCellCoercer.INSTANCE);
        return repo;
    }

    private static CellValueCoercerRepository<StepSheetColumn> createStepsSheetRepo() {
        CellValueCoercerRepository<StepSheetColumn> repo = new CellValueCoercerRepository<StepSheetColumn>();
        repo.coercerByColumn.put(StepSheetColumn.ACTION, ImportModeCellCoercer.INSTANCE);
        repo.coercerByColumn.put(StepSheetColumn.TC_STEP_NUM, OptionalOneBasedIndexCellCoercer.INSTANCE);
        repo.coercerByColumn.put(StepSheetColumn.TC_STEP_IS_CALL_STEP, OptionalBooleanCellCoercer.INSTANCE);
        repo.coercerByColumn.put(StepSheetColumn.TC_STEP_CALL_DATASET, ParamAssignationModeCellCoercer.INSTANCE);
        return repo;
    }

    private static CellValueCoercerRepository<TestCaseSheetColumn> createTestCasesSheetRepo() {
        CellValueCoercerRepository<TestCaseSheetColumn> repo = new CellValueCoercerRepository<TestCaseSheetColumn>();
        repo.coercerByColumn.put(TestCaseSheetColumn.TC_NUM, OptionalOneBasedIndexCellCoercer.INSTANCE);
        repo.coercerByColumn.put(TestCaseSheetColumn.TC_WEIGHT_AUTO, OptionalBooleanCellCoercer.INSTANCE);
        repo.coercerByColumn.put(TestCaseSheetColumn.TC_WEIGHT, OptionalEnumCellCoercer.forEnum(TestCaseImportance.class));
        repo.coercerByColumn.put(TestCaseSheetColumn.TC_NATURE, new InfoListItemCoercer(InfoListItemCoercer.ListRole.ROLE_NATURE));
        repo.coercerByColumn.put(TestCaseSheetColumn.TC_TYPE, new InfoListItemCoercer(InfoListItemCoercer.ListRole.ROLE_TYPE));
        repo.coercerByColumn.put(TestCaseSheetColumn.TC_STATUS, OptionalEnumCellCoercer.forEnum(TestCaseStatus.class));
        repo.coercerByColumn.put(TestCaseSheetColumn.TC_AUTOMATABLE, OptionalEnumCellCoercer.forEnum(TestCaseAutomatable.class));
        repo.coercerByColumn.put(TestCaseSheetColumn.TC_CREATED_ON, OptionalDateCellCoercer.INSTANCE);
        repo.coercerByColumn.put(TestCaseSheetColumn.TC_MILESTONE, OptionalStringArrayCellCoercer.INSTANCE);
        repo.coercerByColumn.put(TestCaseSheetColumn.DRAFTED_BY_AI, OptionalBooleanCellCoercer.INSTANCE);
        repo.coercerByColumn.put(TestCaseSheetColumn.ACTION, ImportModeCellCoercer.INSTANCE);
        repo.coercerByColumn.put(TestCaseSheetColumn.TC_KIND, OptionalEnumCellCoercer.forEnum(TestCaseKind.class));
        return repo;
    }

    public <VAL> CellValueCoercer<VAL> findCoercer(COL col) {
        CellValueCoercer<?> coercer = this.coercerByColumn.get(col);
        return coercer == null ? DEFAULT_COERCER : coercer;
    }

    public CellValueCoercer<String> findCustomFieldCoercer() {
        return StringCellCoercer.INSTANCE;
    }
}

