/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.testcase.excel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.core.foundation.sanitizehtml.HTMLSanitizeUtils;
import org.squashtest.tm.service.importer.ImportStatus;
import org.squashtest.tm.service.internal.batchimport.CallStepInstruction;
import org.squashtest.tm.service.internal.batchimport.CustomFieldHolder;
import org.squashtest.tm.service.internal.batchimport.Instruction;
import org.squashtest.tm.service.internal.batchimport.excel.CannotCoerceException;
import org.squashtest.tm.service.internal.batchimport.excel.InvalidTargetException;
import org.squashtest.tm.service.internal.batchimport.excel.NullMandatoryValueException;
import org.squashtest.tm.service.internal.batchimport.excel.PropertySetter;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CellValueCoercerRepository;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ColumnDef;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ColumnProcessingMode;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CustomFieldColumnDef;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.ParameterSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.PropertyHolderFinderRepository;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.PropertySetterRepository;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StdColumnDef;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StepSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateWorksheet;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TestCaseSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.WorksheetDef;
import org.squashtest.tm.service.internal.importer.ExcelRowReaderUtils;

public abstract class AbstractInstructionBuilder<COL extends Enum<COL>, INST extends Instruction<?>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final CellValueCoercerRepository<COL> coercerRepository;
    protected final PropertyHolderFinderRepository<COL> propHolderFinderRepository;
    protected final PropertySetterRepository<COL> propertySetterRepository;
    protected final WorksheetDef<COL> worksheetDef;

    protected AbstractInstructionBuilder(WorksheetDef<COL> worksheetDef) {
        this.worksheetDef = worksheetDef;
        TemplateWorksheet ws = worksheetDef.getWorksheetType();
        this.coercerRepository = CellValueCoercerRepository.forWorksheet(ws);
        this.propHolderFinderRepository = PropertyHolderFinderRepository.forWorksheet(ws);
        this.propertySetterRepository = PropertySetterRepository.forWorksheet(ws);
    }

    protected abstract INST createInstruction(Row var1);

    public final INST build(Row row) {
        INST instruction = this.createInstruction(row);
        ((Instruction)instruction).setLine(row.getRowNum() + 1);
        this.processStandardColumns(row, instruction);
        if (instruction instanceof CustomFieldHolder) {
            this.processCustomFieldColumns(row, instruction);
        }
        this.postProcessInstruction(row, instruction);
        return instruction;
    }

    protected void postProcessInstruction(Row row, INST instruction) {
    }

    private void processCustomFieldColumns(Row row, INST instruction) {
        for (CustomFieldColumnDef colDef : this.worksheetDef.getCustomFieldDefs()) {
            this.processCustomFieldColumn(row, colDef, instruction);
        }
    }

    private void processCustomFieldColumn(Row row, CustomFieldColumnDef colDef, INST instruction) {
        try {
            String value = this.getValue(row, colDef);
            ((CustomFieldHolder)instruction).addCustomField(colDef.getCode(), value);
        }
        catch (CannotCoerceException e) {
            this.log(colDef, e, instruction);
        }
    }

    private void processStandardColumns(Row row, INST instruction) {
        for (StdColumnDef<COL> colDef : this.worksheetDef.getImportableColumnDefs()) {
            this.processStandardColumn(row, colDef, instruction);
        }
    }

    private void processStandardColumn(Row row, StdColumnDef<COL> colDef, INST instruction) {
        this.logger.trace("Parsing column {} of type {}", new Object[]{colDef.getIndex(), colDef.getType()});
        Enum col = (Enum)colDef.getType();
        String value = null;
        try {
            value = (String)this.getValue(row, colDef);
        }
        catch (CannotCoerceException cce) {
            this.log(colDef, cce, instruction);
        }
        Object target = this.propHolderFinderRepository.findPropertyHolderFinder(col).find(instruction);
        PropertySetter propSetter = this.propertySetterRepository.findPropSetter(col);
        if (value != null && !(target instanceof CallStepInstruction)) {
            ArrayList<String> targetedColumnsToEscape = new ArrayList<String>(Arrays.asList(TestCaseSheetColumn.TC_DESCRIPTION.getHeader(), TestCaseSheetColumn.TC_PRE_REQUISITE.getHeader(), StepSheetColumn.TC_STEP_ACTION.getHeader(), StepSheetColumn.TC_STEP_EXPECTED_RESULT.getHeader(), RequirementSheetColumn.REQ_VERSION_DESCRIPTION.getHeader(), ParameterSheetColumn.TC_PARAM_DESCRIPTION.getHeader()));
            boolean mustEscapeColValue = this.mustEscapeColValue(colDef, targetedColumnsToEscape);
            value = mustEscapeColValue ? HTMLSanitizeUtils.cleanHtml((String)ExcelRowReaderUtils.escapeHTMLInsideTags(value)) : value;
        }
        try {
            propSetter.set(value, target);
        }
        catch (NullMandatoryValueException nullMandatoryValueException) {
            this.log(colDef, instruction);
        }
        catch (InvalidTargetException e) {
            ((Instruction)instruction).addLogEntry(e.getStatus(), e.getErrori18nMessage(), e.getImpacti18nMessage(), new Object[0]);
        }
    }

    private boolean mustEscapeColValue(ColumnDef colDef, List<String> targetedColumns) {
        return targetedColumns.stream().anyMatch(it -> it.equals(colDef.getHeader()));
    }

    private void log(ColumnDef colDef, INST instruction) {
        ((Instruction)instruction).addLogEntry(ImportStatus.FAILURE, "message.import.log.error.mandatoryColumn", null, colDef.getHeader());
    }

    private void log(ColumnDef colDef, CannotCoerceException e, INST instruction) {
        String impactKey = null;
        ImportStatus status = ImportStatus.FAILURE;
        if (!colDef.is(ColumnProcessingMode.MANDATORY)) {
            status = ImportStatus.WARNING;
            impactKey = e.getImpactI18nKey(((Instruction)instruction).getMode());
        }
        ((Instruction)instruction).addLogEntry(status, e.errorI18nKey, impactKey, colDef.getHeader());
    }

    protected final Cell getCell(Row row, ColumnDef colDef) {
        return row.getCell(colDef.getIndex(), Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
    }

    protected final <VAL> VAL getValue(Row row, StdColumnDef<COL> colDef) {
        Cell cell = this.getCell(row, colDef);
        String colType = ((TemplateColumn)colDef.getType()).getFullName();
        if (colType.contains("PATH")) {
            this.parsePathAfterPrefix(cell, "");
        }
        if ("STEPS.TC_STEP_ACTION".equals(colType)) {
            this.parsePathAfterPrefix(cell, "CALL ");
        }
        return this.coercerRepository.findCoercer((Enum)colDef.getType()).coerce(cell);
    }

    private void parsePathAfterPrefix(Cell cell, String prefix) {
        String path = cell.getStringCellValue();
        if (path == null || path.isEmpty()) {
            return;
        }
        String cleanString = path.trim().replace("\n", "");
        if (!cleanString.startsWith(prefix)) {
            return;
        }
        String finalString = (cleanString = cleanString.substring(prefix.length())).startsWith("/") ? cleanString : "/" + cleanString;
        finalString = String.valueOf(prefix) + finalString;
        if (!finalString.equals(path)) {
            cell.setCellValue(finalString);
        }
    }

    protected final String getValue(Row row, CustomFieldColumnDef colDef) {
        Cell cell = this.getCell(row, colDef);
        return this.coercerRepository.findCustomFieldCoercer().coerce(cell);
    }
}

