/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.requirement.excel;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Row;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.requirement.RequirementNature;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.service.internal.batchimport.HighLevelRequirementTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionInstruction;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.excel.CannotCoerceException;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.AbstractInstructionBuilder;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.StdColumnDef;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.WorksheetDef;

public class RequirementInstructionBuilder
extends AbstractInstructionBuilder<RequirementSheetColumn, RequirementVersionInstruction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementInstructionBuilder.class);

    public RequirementInstructionBuilder(WorksheetDef<RequirementSheetColumn> worksheetDef) {
        super(worksheetDef);
    }

    @Override
    protected RequirementVersionInstruction createInstruction(Row row) {
        StdColumnDef<RequirementSheetColumn> columnDef = this.worksheetDef.getColumnDef(RequirementSheetColumn.REQ_NATURE);
        RequirementNature requirementNature = null;
        if (columnDef != null) {
            try {
                requirementNature = (RequirementNature)this.getValue(row, columnDef);
            }
            catch (CannotCoerceException cce) {
                String requirementNatures = Arrays.stream(RequirementNature.values()).map(Enum::toString).collect(Collectors.joining(","));
                LOGGER.debug("The value for REQ_NATURE does not exist for the corresponded enum. Authorized values are : {}. Then, default value STANDARD will be assigned.", new Object[]{requirementNatures, cce});
            }
        }
        if (requirementNature == null) {
            requirementNature = RequirementNature.STANDARD;
        }
        if (requirementNature == RequirementNature.HIGH_LEVEL) {
            return new RequirementVersionInstruction(new RequirementVersionTarget(new HighLevelRequirementTarget(), 0), new RequirementVersion());
        }
        return new RequirementVersionInstruction(new RequirementVersionTarget(new RequirementTarget(), 0), new RequirementVersion());
    }
}

