/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.excel;

import javax.validation.constraints.NotNull;
import org.apache.poi.ss.usermodel.Cell;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.service.internal.batchimport.excel.AbstractTypeBasedCellValueCoercer;
import org.squashtest.tm.service.internal.batchimport.excel.CannotCoerceException;
import org.squashtest.tm.service.internal.batchimport.excel.CellValueCoercer;

public final class OptionalEnumCellCoercer<ENUM extends Enum<ENUM>>
extends AbstractTypeBasedCellValueCoercer<ENUM>
implements CellValueCoercer<ENUM> {
    private final Class<ENUM> enumType;

    private OptionalEnumCellCoercer(Class<ENUM> enumType) {
        this.enumType = enumType;
    }

    public static <E extends Enum<E>> OptionalEnumCellCoercer<E> forEnum(@NotNull Class<E> enumType) {
        Class<E> clazz = enumType;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289(clazz);
        return new OptionalEnumCellCoercer<E>(enumType);
    }

    @Override
    protected ENUM coerceStringCell(Cell cell) {
        String name = cell.getStringCellValue();
        try {
            return Enum.valueOf(this.enumType, name);
        }
        catch (IllegalArgumentException e) {
            throw new CannotCoerceException(e, "message.import.log.error.listField.wrongValueForListField", "message.import.log.impact.fieldNotChange", "message.import.log.impact.useDefaultValue");
        }
    }

    @Override
    protected ENUM coerceBlankCell(Cell cell) {
        return null;
    }
}

