/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport.excel;

import javax.validation.constraints.NotNull;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.squashtest.tm.aspect.validation.NotNullValidatorAspect;
import org.squashtest.tm.service.internal.batchimport.excel.CannotCoerceException;
import org.squashtest.tm.service.internal.batchimport.excel.CellValueCoercer;

public abstract class AbstractTypeBasedCellValueCoercer<VAL>
implements CellValueCoercer<VAL> {
    private final String errorI18nKey;

    protected AbstractTypeBasedCellValueCoercer() {
        this("message.import.log.error.cannotParse");
    }

    protected AbstractTypeBasedCellValueCoercer(@NotNull String errorI18nKey) {
        this.errorI18nKey = errorI18nKey;
    }

    @Override
    public final VAL coerce(Cell cell) throws CannotCoerceException {
        Cell cell2 = cell;
        NotNullValidatorAspect.aspectOf().ajc$before$org_squashtest_tm_aspect_validation_NotNullValidatorAspect$1$53d01289((Object)cell2);
        CellType type = cell.getCellType();
        return switch (type) {
            case CellType.BLANK -> this.coerceBlankCell(cell);
            case CellType.NUMERIC -> this.coerceNumericCell(cell);
            case CellType.STRING -> this.coerceStringCell(cell);
            case CellType.BOOLEAN -> this.coerceBooleanCell(cell);
            case CellType.FORMULA -> this.coerceFormulaCell(cell);
            case CellType.ERROR -> this.coerceErrorCell(cell);
            default -> throw new CannotCoerceException("Funky cell type " + type + " is not coercible", "message.import.log.error.unexpectedCellType");
        };
    }

    private VAL coerceErrorCell(Cell cell) {
        throw this.cannotCoerceFunky(cell);
    }

    private CannotCoerceException cannotCoerceFunky(Cell cell) {
        return new CannotCoerceException("Cannot coerce cell [R," + cell.getRowIndex() + " C" + cell.getColumnIndex() + "] of unhandled type", "message.import.log.error.unexpectedCellType");
    }

    protected VAL coerceFormulaCell(Cell cell) {
        throw this.cannotCoerceFunky(cell);
    }

    protected VAL coerceBooleanCell(Cell cell) {
        throw this.cannotCoerce("BOOLEAN", cell);
    }

    protected VAL coerceBlankCell(Cell cell) {
        throw this.cannotCoerce("BLANK", cell);
    }

    protected VAL coerceStringCell(Cell cell) {
        throw this.cannotCoerce("STRING", cell);
    }

    protected VAL coerceNumericCell(Cell cell) {
        throw this.cannotCoerce("NUMERIC", cell);
    }

    private CannotCoerceException cannotCoerce(String type, Cell cell) {
        return this.cannotCoerce(type, cell, this.errorI18nKey);
    }

    private CannotCoerceException cannotCoerce(String type, Cell cell, String errorI18nKey) {
        return new CannotCoerceException("Cannot coerce cell [R," + cell.getRowIndex() + " C" + cell.getColumnIndex() + "] of type " + type, errorI18nKey);
    }

    protected int liberallyParseInt(String s) throws CannotCoerceException {
        int res;
        try {
            res = Integer.valueOf(s, 10);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                res = this.round(Double.valueOf(s));
            }
            catch (NumberFormatException ex) {
                throw new CannotCoerceException(ex, "message.import.log.error.field.notInteger");
            }
        }
        return res;
    }

    protected int round(double val) {
        return (int)Math.round(val);
    }
}

