/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.importer.WithPath;

public class TestCaseTarget
implements Target,
WithPath {
    private String path;
    private Integer order;

    public TestCaseTarget() {
    }

    public TestCaseTarget(String path) {
        this.setPathPrivately(path);
    }

    public TestCaseTarget(String path, Integer order) {
        this.setPathPrivately(path);
        this.order = order;
    }

    @Override
    public EntityType getType() {
        return EntityType.TEST_CASE;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.setPathPrivately(path);
    }

    private void setPathPrivately(String pathParam) {
        String trimmedPath = pathParam.trim();
        String cleanedPath = PathUtils.cleanMultipleSlashes((String)trimmedPath);
        this.path = PathUtils.removeTrailingSpacesSurroundingSlashes((String)cleanedPath);
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public int hashCode() {
        int result = 47;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestCaseTarget other = (TestCaseTarget)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        return this.path;
    }

    @Override
    public boolean isWellFormed() {
        return PathUtils.isPathWellFormed((String)this.path);
    }

    @Override
    public String getProject() {
        return PathUtils.extractProjectName((String)this.path);
    }

    public String getName() {
        return PathUtils.extractTestCaseName((String)this.path);
    }

    public String getFolder() {
        String[] names = PathUtils.splitPath((String)this.path);
        Object[] shortened = Arrays.copyOf(names, names.length - 1);
        return "/" + StringUtils.join((Object[])shortened, (char)'/');
    }

    public boolean isRootTestCase() {
        String[] names = PathUtils.splitPath((String)this.path);
        return names.length == 2;
    }
}

