/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.MultiValueMap;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.tm.core.foundation.lang.PathUtils;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.NamedReference;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.library.structures.GraphNode;
import org.squashtest.tm.domain.library.structures.LibraryGraph;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.Requirement;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.testcase.Parameter;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestStep;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.internal.batchimport.CallStepParamsInfo;
import org.squashtest.tm.service.internal.batchimport.DatasetTarget;
import org.squashtest.tm.service.internal.batchimport.Existence;
import org.squashtest.tm.service.internal.batchimport.ImportedRequirementTree;
import org.squashtest.tm.service.internal.batchimport.ModelSubservicesProvider;
import org.squashtest.tm.service.internal.batchimport.ParameterTarget;
import org.squashtest.tm.service.internal.batchimport.ProjectTargetStatus;
import org.squashtest.tm.service.internal.batchimport.RequirementTarget;
import org.squashtest.tm.service.internal.batchimport.RequirementVersionTarget;
import org.squashtest.tm.service.internal.batchimport.StepType;
import org.squashtest.tm.service.internal.batchimport.TargetStatus;
import org.squashtest.tm.service.internal.batchimport.TestCaseCallGraph;
import org.squashtest.tm.service.internal.batchimport.TestCaseTarget;
import org.squashtest.tm.service.internal.batchimport.TestStepTarget;
import org.squashtest.tm.service.internal.repository.CustomFieldDao;
import org.squashtest.tm.service.internal.repository.DatasetDao;
import org.squashtest.tm.service.internal.repository.TestStepDao;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;
import org.squashtest.tm.service.internal.testcase.TestCaseCallTreeFinder;
import org.squashtest.tm.service.milestone.MilestoneMembershipFinder;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.service.requirement.RequirementLibraryFinderService;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.testcase.ParameterFinder;
import org.squashtest.tm.service.testcase.TestCaseFinder;
import org.squashtest.tm.service.testcase.TestCaseLibraryFinderService;

@Component
@Scope(value="prototype")
public class Model
implements ModelSubservicesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(Model.class);
    private static final String UNCHECKED = "unchecked";
    @PersistenceContext
    private EntityManager em;
    @Inject
    private CustomFieldDao cufDao;
    @Inject
    private TestCaseLibraryFinderService finderService;
    @Inject
    private RequirementLibraryFinderService reqFinderService;
    @Inject
    private TestCaseCallTreeFinder calltreeFinder;
    @Inject
    private TestCaseFinder testCaseFinder;
    @Inject
    private ParameterFinder paramFinder;
    @Inject
    private MilestoneMembershipFinder milestoneMemberFinder;
    @Inject
    private DatasetDao dsDao;
    @Inject
    private RequirementVersionManagerService requirementVersionManagerService;
    @Inject
    private LinkedRequirementVersionManagerService reqlinkService;
    @Inject
    private EntityPathHeaderDao pathHeaderDao;
    @Inject
    private TestStepDao testStepDao;
    private Map<TestCaseTarget, TargetStatus> testCaseStatusByTarget = new HashMap<TestCaseTarget, TargetStatus>();
    private Map<TestCaseTarget, List<InternalStepModel>> testCaseStepsByTarget = new HashMap<TestCaseTarget, List<InternalStepModel>>();
    private Map<Target, Boolean> isTargetMilestoneLocked = new HashMap<Target, Boolean>();
    private Map<String, ProjectTargetStatus> projectStatusByName = new HashMap<String, ProjectTargetStatus>();
    private MultiValueMap tcCufsPerProjectname = new MultiValueMap();
    private Set<String> requirementLinkRoles;
    private MultiValueMap stepCufsPerProjectname = new MultiValueMap();
    private MultiValueMap reqCufsPerProjectname = new MultiValueMap();
    private Map<TestCaseTarget, Collection<ParameterTarget>> parametersByTestCase = new HashMap<TestCaseTarget, Collection<ParameterTarget>>();
    private Map<TestCaseTarget, Set<DatasetTarget>> datasetsByTestCase = new HashMap<TestCaseTarget, Set<DatasetTarget>>();
    private TestCaseCallGraph callGraph = new TestCaseCallGraph();
    private ImportedRequirementTree requirementTree = new ImportedRequirementTree(this);

    @Override
    public RequirementLibraryFinderService getRequirementLibraryFinderService() {
        return this.reqFinderService;
    }

    public ProjectTargetStatus getProjectStatus(String projectName) {
        if (!this.projectStatusByName.containsKey(projectName = PathUtils.unescapePathPartSlashes((String)projectName))) {
            this.initProject(projectName);
        }
        return this.projectStatusByName.get(projectName);
    }

    public void initStatuses(Set<TestCaseTarget> targets) {
        Set targetList = targets.stream().filter(target -> !this.testCaseStatusByTarget.containsKey(target)).collect(Collectors.toSet());
        if (!targetList.isEmpty()) {
            this.mainInitTestCase(targetList.stream().toList());
        }
    }

    public TargetStatus getStatus(TestCaseTarget target) {
        LOGGER.debug("searching status for test case target : '{}'", new Object[]{target});
        if (!this.testCaseStatusByTarget.containsKey(target)) {
            this.mainInitTestCase(target);
        }
        TargetStatus status = this.testCaseStatusByTarget.get(target);
        LOGGER.trace("status for test case target '{}' : {}", new Object[]{target, status});
        return status;
    }

    public Map<TestCaseTarget, Long> getTargetIds(Set<TestCaseTarget> targets) {
        this.initStatuses(targets);
        return targets.stream().map(target -> Map.entry(target, this.testCaseStatusByTarget.get(target))).filter(entry -> entry.getValue() != null && ((TargetStatus)entry.getValue()).id != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((TargetStatus)entry.getValue()).id));
    }

    public void setExists(TestCaseTarget target, Long id) {
        LOGGER.trace("setting test case target '{}' to ", new Object[0]);
        this.testCaseStatusByTarget.put(target, new TargetStatus(Existence.EXISTS, id));
    }

    public void setToBeCreated(TestCaseTarget target) {
        this.testCaseStatusByTarget.put(target, new TargetStatus(Existence.TO_BE_CREATED));
        this.clearSteps(target);
    }

    public void setToBeDeleted(TestCaseTarget target) {
        TargetStatus oldStatus = this.testCaseStatusByTarget.get(target);
        this.testCaseStatusByTarget.put(target, new TargetStatus(Existence.TO_BE_DELETED, oldStatus.id));
        this.clearSteps(target);
        this.callGraph.removeNode(target);
    }

    public void setDeleted(TestCaseTarget target) {
        this.testCaseStatusByTarget.put(target, new TargetStatus(Existence.NOT_EXISTS, null));
        this.clearSteps(target);
        this.callGraph.removeNode(target);
    }

    public void setNotExists(TestCaseTarget target) {
        this.testCaseStatusByTarget.put(target, new TargetStatus(Existence.NOT_EXISTS, null));
        this.clearSteps(target);
    }

    private void clearSteps(TestCaseTarget target) {
        if (this.testCaseStepsByTarget.containsKey(target)) {
            this.testCaseStepsByTarget.get(target).clear();
        }
    }

    public Long getId(TestCaseTarget target) {
        return this.getStatus((TestCaseTarget)target).id;
    }

    public TestCase get(TestCaseTarget target) {
        Long id = this.getId(target);
        if (id == null) {
            return null;
        }
        return this.testCaseFinder.findById(id);
    }

    public boolean isTestCaseLockedByMilestones(TestCaseTarget target) {
        if (!this.testCaseStatusByTarget.containsKey(target)) {
            this.mainInitTestCase(target);
        }
        return this.isTargetMilestoneLocked.get(target);
    }

    public boolean isCalled(TestCaseTarget target) {
        if (!this.callGraph.knowsNode(target)) {
            this.initCallGraph(target);
        }
        return this.callGraph.isCalled(target);
    }

    public boolean isCalledBy(TestCaseTarget called, TestCaseTarget caller) {
        return this.wouldCreateCycle(called, caller);
    }

    public boolean wouldCreateCycle(TestCaseTarget srcTestCase, TestCaseTarget destTestCase) {
        if (!this.callGraph.knowsNode(srcTestCase)) {
            this.initCallGraph(srcTestCase);
        }
        if (!this.callGraph.knowsNode(destTestCase)) {
            this.initCallGraph(destTestCase);
        }
        return this.callGraph.wouldCreateCycle(srcTestCase, destTestCase);
    }

    public boolean wouldCreateCycle(TestStepTarget step, TestCaseTarget destTestCase) {
        return this.wouldCreateCycle(step.getTestCase(), destTestCase);
    }

    private void initCallGraph(TestCaseTarget target) {
        Long id = this.finderService.findNodeIdByPath(target.getPath());
        if (id == null) {
            this.callGraph.addNode(target);
            return;
        }
        LibraryGraph<NamedReference, LibraryGraph.SimpleNode<NamedReference>> targetCallers = this.calltreeFinder.getExtendedGraph(Collections.singletonList(id));
        Collection refs = targetCallers.getNodes();
        this.swapNameForPath(refs);
        this.callGraph.addGraph(targetCallers);
    }

    public void initCallGraph(Collection<TestCaseTarget> targets) {
        Set<Long> testCaseIds = targets.stream().filter(target -> !this.callGraph.knowsNode((TestCaseTarget)target)).map(target -> {
            Long id = this.getId((TestCaseTarget)target);
            if (id == null) {
                this.callGraph.addNode((TestCaseTarget)target);
            }
            return id;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        if (!testCaseIds.isEmpty()) {
            this.initRecursiveCallGraph(testCaseIds);
        }
    }

    public void initRecursiveCallGraph(Collection<Long> testCaseIds) {
        LibraryGraph<NamedReference, LibraryGraph.SimpleNode<NamedReference>> targetCallers = this.calltreeFinder.getExtendedGraph(testCaseIds);
        Collection refs = targetCallers.getNodes();
        this.swapNameForPath(refs);
        this.callGraph.addGraph(targetCallers);
    }

    private void addCallGraphEdge(TestCaseTarget src, TestCaseTarget dest) {
        if (!this.callGraph.knowsNode(src)) {
            this.initCallGraph(src);
        }
        if (!this.callGraph.knowsNode(dest)) {
            this.initCallGraph(dest);
        }
        this.callGraph.addEdge(src, dest);
    }

    public Integer addActionStep(TestStepTarget target) {
        return this.addStep(target, StepType.ACTION, null);
    }

    public Integer addCallStep(TestStepTarget target, TestCaseTarget calledTestCase, ParameterAssignationMode parameterMode) {
        Boolean delegates = ParameterAssignationMode.DELEGATE.equals((Object)parameterMode);
        this.addCallGraphEdge(target.getTestCase(), calledTestCase);
        return this.addStep(target, StepType.CALL, calledTestCase, delegates);
    }

    private Integer addStep(TestStepTarget target, StepType type, TestCaseTarget calledTestCase, Boolean delegates) {
        List<InternalStepModel> steps = this.findInternalStepModels(target);
        Integer index = target.getIndex();
        if (index == null || index >= steps.size() || index < 0) {
            index = steps.size();
        }
        steps.add(index, new InternalStepModel(type, calledTestCase, delegates));
        return index;
    }

    private Integer addStep(TestStepTarget target, StepType type, TestCaseTarget calledTestCase) {
        List<InternalStepModel> steps = this.findInternalStepModels(target);
        Integer index = target.getIndex();
        if (index == null || index >= steps.size() || index < 0) {
            index = steps.size();
        }
        steps.add(index, new InternalStepModel(type, calledTestCase));
        return index;
    }

    public void updateCallStepTarget(TestStepTarget step, TestCaseTarget newTarget, CallStepParamsInfo paramInfo) {
        if (!this.stepExists(step)) {
            throw new IllegalArgumentException("cannot update non existant step '" + step + "'");
        }
        if (this.getType(step) != StepType.CALL) {
            throw new IllegalArgumentException("cannot update the called test case for step '" + step + "' because that step is not a call step");
        }
        InternalStepModel model = this.findInternalStepModel(step);
        Boolean delegates = paramInfo.getParamMode() == ParameterAssignationMode.DELEGATE;
        model.setDelegates(delegates);
        TestCaseTarget src = step.getTestCase();
        TestCaseTarget oldDest = model.getCalledTC();
        model.setCalledTC(newTarget);
        this.callGraph.removeEdge(src, oldDest);
        this.callGraph.addEdge(src, newTarget);
    }

    public void remove(TestStepTarget target) {
        if (!this.stepExists(target)) {
            throw new IllegalArgumentException("cannot remove non existant step '" + target + "'");
        }
        List<InternalStepModel> steps = this.findInternalStepModels(target);
        Integer index = target.getIndex();
        InternalStepModel step = steps.remove(index);
        if (step.type == StepType.CALL) {
            this.callGraph.removeEdge(target.getTestCase(), step.getCalledTC());
        }
    }

    public boolean stepExists(TestStepTarget target) {
        InternalStepModel model = this.findInternalStepModel(target);
        return model != null;
    }

    public boolean indexIsFirstAvailable(TestStepTarget target) {
        Integer index = target.getIndex();
        TestCaseTarget tc = target.getTestCase();
        if (!this.testCaseStatusByTarget.containsKey(tc)) {
            this.mainInitTestCase(tc);
        }
        List<InternalStepModel> steps = this.testCaseStepsByTarget.get(tc);
        if (index == null || steps == null) {
            return false;
        }
        return index.intValue() == steps.size();
    }

    public StepType getType(TestStepTarget target) {
        InternalStepModel model = this.findInternalStepModel(target);
        if (model != null) {
            return model.getType();
        }
        return null;
    }

    public Long getStepId(TestStepTarget target) {
        Long tcId = this.getStatus((TestCaseTarget)target.getTestCase()).id;
        Integer index = target.getIndex();
        if (!this.stepExists(target) || tcId == null || index == null) {
            return null;
        }
        Query q = this.em.createNamedQuery("testStep.findIdByTestCaseAndPosition");
        q.setParameter(":tcId", (Object)tcId);
        q.setParameter("position", (Object)index);
        return (Long)q.getSingleResult();
    }

    public TestStep getStep(TestStepTarget target) {
        Long tcId = this.getStatus((TestCaseTarget)target.getTestCase()).id;
        Integer index = target.getIndex();
        if (!this.stepExists(target) || tcId == null || index == null) {
            return null;
        }
        Query query = this.em.createNamedQuery("testStep.findByTestCaseAndPosition");
        query.setParameter("tcId", (Object)tcId);
        query.setParameter("position", (Object)index);
        return (TestStep)query.getSingleResult();
    }

    private List<InternalStepModel> findInternalStepModels(TestStepTarget step) {
        TestCaseTarget tc = step.getTestCase();
        if (!this.testCaseStatusByTarget.containsKey(tc)) {
            this.mainInitTestCase(tc);
        }
        return this.testCaseStepsByTarget.get(tc);
    }

    private InternalStepModel findInternalStepModel(TestStepTarget step) {
        Integer index = step.getIndex();
        List<InternalStepModel> steps = this.findInternalStepModels(step);
        if (index != null && steps.size() > index && index >= 0) {
            return steps.get(index);
        }
        return null;
    }

    public boolean doesParameterExists(ParameterTarget target) {
        TestCaseTarget tc = target.getOwner();
        if (!this.parametersByTestCase.containsKey(tc)) {
            this.initParameters(Collections.singleton(tc));
        }
        return this.parametersByTestCase.get(tc).contains(target);
    }

    public void addParameter(ParameterTarget target) {
        TestCaseTarget tc = target.getOwner();
        if (!this.parametersByTestCase.containsKey(tc)) {
            this.initParameters(Collections.singleton(tc));
        }
        this.parametersByTestCase.get(tc).add(target);
    }

    public void removeParameter(ParameterTarget target) {
        TestCaseTarget tc = target.getOwner();
        if (!this.parametersByTestCase.containsKey(tc)) {
            this.initParameters(Collections.singleton(tc));
        }
        this.parametersByTestCase.get(tc).remove(target);
    }

    public Collection<ParameterTarget> getOwnParameters(TestCaseTarget testCase) {
        if (!this.parametersByTestCase.containsKey(testCase)) {
            this.initParameters(Collections.singleton(testCase));
        }
        return this.parametersByTestCase.get(testCase);
    }

    public Collection<ParameterTarget> getAllParameters(TestCaseTarget testCase) {
        if (!this.callGraph.knowsNode(testCase)) {
            this.initCallGraph(testCase);
        }
        HashSet<ParameterTarget> result = new HashSet<ParameterTarget>();
        LinkedList<TestCaseCallGraph.Node> processing = new LinkedList<TestCaseCallGraph.Node>();
        HashSet<TestCaseCallGraph.Node> processed = new HashSet<TestCaseCallGraph.Node>();
        processing.add((TestCaseCallGraph.Node)this.callGraph.getNode(testCase));
        while (!processing.isEmpty()) {
            TestCaseCallGraph.Node current = (TestCaseCallGraph.Node)((Object)processing.pop());
            result.addAll(this.getOwnParameters((TestCaseTarget)current.getKey()));
            for (TestCaseCallGraph.Node child : current.getOutbounds()) {
                List<InternalStepModel> steps = this.testCaseStepsByTarget.get(current.getKey());
                this.extractParametersFromSteps(processing, child, steps);
                processed.add(current);
            }
        }
        return result;
    }

    private void extractParametersFromSteps(Collection<TestCaseCallGraph.Node> processing, TestCaseCallGraph.Node child, List<InternalStepModel> steps) {
        if (steps != null) {
            for (InternalStepModel step : steps) {
                if (step.type != StepType.CALL || !step.calledTC.equals(child.getKey()) || !step.getDeleguates()) continue;
                processing.add(child);
            }
        }
    }

    public boolean isParamInDataset(ParameterTarget param, DatasetTarget ds) {
        Collection<ParameterTarget> allparams = this.getAllParameters(ds.getTestCase());
        return allparams.contains(param);
    }

    public boolean doesDatasetExists(DatasetTarget target) {
        TestCaseTarget tc = target.getTestCase();
        if (!this.datasetsByTestCase.containsKey(tc)) {
            this.initDatasets(Collections.singletonList(tc));
        }
        return this.datasetsByTestCase.get(tc).contains(target);
    }

    public void addDataset(DatasetTarget target) {
        TestCaseTarget tc = target.getTestCase();
        if (!this.datasetsByTestCase.containsKey(tc)) {
            this.initDatasets(Collections.singletonList(tc));
        }
        this.datasetsByTestCase.get(tc).add(target);
    }

    public void addDatasets(List<DatasetTarget> datasetTargets) {
        Set<TestCaseTarget> targetList = datasetTargets.stream().map(DatasetTarget::getTestCase).filter(target -> !this.datasetsByTestCase.containsKey(target)).collect(Collectors.toSet());
        if (!targetList.isEmpty()) {
            this.initDatasets(targetList);
        }
    }

    public void removeDataset(DatasetTarget target) {
        TestCaseTarget tc = target.getTestCase();
        if (!this.datasetsByTestCase.containsKey(tc)) {
            this.initDatasets(Collections.singletonList(tc));
        }
        this.datasetsByTestCase.get(tc).remove(target);
    }

    public Collection<DatasetTarget> getDatasets(TestCaseTarget testCase) {
        if (!this.datasetsByTestCase.containsKey(testCase)) {
            this.initDatasets(Collections.singletonList(testCase));
        }
        return this.datasetsByTestCase.get(testCase);
    }

    public Collection<CustomField> getTestCaseCufs(TestCaseTarget target) {
        String projectName;
        Collection cufs;
        if (!this.testCaseStatusByTarget.containsKey(target)) {
            this.mainInitTestCase(target);
        }
        if ((cufs = this.tcCufsPerProjectname.getCollection((Object)(projectName = PathUtils.extractProjectName((String)target.getPath())))) != null) {
            return cufs;
        }
        return Collections.emptyList();
    }

    public Collection<CustomField> getRequirementVersionCufs(RequirementVersionTarget target) {
        String projectName;
        Collection cufs;
        if (!this.requirementTree.targetAlreadyLoaded(target)) {
            this.mainInitRequirements(target);
        }
        if ((cufs = this.reqCufsPerProjectname.getCollection((Object)(projectName = PathUtils.extractProjectName((String)target.getPath())))) != null) {
            return cufs;
        }
        return Collections.emptyList();
    }

    public Collection<CustomField> getTestStepCufs(TestStepTarget target) {
        String projectName;
        Collection cufs;
        TestCaseTarget tc = target.getTestCase();
        if (!this.testCaseStatusByTarget.containsKey(tc)) {
            this.mainInitTestCase(tc);
        }
        if ((cufs = this.stepCufsPerProjectname.getCollection((Object)(projectName = PathUtils.extractProjectName((String)tc.getPath())))) != null) {
            return cufs;
        }
        return Collections.emptyList();
    }

    public TargetStatus getStatus(RequirementTarget target) {
        if (!this.requirementTree.targetAlreadyLoaded(target)) {
            this.loadRequirement(target);
        }
        return this.requirementTree.getStatus(target);
    }

    private void loadRequirement(RequirementTarget target) {
        Long reqId;
        if (target.isSynchronized()) {
            if (target.getRemoteSynchronisationId() == null) {
                LOGGER.debug("ReqImport - looking for synchronized requirement key : '{}'", new Object[]{target.getRemoteKey()});
                reqId = this.reqFinderService.findNodeIdByRemoteKey(target.getRemoteKey(), target.getProject());
            } else {
                LOGGER.debug("ReqImport - looking for synchronized requirement key : '{}'", new Object[]{target.getRemoteKey()});
                reqId = this.reqFinderService.findNodeIdByRemoteKeyAndSynchronisationId(target.getRemoteKey(), target.getRemoteSynchronisationId());
            }
        } else {
            LOGGER.debug("ReqImport - looking for native requirement by path : '{}'", new Object[]{target.getPath()});
            reqId = this.reqFinderService.findNodeIdByPath(target.getPath());
        }
        LOGGER.debug("ReqImport - result find by node : {}", new Object[]{reqId});
        if (reqId != null) {
            this.requirementTree.addOrUpdateNode(target, new TargetStatus(Existence.EXISTS, reqId));
            target.setId(reqId);
        } else {
            this.requirementTree.addOrUpdateNode(target, new TargetStatus(Existence.NOT_EXISTS));
        }
    }

    public TargetStatus getStatus(RequirementVersionTarget target) {
        if (!this.requirementTree.targetAlreadyLoaded(target)) {
            this.mainInitRequirements(target);
        }
        return this.requirementTree.getStatus(target);
    }

    public Set<String> getRequirementLinkRoles() {
        if (this.requirementLinkRoles == null) {
            this.requirementLinkRoles = Collections.unmodifiableSet(this.reqlinkService.findAllRoleCodes());
        }
        return this.requirementLinkRoles;
    }

    public void mainInitTestCase(TestCaseTarget target) {
        this.mainInitTestCase(Arrays.asList(target));
    }

    public void mainInitTestCase(List<TestCaseTarget> targets) {
        List<TestCaseTarget> uniqueTargets = this.uniqueList(targets);
        this.initTestCases(uniqueTargets);
        this.initTestSteps(uniqueTargets);
        this.initProjects(uniqueTargets);
    }

    private void initTestCases(List<TestCaseTarget> initialTargets) {
        List<TestCaseTarget> targets = initialTargets.stream().filter(target -> !this.testCaseStatusByTarget.containsKey(target)).toList();
        if (targets.isEmpty()) {
            return;
        }
        Map<String, List<TestCaseTarget>> targetsByProjectName = initialTargets.stream().collect(Collectors.groupingBy(TestCaseTarget::getProject));
        targetsByProjectName.forEach(this::initTestCaseInProject);
    }

    private void initTestCaseInProject(String projectName, List<TestCaseTarget> targetList) {
        HashMap<Long, TestCaseTarget> existingTargets = new HashMap<Long, TestCaseTarget>();
        TreeMap<String, Long> testCasePathsInProject = this.finderService.buildTestCasePathsTree(projectName);
        for (TestCaseTarget target : targetList) {
            String path = PathUtils.unescapePathPartSlashes((String)target.getPath().replaceFirst("^/", "").replaceFirst("(?<!\\\\)/$", ""));
            Long id = testCasePathsInProject.get(path);
            Existence existence = id == null ? Existence.NOT_EXISTS : Existence.EXISTS;
            TargetStatus status = new TargetStatus(existence, id);
            this.testCaseStatusByTarget.put(target, status);
            if (existence == Existence.EXISTS) {
                existingTargets.put(id, target);
                continue;
            }
            this.isTargetMilestoneLocked.put(target, false);
        }
        if (existingTargets.isEmpty()) {
            return;
        }
        List<Long> testIdsBoundToBlockingMilestone = this.milestoneMemberFinder.findTestCaseIdsBoundToBlockingMilestone(existingTargets.keySet());
        existingTargets.forEach((testCaseId, existingTarget) -> {
            Boolean bl = this.isTargetMilestoneLocked.put((Target)existingTarget, testIdsBoundToBlockingMilestone.contains(testCaseId));
        });
    }

    public void initParameters(Set<TestCaseTarget> testCaseTargets) {
        Map<Long, TestCaseTarget> testCaseTargetById = this.collectExistingTestCaseTargetById(testCaseTargets);
        testCaseTargets.stream().filter(target -> !this.parametersByTestCase.containsKey(target)).forEach(target -> {
            HashSet hashSet = this.parametersByTestCase.putIfAbsent((TestCaseTarget)target, new HashSet());
        });
        if (testCaseTargetById.isEmpty()) {
            return;
        }
        Map<Long, List<Parameter>> parametersByTestCaseId = this.paramFinder.findOwnParametersByTestCaseIds(testCaseTargetById.keySet());
        for (Map.Entry<Long, TestCaseTarget> entry : testCaseTargetById.entrySet()) {
            List parameters = parametersByTestCaseId.getOrDefault(entry.getKey(), List.of());
            Set parameterTargets = parameters.stream().map(p -> new ParameterTarget((TestCaseTarget)entry.getValue(), p.getName())).collect(Collectors.toSet());
            this.parametersByTestCase.computeIfAbsent(entry.getValue(), key -> parameterTargets);
        }
    }

    private Map<Long, TestCaseTarget> collectExistingTestCaseTargetById(Set<TestCaseTarget> testCaseTargets) {
        this.initStatuses(testCaseTargets);
        return testCaseTargets.stream().filter(target -> !this.parametersByTestCase.containsKey(target)).map(target -> Map.entry(target, this.getStatus((TestCaseTarget)target))).filter(entry -> ((TargetStatus)entry.getValue()).id != null && ((TargetStatus)entry.getValue()).status != Existence.TO_BE_DELETED).collect(Collectors.toMap(entry -> ((TargetStatus)entry.getValue()).id, Map.Entry::getKey, (a, b) -> a));
    }

    private void initDatasets(Collection<TestCaseTarget> testCaseTargets) {
        Map<Long, TestCaseTarget> testCaseTargetById = testCaseTargets.stream().filter(target -> !this.datasetsByTestCase.containsKey(target)).map(target -> Map.entry(target, this.getStatus((TestCaseTarget)target))).filter(entry -> ((TargetStatus)entry.getValue()).id != null && ((TargetStatus)entry.getValue()).status != Existence.TO_BE_DELETED).collect(Collectors.toMap(entry -> ((TargetStatus)entry.getValue()).id, Map.Entry::getKey, (a, b) -> a));
        Map datasetsByTestCaseId = this.dsDao.findOwnDatasetNamesByTestCaseIds(testCaseTargetById.keySet());
        for (Map.Entry<Long, TestCaseTarget> entry2 : testCaseTargetById.entrySet()) {
            List datasetsNames = datasetsByTestCaseId.getOrDefault(entry2.getKey(), Collections.emptyList());
            TestCaseTarget target2 = entry2.getValue();
            HashSet<DatasetTarget> datasetTarget = new HashSet<DatasetTarget>(datasetsNames.size());
            for (String name : datasetsNames) {
                datasetTarget.add(new DatasetTarget(target2, name));
            }
            this.datasetsByTestCase.put(target2, datasetTarget);
        }
        testCaseTargets.stream().filter(target -> !this.datasetsByTestCase.containsKey(target)).forEach(target -> {
            HashSet hashSet = this.datasetsByTestCase.putIfAbsent((TestCaseTarget)target, new HashSet());
        });
    }

    private void initTestSteps(List<TestCaseTarget> targets) {
        Map targetsByTestCaseId = targets.stream().filter(target -> !this.testCaseStepsByTarget.containsKey(target)).filter(target -> {
            TargetStatus status = this.testCaseStatusByTarget.get(target);
            return status.id != null && status.status != Existence.TO_BE_DELETED;
        }).collect(Collectors.groupingBy(target -> this.testCaseStatusByTarget.get((Object)target).id, HashMap::new, Collectors.toList()));
        targets.stream().filter(target -> !this.testCaseStepsByTarget.containsKey(target)).forEach(target -> {
            ArrayList arrayList = this.testCaseStepsByTarget.putIfAbsent((TestCaseTarget)target, new ArrayList());
        });
        if (targetsByTestCaseId.isEmpty()) {
            return;
        }
        Map<Long, List<InternalStepModel>> stepModelsByTestCaseId = this.loadStepsModel(targetsByTestCaseId.keySet());
        stepModelsByTestCaseId.forEach((id, steps) -> {
            List testCaseTargets = targetsByTestCaseId.getOrDefault(id, List.of());
            testCaseTargets.forEach(target -> {
                List<InternalStepModel> list2 = this.testCaseStepsByTarget.put((TestCaseTarget)target, (List<InternalStepModel>)steps);
            });
        });
    }

    private void initProject(String projectName) {
        this.initProjectsByName(Collections.singletonList(projectName));
    }

    private void initProjects(List<TestCaseTarget> targets) {
        this.initProjectsByName(this.collectProjects(targets));
    }

    private void initProjectsByName(List<String> allNames) {
        List allUnescapedNames = PathUtils.unescapePathPartSlashes(allNames);
        LinkedList<String> projectNames = new LinkedList<String>();
        for (String name : allUnescapedNames) {
            if (this.projectStatusByName.containsKey(name)) continue;
            projectNames.add(name);
        }
        if (projectNames.isEmpty()) {
            return;
        }
        List<Project> projects = this.loadProjects(projectNames);
        for (Project p : projects) {
            LOGGER.debug("ReqImport - Trying to import project in model {}", new Object[]{p.getId()});
            ProjectTargetStatus status = new ProjectTargetStatus(Existence.EXISTS, p.getId(), p.getTestCaseLibrary().getId(), p.getRequirementLibrary().getId());
            this.projectStatusByName.put(p.getName(), status);
            this.initCufs(p.getName());
        }
        Set<String> knownProjects = this.projectStatusByName.keySet();
        for (String name : projectNames) {
            if (knownProjects.contains(name)) continue;
            this.projectStatusByName.put(name, new ProjectTargetStatus(Existence.NOT_EXISTS));
        }
    }

    private void initCufs(String projectName) {
        Long projectId = this.projectStatusByName.get((Object)projectName).id;
        List<CustomField> tccufs = this.cufDao.findAllBoundCustomFields(projectId, BindableEntity.TEST_CASE);
        this.tcCufsPerProjectname.putAll((Object)projectName, tccufs);
        List<CustomField> stcufs = this.cufDao.findAllBoundCustomFields(projectId, BindableEntity.TEST_STEP);
        this.stepCufsPerProjectname.putAll((Object)projectName, stcufs);
        List<CustomField> reqcufs = this.cufDao.findAllBoundCustomFields(projectId, BindableEntity.REQUIREMENT_VERSION);
        this.reqCufsPerProjectname.putAll((Object)projectName, reqcufs);
    }

    public void mainInitRequirements(RequirementVersionTarget target) {
        this.mainInitRequirements(Arrays.asList(target));
    }

    public void mainInitRequirements(List<RequirementVersionTarget> targets) {
        List<RequirementVersionTarget> uniqueTargets = this.uniqueList(targets);
        this.initRequirementVersions(uniqueTargets);
        this.initRequirementProjects(uniqueTargets);
    }

    private void initRequirementProjects(List<RequirementVersionTarget> uniqueTargets) {
        LOGGER.debug("ReqImport - Looking for project {}", new Object[]{this.collectRequirementProjects(uniqueTargets)});
        this.initProjectsByName(this.collectRequirementProjects(uniqueTargets));
    }

    public void initRequirementVersions(List<RequirementVersionTarget> initialTargets) {
        LOGGER.debug("ReqImport - Initialize targets", new Object[0]);
        ArrayList<RequirementVersionTarget> targets = new ArrayList<RequirementVersionTarget>(initialTargets.size());
        for (RequirementVersionTarget target : initialTargets) {
            if (this.requirementTree.targetAlreadyLoaded(target)) continue;
            targets.add(target);
        }
        if (targets.isEmpty()) {
            return;
        }
        for (RequirementVersionTarget target : targets) {
            LOGGER.debug("ReqImport - Initialize target {}", new Object[]{target.getPath()});
            Existence reqExistence = this.getStatus(target.getRequirement()).getStatus();
            if (reqExistence != Existence.EXISTS) {
                LOGGER.debug("ReqImport - requirement doesn't exist so we don't need to check version", new Object[0]);
                this.requirementTree.addOrUpdateNode(target, TargetStatus.NOT_EXISTS);
                continue;
            }
            Long reqId = this.requirementTree.getNodeId(target.getRequirement());
            Integer versionNumber = target.getVersion();
            Long reqVersionId = this.requirementVersionManagerService.findReqVersionIdByRequirementAndVersionNumber(reqId, versionNumber);
            if (reqVersionId != null) {
                this.initExistingRequirementVersion(target, reqVersionId);
            } else {
                this.requirementTree.addOrUpdateNode(target, new TargetStatus(Existence.NOT_EXISTS));
            }
            Requirement req = this.requirementVersionManagerService.findRequirementById(reqId);
            List reqVersions = req.getRequirementVersions();
            for (RequirementVersion requirementVersion : reqVersions) {
                RequirementVersionTarget existingRequirementversion = new RequirementVersionTarget(target.getRequirement(), requirementVersion.getVersionNumber());
                this.initExistingRequirementVersion(existingRequirementversion, requirementVersion.getId());
            }
        }
    }

    private void initExistingRequirementVersion(RequirementVersionTarget target, Long reqVersionId) {
        this.requirementTree.addOrUpdateNode(target, new TargetStatus(Existence.EXISTS, reqVersionId));
        Collection<Milestone> milestones = this.milestoneMemberFinder.findMilestonesForRequirementVersion(reqVersionId);
        for (Milestone milestone : milestones) {
            this.requirementTree.bindMilestone(target, milestone.getLabel());
            if (milestone.getStatus() != MilestoneStatus.LOCKED && milestone.getStatus() != MilestoneStatus.PLANNED) continue;
            this.requirementTree.milestoneLock(target);
        }
    }

    public void addRequirementVersion(RequirementVersionTarget target, TargetStatus targetStatus) {
        this.requirementTree.addOrUpdateNode(target, targetStatus);
    }

    public void addRequirementVersion(RequirementVersionTarget target, TargetStatus targetStatus, List<String> milestones) {
        this.requirementTree.addOrUpdateNode(target, targetStatus);
        this.requirementTree.bindMilestone(target, milestones);
    }

    public void addRequirement(RequirementTarget target, TargetStatus status) {
        this.requirementTree.addOrUpdateNode(target, status);
    }

    public Long getRequirementId(RequirementVersionTarget target) {
        return this.requirementTree.getNodeId(target.getRequirement());
    }

    public RequirementTarget getRequirementTarget(RequirementTarget target) {
        return this.requirementTree.getNodes().stream().filter(node -> ((RequirementTarget)node.getKey()).getPath().equals(target.getPath())).map(GraphNode::getKey).findFirst().orElse(null);
    }

    public void setNotExists(RequirementVersionTarget target) {
        this.requirementTree.setNotExists(target);
    }

    public boolean checkMilestonesAlreadyUsedInRequirement(String milestone, RequirementVersionTarget target) {
        return this.requirementTree.isMilestoneUsedByOneVersion(target, milestone);
    }

    public boolean isRequirementFolder(RequirementVersionTarget target) {
        return this.requirementTree.isRequirementFolder(target);
    }

    public boolean isRequirementFolder(RequirementTarget target) {
        return this.requirementTree.isRequirementFolder(target);
    }

    public void bindMilestonesToRequirementVersion(RequirementVersionTarget target, List<String> milestones) {
        this.requirementTree.bindMilestone(target, milestones);
    }

    public boolean isRequirementVersionLockedByMilestones(RequirementVersionTarget target) {
        if (!this.requirementTree.targetAlreadyLoaded(target)) {
            this.mainInitRequirements(target);
        }
        return this.requirementTree.isMilestoneLocked(target);
    }

    private <OBJ> List<OBJ> uniqueList(Collection<OBJ> orig) {
        LinkedHashSet<OBJ> filtered = new LinkedHashSet<OBJ>(orig);
        return new ArrayList<OBJ>(filtered);
    }

    private <TARGET extends Target> List<String> collectProjects(List<TARGET> targets) {
        List<String> paths = this.collectPaths(targets);
        return PathUtils.extractProjectNames(paths);
    }

    private List<String> collectRequirementProjects(List<RequirementVersionTarget> targets) {
        List<String> paths = this.collectRequirementPaths(targets);
        return PathUtils.extractProjectNames(paths);
    }

    private <TARGET extends Target> List<String> collectPaths(List<TARGET> targets) {
        return (List)CollectionUtils.collect(targets, (Transformer)PathCollector.INSTANCE, new ArrayList(targets.size()));
    }

    private List<String> collectRequirementPaths(List<RequirementVersionTarget> targets) {
        return (List)CollectionUtils.collect(targets, (Transformer)RequirementPathCollector.INSTANCE, new ArrayList(targets.size()));
    }

    private List<Project> loadProjects(List<String> names) {
        List unescapedNames = PathUtils.unescapePathPartSlashes(names);
        Query q = this.em.createNamedQuery("Project.findAllByName");
        q.setParameter("names", (Object)unescapedNames);
        return q.getResultList();
    }

    private List<InternalStepModel> loadStepsModel(Long tcId) {
        Query query = this.em.createNamedQuery("testStep.findBasicInfosByTcId");
        query.setParameter("tcId", (Object)tcId);
        List stepdata = query.getResultList();
        ArrayList<InternalStepModel> steps = new ArrayList<InternalStepModel>(stepdata.size());
        for (Object[] tuple : stepdata) {
            StepType type = StepType.valueOf((String)tuple[0]);
            TestCaseTarget calledTC = null;
            boolean delegates = false;
            if (type == StepType.CALL) {
                if (tuple[1] != null) {
                    String path = this.finderService.getPathAsString((Long)tuple[1]);
                    calledTC = new TestCaseTarget(path);
                }
                delegates = (Boolean)tuple[2];
            }
            steps.add(new InternalStepModel(type, calledTC, delegates));
        }
        return steps;
    }

    private Map<Long, List<InternalStepModel>> loadStepsModel(Collection<Long> tcIds) {
        List<Object[]> stepsData = this.testStepDao.findTestStepsDetails(tcIds);
        Map stepDetailsByTestCaseId = stepsData.stream().map(this::createStepDetail).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        Map calledTestCasePath = stepsData.stream().map(data -> (Long)data[2]).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toSet(), this::getTestCasePathByIds));
        return stepDetailsByTestCaseId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.createInternalStepModels((List)entry.getValue(), calledTestCasePath)));
    }

    private Map<Long, String> getTestCasePathByIds(Set<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.pathHeaderDao.buildTestCasePathByIds(ids, "/").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> "/" + (String)entry.getValue()));
    }

    private Map.Entry<Long, StepDetail> createStepDetail(Object[] data) {
        Long testCaseId = (Long)data[0];
        String stepType = (String)data[1];
        Long calledTC = (Long)data[2];
        Boolean delegates = (Boolean)data[3];
        StepDetail stepDetail = new StepDetail(stepType, calledTC, delegates);
        return Map.entry(testCaseId, stepDetail);
    }

    private List<InternalStepModel> createInternalStepModels(List<StepDetail> stepDetails, Map<Long, String> calledTestCasePath) {
        return stepDetails.stream().map(stepDetail -> {
            StepType type = StepType.valueOf(stepDetail.stepType);
            TestCaseTarget calledTC = null;
            boolean delegates = false;
            if (type == StepType.CALL) {
                if (stepDetail.calledTestCase != null) {
                    String path = (String)calledTestCasePath.get(stepDetail.calledTestCase);
                    calledTC = new TestCaseTarget(path);
                }
                delegates = stepDetail.delegate;
            }
            return new InternalStepModel(type, calledTC, delegates);
        }).collect(Collectors.toList());
    }

    private void swapNameForPath(Collection<LibraryGraph.SimpleNode<NamedReference>> references) {
        ArrayList<LibraryGraph.SimpleNode<NamedReference>> listedRefs = new ArrayList<LibraryGraph.SimpleNode<NamedReference>>(references);
        List ids = (List)CollectionUtils.collect(listedRefs, (Transformer)NamedReferenceIdCollector.INSTANCE);
        List<String> paths = this.finderService.getPathsAsString(ids);
        int i = 0;
        while (i < paths.size()) {
            LibraryGraph.SimpleNode currentNode = (LibraryGraph.SimpleNode)listedRefs.get(i);
            Long id = (Long)ids.get(i);
            String path = paths.get(i);
            currentNode.setKey((Object)new NamedReference(id, path));
            ++i;
        }
    }

    private static final class InternalStepModel {
        private StepType type;
        private TestCaseTarget calledTC;
        private Boolean delegates = null;

        public InternalStepModel(StepType type, TestCaseTarget calledTC) {
            this.type = type;
            this.calledTC = calledTC;
        }

        public InternalStepModel(StepType type, TestCaseTarget calledTC, boolean delegates) {
            this.type = type;
            this.calledTC = calledTC;
            this.delegates = delegates;
        }

        public void setDelegates(boolean delegates) {
            this.delegates = delegates;
        }

        public boolean getDeleguates() {
            return this.delegates;
        }

        public TestCaseTarget getCalledTC() {
            return this.calledTC;
        }

        public void setCalledTC(TestCaseTarget calledTC) {
            this.calledTC = calledTC;
        }

        public StepType getType() {
            return this.type;
        }
    }

    private static final class NamedReferenceIdCollector
    implements Transformer {
        private static final NamedReferenceIdCollector INSTANCE = new NamedReferenceIdCollector();

        private NamedReferenceIdCollector() {
        }

        public Long transform(Object input) {
            return ((NamedReference)((LibraryGraph.SimpleNode)input).getKey()).getId();
        }
    }

    private static final class PathCollector
    implements Transformer {
        private static final PathCollector INSTANCE = new PathCollector();

        private PathCollector() {
        }

        public Object transform(Object value) {
            return ((TestCaseTarget)value).getPath();
        }
    }

    private static final class RequirementPathCollector
    implements Transformer {
        private static final RequirementPathCollector INSTANCE = new RequirementPathCollector();

        private RequirementPathCollector() {
        }

        public Object transform(Object value) {
            return ((RequirementVersionTarget)value).getRequirement().getPath();
        }
    }

    private record StepDetail(String stepType, Long calledTestCase, boolean delegate) {
    }
}

