/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchimport;

import org.apache.commons.lang3.StringUtils;
import org.squashtest.tm.service.importer.EntityType;
import org.squashtest.tm.service.importer.Target;
import org.squashtest.tm.service.importer.WithPath;
import org.squashtest.tm.service.internal.batchimport.TestCaseTarget;

public class DatasetTarget
implements Target,
WithPath {
    private final TestCaseTarget testCase;
    private String name;

    public DatasetTarget() {
        this.testCase = new TestCaseTarget();
    }

    public DatasetTarget(TestCaseTarget testCase, String name) {
        this.testCase = testCase;
        this.name = name;
    }

    @Override
    public EntityType getType() {
        return EntityType.DATASET;
    }

    public TestCaseTarget getTestCase() {
        return this.testCase;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.testCase == null ? 0 : this.testCase.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatasetTarget other = (DatasetTarget)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.testCase == null ? other.testCase != null : !this.testCase.equals(other.testCase));
    }

    @Override
    public boolean isWellFormed() {
        return this.testCase.isWellFormed() && !StringUtils.isBlank((CharSequence)this.name);
    }

    @Override
    public String getProject() {
        return this.testCase.getProject();
    }

    @Override
    public String getPath() {
        return String.valueOf(this.testCase.getPath()) + "/datasets/" + this.name;
    }

    public void setPath(String path) {
        this.testCase.setPath(path);
    }

    public String toString() {
        return this.getPath();
    }
}

