/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.service.internal.batchexport;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.internal.batchexport.models.CoverageModel;
import org.squashtest.tm.service.internal.batchexport.models.ExportModel;
import org.squashtest.tm.service.internal.batchexport.models.LinkedLowLevelRequirementModel;
import org.squashtest.tm.service.internal.batchexport.models.RequirementExportModel;
import org.squashtest.tm.service.internal.batchexport.models.RequirementLinkModel;
import org.squashtest.tm.service.internal.batchexport.models.RequirementModel;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.LinkedLowLevelRequirementsSheetColumn;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementLinksSheetColumn;
import org.squashtest.tm.service.internal.batchimport.requirement.excel.RequirementSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.CoverageSheetColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateColumn;
import org.squashtest.tm.service.internal.batchimport.testcase.excel.TemplateWorksheet;
import org.squashtest.tm.service.internal.dto.NumericCufHelper;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;

@Component
@Scope(value="prototype")
public class RequirementExcelExporter {
    private static final String REQUIREMENT_SHEET = TemplateWorksheet.REQUIREMENT_SHEET.sheetName;
    private static final String COV_SHEET = TemplateWorksheet.COVERAGE_SHEET.sheetName;
    private static final String REQ_LINK_SHEET = TemplateWorksheet.REQUIREMENT_LINKS_SHEET.sheetName;
    private static final String LINKED_LOW_LEVEL_REQS_SHEET = TemplateWorksheet.LINKED_LOW_LEVEL_REQS_SHEET.sheetName;
    private static final List<LinkedLowLevelRequirementsSheetColumn> LINKED_LOW_LEVEL_REQUIREMENTS_SHEET_COLUMNS = Arrays.asList(LinkedLowLevelRequirementsSheetColumn.HIGH_LEVEL_REQ_PATH, LinkedLowLevelRequirementsSheetColumn.STANDARD_REQ_PATH);
    private static final List<RequirementLinksSheetColumn> LINKS_COLUMNS = Arrays.asList(RequirementLinksSheetColumn.REQ_PATH, RequirementLinksSheetColumn.REQ_VERSION_NUM, RequirementLinksSheetColumn.RELATED_REQ_PATH, RequirementLinksSheetColumn.RELATED_REQ_VERSION_NUM, RequirementLinksSheetColumn.RELATED_REQ_ROLE);
    private static final List<CoverageSheetColumn> COVERAGE_COLUMNS = Arrays.asList(CoverageSheetColumn.REQ_PATH, CoverageSheetColumn.REQ_VERSION_NUM, CoverageSheetColumn.TC_PATH);
    private static final RequirementSheetColumn[] BASIC_REQ_COLUMNS = new RequirementSheetColumn[]{RequirementSheetColumn.PROJECT_ID, RequirementSheetColumn.PROJECT_NAME, RequirementSheetColumn.REQ_PATH, RequirementSheetColumn.REQ_NUM, RequirementSheetColumn.REQ_ID, RequirementSheetColumn.REQ_VERSION_NUM, RequirementSheetColumn.REQ_VERSION_ID, RequirementSheetColumn.REQ_VERSION_REFERENCE, RequirementSheetColumn.REQ_VERSION_NAME, RequirementSheetColumn.REQ_NATURE, RequirementSheetColumn.REQ_VERSION_CRITICALITY, RequirementSheetColumn.REQ_VERSION_CATEGORY, RequirementSheetColumn.REQ_VERSION_STATUS, RequirementSheetColumn.REQ_VERSION_DESCRIPTION, RequirementSheetColumn.REQ_VERSION_NB_TC, RequirementSheetColumn.REQ_VERSION_NB_ATTACHEMENT, RequirementSheetColumn.REQ_VERSION_CREATED_ON, RequirementSheetColumn.REQ_VERSION_CREATED_BY, RequirementSheetColumn.REQ_VERSION_LAST_MODIFIED_ON, RequirementSheetColumn.REQ_VERSION_LAST_MODIFIED_BY};
    private static final List<RequirementSheetColumn> REQUIREMENT_COLUMNS_MILESTONES = Arrays.asList((RequirementSheetColumn[])ArrayUtils.add((Object[])BASIC_REQ_COLUMNS, (Object)RequirementSheetColumn.REQ_VERSION_MILESTONE));
    private static final List<RequirementSheetColumn> REQUIREMENT_COLUMNS = Arrays.asList(BASIC_REQ_COLUMNS);
    private Map<String, Integer> cufColumnsByCode = new HashMap<String, Integer>();
    private Workbook workbook;
    protected boolean milestonesEnabled;
    private MessageSource messageSource;
    private String errorCellTooLargeMessage;

    @Inject
    public RequirementExcelExporter(FeatureManager featureManager, MessageSource messageSource) {
        this.milestonesEnabled = featureManager.isEnabled(FeatureManager.Feature.MILESTONE);
        this.createWorkbook();
        this.createHeaders();
    }

    void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.errorCellTooLargeMessage = this.messageSource.getMessage("test-case.export.errors.celltoolarge", null, LocaleContextHolder.getLocale());
    }

    public void appendToWorkbook(RequirementExportModel model, boolean keepRteFormat) {
        if (!keepRteFormat) {
            this.removeRteFormat(model);
        }
        this.sort(model);
        this.appendRequirementModel(model, keepRteFormat);
        this.appendCoverage(model);
        this.appendLinks(model);
        this.appendLinkedLowLevelReqs(model);
    }

    private void sort(RequirementExportModel model) {
        Collections.sort(model.getCoverages(), CoverageModel.REQ_COMPARATOR);
        Collections.sort(model.getRequirementsModels(), RequirementModel.COMPARATOR);
        Collections.sort(model.getReqLinks(), RequirementLinkModel.REQ_LINK_COMPARATOR);
        Collections.sort(model.getLinkedLowLevelReqs(), LinkedLowLevelRequirementModel.LINKED_LOW_LEVEL_REQ_COMPARATOR);
    }

    private void appendCoverage(RequirementExportModel model) {
        List<CoverageModel> models = model.getCoverages();
        Sheet covSheet = this.workbook.getSheet(COV_SHEET);
        int rIdx = covSheet.getLastRowNum() + 1;
        int cIdx = 0;
        for (CoverageModel cm : models) {
            Row r = covSheet.createRow(rIdx);
            r.createCell(cIdx++).setCellValue(cm.getReqPath());
            r.createCell(cIdx++).setCellValue((double)cm.getRequirementVersionNumber());
            r.createCell(cIdx++).setCellValue(cm.getTcPath());
            ++rIdx;
            cIdx = 0;
        }
    }

    private void appendLinks(RequirementExportModel model) {
        List<RequirementLinkModel> models = model.getReqLinks();
        Sheet linkSheet = this.workbook.getSheet(REQ_LINK_SHEET);
        int rIdx = linkSheet.getLastRowNum() + 1;
        int cIdx = 0;
        for (RequirementLinkModel lm : models) {
            Row r = linkSheet.createRow(rIdx);
            r.createCell(cIdx++).setCellValue(lm.getReqPath());
            r.createCell(cIdx++).setCellValue((double)lm.getReqVersion());
            r.createCell(cIdx++).setCellValue(lm.getRelReqPath());
            r.createCell(cIdx++).setCellValue((double)lm.getRelReqVersion());
            r.createCell(cIdx++).setCellValue(lm.getRelatedReqRole());
            ++rIdx;
            cIdx = 0;
        }
    }

    private void appendLinkedLowLevelReqs(RequirementExportModel model) {
        List<LinkedLowLevelRequirementModel> models = model.getLinkedLowLevelReqs();
        Sheet linkedLowLevelReqsSheet = this.workbook.getSheet(LINKED_LOW_LEVEL_REQS_SHEET);
        int rIdx = linkedLowLevelReqsSheet.getLastRowNum() + 1;
        int cIdx = 0;
        for (LinkedLowLevelRequirementModel m : models) {
            Row r = linkedLowLevelReqsSheet.createRow(rIdx);
            r.createCell(cIdx++).setCellValue(m.getHighLevelReqPath());
            r.createCell(cIdx++).setCellValue(m.getLinkedLowLevelReqPath());
            ++rIdx;
            cIdx = 0;
        }
    }

    private void appendRequirementModel(RequirementExportModel model, boolean keepRteFormat) {
        List<RequirementModel> models = model.getRequirementsModels();
        Sheet reqSheet = this.workbook.getSheet(REQUIREMENT_SHEET);
        int rowIndex = reqSheet.getLastRowNum() + 1;
        for (RequirementModel reqModel : models) {
            this.appendOneRequirement(reqSheet, rowIndex, reqModel, keepRteFormat);
            ++rowIndex;
        }
    }

    private void createCoverageHeaders() {
        this.createSheetHeaders(COV_SHEET, COVERAGE_COLUMNS);
    }

    private void createLinksHeaders() {
        this.createSheetHeaders(REQ_LINK_SHEET, LINKS_COLUMNS);
    }

    private void createLinkedLowLevelReqsHeaders() {
        this.createSheetHeaders(LINKED_LOW_LEVEL_REQS_SHEET, LINKED_LOW_LEVEL_REQUIREMENTS_SHEET_COLUMNS);
    }

    private void createSheetHeaders(String sheetName, List<? extends TemplateColumn> cols) {
        Sheet dsSheet = this.workbook.getSheet(sheetName);
        Row h = dsSheet.createRow(0);
        int cIdx = 0;
        for (TemplateColumn templateColumn : cols) {
            h.createCell(cIdx++).setCellValue(templateColumn.getHeader());
        }
    }

    protected int doOptionalCreateSheetHeader(Row h, int cIdx) {
        return cIdx;
    }

    private void createRequirementHeaders() {
        List<RequirementSheetColumn> columns = this.milestonesEnabled ? REQUIREMENT_COLUMNS_MILESTONES : REQUIREMENT_COLUMNS;
        this.createSheetHeaders(REQUIREMENT_SHEET, columns);
        Sheet dsSheet = this.workbook.getSheet(REQUIREMENT_SHEET);
        Row r = dsSheet.getRow(0);
        short idx = r.getLastCellNum();
        this.doOptionalCreateSheetHeader(r, idx);
    }

    private void appendOneRequirement(Sheet reqSheet, int rowIndex, RequirementModel reqModel, boolean keepRteFormat) {
        Row row = reqSheet.createRow(rowIndex);
        int colIndex = 0;
        try {
            row.createCell(colIndex++).setCellValue((double)reqModel.getProjectId().longValue());
            row.createCell(colIndex++).setCellValue(reqModel.getProjectName());
            row.createCell(colIndex++).setCellValue(reqModel.getPath());
            row.createCell(colIndex++).setCellValue((double)reqModel.getRequirementIndex());
            row.createCell(colIndex++).setCellValue((double)reqModel.getRequirementId().longValue());
            row.createCell(colIndex++).setCellValue((double)reqModel.getRequirementVersionNumber());
            row.createCell(colIndex++).setCellValue((double)reqModel.getId().longValue());
            row.createCell(colIndex++).setCellValue(reqModel.getReference());
            row.createCell(colIndex++).setCellValue(reqModel.getName());
            row.createCell(colIndex++).setCellValue(reqModel.getNature().toString());
            row.createCell(colIndex++).setCellValue(reqModel.getCriticality().toString());
            row.createCell(colIndex++).setCellValue(reqModel.getCategoryCode());
            row.createCell(colIndex++).setCellValue(reqModel.getStatus().toString());
            row.createCell(colIndex++).setCellValue((String)StringUtils.defaultIfBlank((CharSequence)this.formatRichTextField(reqModel.getDescription(), keepRteFormat), (CharSequence)""));
            row.createCell(colIndex++).setCellValue((double)reqModel.getRequirementVersionCoveragesSize().longValue());
            row.createCell(colIndex++).setCellValue((double)reqModel.getAttachmentListSize().longValue());
            row.createCell(colIndex++).setCellValue(this.format(reqModel.getCreatedOn()));
            row.createCell(colIndex++).setCellValue(reqModel.getCreatedBy());
            row.createCell(colIndex++).setCellValue(this.format(reqModel.getLastModifiedOn()));
            row.createCell(colIndex++).setCellValue(reqModel.getLastModifiedBy());
            if (this.milestonesEnabled) {
                row.createCell(colIndex++).setCellValue(reqModel.getMilestonesLabels());
            }
            this.appendCustomFields(row, "REQ_VERSION_CUF_", reqModel.getCufs(), keepRteFormat);
            colIndex = this.doOptionalAppendRequirement(row, colIndex, reqModel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            reqSheet.removeRow(row);
            row = reqSheet.createRow(rowIndex);
            row.createCell(0).setCellValue(this.errorCellTooLargeMessage);
        }
    }

    private String formatRichTextField(String text, boolean keepRteFormat) {
        return keepRteFormat ? text : HtmlUtils.htmlUnescape((String)text);
    }

    protected int doOptionalAppendRequirement(Row row, int colIndex, RequirementModel reqModel) {
        return colIndex;
    }

    private void removeRteFormat(RequirementExportModel model) {
        this.removeRteFormatFromRequirement(model.getRequirementsModels());
    }

    private void removeRteFormatFromRequirement(List<RequirementModel> requirementsModels) {
        for (RequirementModel requirementModel : requirementsModels) {
            requirementModel.setDescription(HTMLCleanupUtils.removeHtml(requirementModel.getDescription()));
            for (ExportModel.CustomField cf : requirementModel.getCufs()) {
                cf.setValue(HTMLCleanupUtils.removeHtml(cf.getValue()));
            }
        }
    }

    public File print() {
        try {
            File temp = File.createTempFile("req_export_", "xls");
            temp.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(temp);
            this.workbook.write((OutputStream)fos);
            fos.close();
            return temp;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void appendCustomFields(Row r, String codePrefix, List<ExportModel.CustomField> cufs, boolean keepRteFormat) {
        for (ExportModel.CustomField cuf : cufs) {
            String code = String.valueOf(codePrefix) + cuf.getCode();
            Integer idx = this.cufColumnsByCode.get(code);
            if (idx == null) {
                idx = this.registerCuf(r.getSheet(), code);
            }
            Cell c = r.createCell(idx.intValue());
            String value = this.nullSafeValue(cuf);
            if (cuf.getType().equals((Object)InputType.NUMERIC)) {
                value = NumericCufHelper.formatOutputNumericCufValue(value);
            } else if (cuf.getType().equals((Object)InputType.RICH_TEXT)) {
                value = this.formatRichTextField(value, keepRteFormat);
            }
            c.setCellValue(value);
        }
    }

    private String nullSafeValue(ExportModel.CustomField customField) {
        String value = customField.getValue();
        return value == null ? "" : value;
    }

    private int registerCuf(Sheet sheet, String code) {
        Row headers = sheet.getRow(0);
        short nextIdx = headers.getLastCellNum();
        headers.createCell((int)nextIdx).setCellValue(code);
        this.cufColumnsByCode.put(code, Integer.valueOf(nextIdx));
        return nextIdx;
    }

    private String format(Date date) {
        if (date == null) {
            return "";
        }
        return DateUtils.formatIso8601Date((Date)date);
    }

    private void createWorkbook() {
        HSSFWorkbook wb = new HSSFWorkbook();
        wb.createSheet(REQUIREMENT_SHEET);
        wb.createSheet(COV_SHEET);
        wb.createSheet(REQ_LINK_SHEET);
        wb.createSheet(LINKED_LOW_LEVEL_REQS_SHEET);
        this.workbook = wb;
    }

    private void createHeaders() {
        this.createRequirementHeaders();
        this.createCoverageHeaders();
        this.createLinksHeaders();
        this.createLinkedLowLevelReqsHeaders();
    }
}

